/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.error;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.osivia.portal.api.error.Debug;

public class ErrorDescriptor {
    public static final int NO_HTTP_ERR_CODE = -1;
    private String token;
    protected Date registrationDate = new Date();
    protected int httpErrCode;
    protected Throwable exception;
    protected String msg;
    protected String userId;
    protected Map<String, Object> properties;

    public ErrorDescriptor(int httpErrCode, Throwable exception, String msg, String userId, Map<String, Object> properties) {
        this.httpErrCode = httpErrCode;
        this.exception = exception;
        this.msg = msg;
        this.userId = userId;
        this.properties = new HashMap<String, Object>();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Date getDate() {
        return this.registrationDate;
    }

    public int getHttpErrCode() {
        return this.httpErrCode;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getStack() {
        return Debug.stackTraceToString(this.exception);
    }

    public String getUserId() {
        return this.userId;
    }

    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>(this.properties);
    }

    public String getProperty(String key) {
        Object value = this.properties.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }
}

