/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.html;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.HTMLWriter;
import org.dom4j.io.OutputFormat;
import org.osivia.portal.api.html.AccessibilityRoles;

public final class DOM4JUtils {
    private DOM4JUtils() {
        throw new AssertionError();
    }

    public static Element generateElement(String name, String htmlClass, String text, String glyphicon, AccessibilityRoles role) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        DOMElement element = new DOMElement(QName.get((String)name));
        DOM4JUtils.addAttribute((Element)element, "class", htmlClass);
        DOM4JUtils.addGlyphiconText((Element)element, glyphicon, text);
        if (role != null) {
            DOM4JUtils.addAttribute((Element)element, "role", role.getValue());
        }
        return element;
    }

    public static Element generateElement(String name, String htmlClass, String text) {
        return DOM4JUtils.generateElement(name, htmlClass, text, null, null);
    }

    public static Element generateDivElement(String htmlClass, AccessibilityRoles role) {
        return DOM4JUtils.generateElement("div", htmlClass, "", null, role);
    }

    public static Element generateDivElement(String htmlClass) {
        return DOM4JUtils.generateDivElement(htmlClass, null);
    }

    public static Element generateLinkElement(String href, String target, String onclick, String htmlClass, String text, String glyphicon, AccessibilityRoles role) {
        Element link = DOM4JUtils.generateElement("a", htmlClass, text, glyphicon, role);
        DOM4JUtils.addAttribute(link, "target", target);
        DOM4JUtils.addAttribute(link, "onclick", onclick);
        if (href == null) {
            DOM4JUtils.addAttribute(link, "href", "#");
        } else {
            DOM4JUtils.addAttribute(link, "href", href);
        }
        return link;
    }

    public static Element generateLinkElement(String href, String target, String onclick, String htmlClass, String text, String glyphicon) {
        return DOM4JUtils.generateLinkElement(href, target, onclick, htmlClass, text, glyphicon, null);
    }

    public static Element generateLinkElement(String href, String target, String onclick, String htmlClass, String text) {
        return DOM4JUtils.generateLinkElement(href, target, onclick, htmlClass, text, null, null);
    }

    public static void addAttribute(Element element, String name, String value) {
        if (element == null || StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        if (value != null) {
            element.addAttribute(QName.get((String)name), value);
        }
    }

    public static void addDataAttribute(Element element, String name, String value) {
        DOM4JUtils.addAttribute(element, "data-" + name, value);
    }

    public static void addAriaAttribute(Element element, String name, String value) {
        DOM4JUtils.addAttribute(element, "aria-" + name, value);
    }

    public static void addText(Element element, String text) {
        if (element == null) {
            return;
        }
        if (text != null) {
            element.addText(text);
        }
    }

    public static void addGlyphiconText(Element element, String glyphicon, String text) {
        if (element == null) {
            return;
        }
        if (glyphicon != null) {
            Element glyph = DOM4JUtils.generateElement("i", glyphicon, "");
            element.add(glyph);
            if (text != null) {
                String htmlClass = null;
                String elementHTMLClass = element.attributeValue(QName.get((String)"class"));
                if (elementHTMLClass != null && Arrays.asList(StringUtils.split((String)elementHTMLClass)).contains("btn")) {
                    htmlClass = "hidden-xs";
                }
                Element textSpan = DOM4JUtils.generateElement("span", htmlClass, text);
                element.add(textSpan);
            }
        } else {
            DOM4JUtils.addText(element, text);
        }
    }

    public static void addTooltip(Element element, String title) {
        if (element == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)title)) {
            DOM4JUtils.addAttribute(element, "title", title);
            DOM4JUtils.addAttribute(element, "data-toggle", "tooltip");
            DOM4JUtils.addAttribute(element, "data-placement", "bottom");
        }
    }

    public static String write(Element element) {
        String html;
        try {
            StringWriter stringWriter = new StringWriter();
            HTMLWriter htmlWriter = new HTMLWriter((Writer)stringWriter);
            htmlWriter.setEscapeText(false);
            htmlWriter.write(element);
            htmlWriter.flush();
            html = stringWriter.toString();
        }
        catch (IOException e) {
            html = "";
        }
        return html;
    }

    public static String writeCompact(Element element) {
        String html;
        try {
            StringWriter stringWriter = new StringWriter();
            HTMLWriter htmlWriter = new HTMLWriter((Writer)stringWriter, OutputFormat.createCompactFormat());
            htmlWriter.setEscapeText(false);
            htmlWriter.write(element);
            htmlWriter.flush();
            html = stringWriter.toString();
        }
        catch (IOException e) {
            html = "";
        }
        return html;
    }

    public static void write(Writer writer, Element element) {
        HTMLWriter htmlWriter = new HTMLWriter(writer);
        htmlWriter.setEscapeText(false);
        try {
            htmlWriter.write(element);
            htmlWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

