/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.list;

import bsh.EvalError;
import bsh.Interpreter;
import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.feed.rss.Channel;
import com.rometools.rome.feed.rss.Description;
import com.rometools.rome.feed.rss.Enclosure;
import com.rometools.rome.feed.rss.Guid;
import com.rometools.rome.feed.rss.Item;
import com.rometools.rome.io.WireFeedOutput;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPrivilegedModule;
import fr.toutatice.portail.cms.nuxeo.api.portlet.ViewList;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.list.DocumentPathComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.list.DocumentWebidComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.list.ListCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.list.ListConfiguration;
import fr.toutatice.portail.cms.nuxeo.portlets.list.NXQLFormater;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.server.AbstractServerURL;
import org.jboss.portal.server.ServerURL;
import org.jboss.portal.server.request.URLFormat;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.sequencing.IPortletSequencingService;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;

public class ViewListPortlet
extends ViewList {
    private static final int DEFAULT_REQUEST_PAGE_SIZE = 100;
    private static final int DEFAULT_RSS_RESULTS_LIMIT = 10;
    private static final String PATH_ADMIN = "/WEB-INF/jsp/list/admin.jsp";
    protected static final String PATH_VIEW = "/WEB-INF/jsp/list/view.jsp";
    protected static final String INFINITE_VIEW = "/WEB-INF/jsp/list/view-infinite-scroll.jsp";
    private static final String SETS_PROPERTY = "sets:sets";
    private static final String LIST_WEBID_PROPERTY = "webids";
    private static final String NAME_PROPERTY = "name";
    private static final String WEBID_PROPERTY = "ttc:webid";
    private static final String FEED_TYPE_RSS_2_0 = "rss_2.0";
    private final INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    private IBundleFactory bundleFactory;
    private DocumentDAO documentDAO;
    private IPortletSequencingService portletSequencingService;
    private final ITaskbarService taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.documentDAO = DocumentDAO.getInstance();
        this.portletSequencingService = (IPortletSequencingService)Locator.findMBean(IPortletSequencingService.class, (String)"osivia:service=PortletSequencingService");
    }

    public ListTemplate getCurrentTemplate(Locale locale, ListConfiguration configuration) {
        INuxeoCustomizer customizer = this.nuxeoService.getCMSCustomizer();
        String currentTemplateName = configuration.getTemplate();
        if (currentTemplateName == null) {
            currentTemplateName = "normal";
        }
        ListTemplate currentTemplate = null;
        ListTemplate defaultTemplate = null;
        List templates = customizer.getListTemplates(locale);
        for (ListTemplate template : templates) {
            if (currentTemplateName.equals(template.getKey())) {
                currentTemplate = template;
                break;
            }
            if (!"normal".equals(template.getKey())) continue;
            defaultTemplate = template;
        }
        if (currentTemplate == null) {
            currentTemplate = defaultTemplate;
        }
        return currentTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        block33: {
            try {
                PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
                NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                ListConfiguration configuration = this.getConfiguration(window);
                ListTemplate template = this.getCurrentTemplate(request.getLocale(), configuration);
                IPortletModule module = template.getModule();
                String filter = null;
                if (module != null && module instanceof IPrivilegedModule) {
                    IPrivilegedModule privilegedModule = (IPrivilegedModule)module;
                    nuxeoController.setAuthType(privilegedModule.getAuthType());
                    nuxeoController.setCacheType(privilegedModule.getCacheType());
                    filter = privilegedModule.getFilter(portalControllerContext);
                }
                boolean requestExecution = false;
                PaginableDocuments documents = null;
                int resultsLimit = 100;
                if ("rss".equals(request.getParameter("type"))) {
                    resultsLimit = 10;
                    requestExecution = true;
                }
                if ("true".equals(request.getParameter("injectdocs"))) {
                    requestExecution = true;
                    String limit = request.getParameter("limit");
                    if (limit != null) {
                        resultsLimit = Integer.parseInt(limit);
                    } else if (WindowState.MAXIMIZED.equals((Object)request.getWindowState()) && configuration.getMaximizedPagination() != null) {
                        resultsLimit = configuration.getMaximizedPagination();
                    } else if (configuration.getNormalPagination() != null) {
                        resultsLimit = configuration.getNormalPagination();
                    }
                }
                if (requestExecution) {
                    String nuxeoRequest = configuration.getNuxeoRequest();
                    if (configuration.isBeanShell()) {
                        Interpreter interpreter = new Interpreter();
                        interpreter.set("params", (Object)PageSelectors.decodeProperties((String)request.getParameter("selectors")));
                        interpreter.set("request", (Object)request);
                        interpreter.set("NXQLFormater", (Object)new NXQLFormater(nuxeoController));
                        interpreter.set("basePath", (Object)nuxeoController.getBasePath());
                        interpreter.set("spacePath", (Object)nuxeoController.getSpacePath());
                        interpreter.set("navigationPath", (Object)nuxeoController.getNavigationPath());
                        interpreter.set("contentPath", (Object)nuxeoController.getContentPath());
                        interpreter.set("spaceId", null);
                        if (nuxeoController.getNavigationPath() != null) {
                            CMSPublicationInfos navigationPubInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), nuxeoController.getNavigationPath());
                            interpreter.set("navigationPubInfos", (Object)navigationPubInfos);
                            interpreter.set("spaceId", (Object)navigationPubInfos.getSpaceID());
                        }
                        nuxeoRequest = (String)interpreter.eval(nuxeoRequest);
                    }
                    if (nuxeoRequest != null) {
                        int currentPage = NumberUtils.toInt((String)request.getParameter("currentPage"));
                        request.setAttribute("currentPage", (Object)currentPage);
                        String schemas = template.getSchemas();
                        nuxeoRequest = this.applyFilter(nuxeoRequest, filter);
                        ListCommand command = new ListCommand(nuxeoRequest, nuxeoController.getDisplayLiveVersion(), currentPage, resultsLimit, schemas, configuration.getContentFilter());
                        command.setForceVCS(configuration.isForceVCS());
                        documents = (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                        ArrayList<DocumentDTO> documentsDTO = new ArrayList<DocumentDTO>(documents.size());
                        for (Document document : documents) {
                            DocumentDTO documentDTO = this.documentDAO.toDTO(portalControllerContext, document);
                            documentsDTO.add(documentDTO);
                        }
                        request.setAttribute("documents", documentsDTO);
                    }
                }
                if ("rss".equals(request.getParameter("type"))) {
                    if (documents != null) {
                        ControllerContext controllerContext = ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext);
                        Portal portal = PortalObjectUtils.getPortal((ControllerContext)controllerContext);
                        Locale locale = request.getLocale();
                        Bundle bundle = this.getBundleFactory().getBundle(locale);
                        String portalUrl = this.getAbsoluteUrl(controllerContext, "");
                        String portalTitleKey = StringUtils.defaultIfEmpty((String)portal.getDeclaredProperty("osivia.brand.key"), (String)"BRAND");
                        String portalTitle = bundle.getString(portalTitleKey);
                        String windowTitle = window.getProperty("osivia.title");
                        Date currentDate = new Date();
                        Channel channel = new Channel();
                        channel.setFeedType(FEED_TYPE_RSS_2_0);
                        channel.setTitle(windowTitle);
                        channel.setLink(portalUrl);
                        channel.setDescription(portalTitle);
                        channel.setLastBuildDate(currentDate);
                        if (locale != null) {
                            channel.setLanguage(locale.toLanguageTag());
                        }
                        ArrayList<Item> items = new ArrayList<Item>(documents.size());
                        channel.setItems(items);
                        for (Document document : documents) {
                            Item item = new Item();
                            String title = StringUtils.defaultIfEmpty((String)document.getTitle(), (String)document.getId());
                            item.setTitle(title);
                            String url = this.getPortalUrlFactory().getPermaLink(portalControllerContext, null, null, document.getPath(), "cms");
                            item.setLink(url);
                            Guid guid = new Guid();
                            guid.setValue(url);
                            guid.setPermaLink(true);
                            item.setGuid(guid);
                            Description description = new Description();
                            if (StringUtils.isNotEmpty((String)document.getString("annonce:resume"))) {
                                description.setType("text/html");
                                description.setValue(document.getString("annonce:resume"));
                            } else {
                                description.setType("text/plain");
                                description.setValue(document.getString("dc:description", ""));
                            }
                            item.setDescription(description);
                            Enclosure enclosure = this.createEnclosure(controllerContext, nuxeoController, document, "annonce:image");
                            if (enclosure == null) {
                                enclosure = this.createEnclosure(controllerContext, nuxeoController, document, "ttc:vignette");
                            }
                            if (enclosure != null) {
                                ArrayList<Enclosure> enclosures = new ArrayList<Enclosure>(1);
                                enclosures.add(enclosure);
                                item.setEnclosures(enclosures);
                            }
                            item.setPubDate(document.getDate("dc:modified"));
                            items.add(item);
                        }
                        WireFeedOutput output = new WireFeedOutput();
                        OutputStreamWriter writer = null;
                        try {
                            response.setContentType("application/xml");
                            writer = new OutputStreamWriter(response.getPortletOutputStream());
                            output.output((WireFeed)channel, (Writer)writer);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(writer);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Writer)writer);
                        break block33;
                    }
                    throw new IllegalArgumentException("No request defined for RSS");
                }
                if (module != null) {
                    ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(module.getClassLoader());
                    try {
                        module.serveResource(portalControllerContext);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(savedClassLoader);
                    }
                }
                if ("loadMore".equals(request.getResourceID())) {
                    this.includeJsp(request, response, template, module);
                } else if (!response.isCommitted()) {
                    super.serveResource(request, response);
                }
            }
            catch (PortletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    private String getAbsoluteUrl(ControllerContext controllerContext, String path) {
        AbstractServerURL serverUrl = new AbstractServerURL();
        serverUrl.setPortalRequestPath(path);
        URLFormat urlFormat = URLFormat.newInstance((boolean)false, (boolean)true);
        String portalUrl = controllerContext.getServerInvocation().getResponse().renderURL((ServerURL)serverUrl, urlFormat);
        return portalUrl;
    }

    private Enclosure createEnclosure(ControllerContext controllerContext, NuxeoController nuxeoController, Document document, String property) {
        Enclosure enclosure;
        PropertyMap propertyMap = document.getProperties().getMap(property);
        if (propertyMap != null && propertyMap.get("length") != null) {
            String url;
            HttpServletRequest httpServletRequest = controllerContext.getServerInvocation().getServerContext().getClientRequest();
            try {
                url = new URL(httpServletRequest.getScheme(), httpServletRequest.getServerName(), nuxeoController.createFileLink(document, property)).toString();
            }
            catch (MalformedURLException e) {
                url = null;
            }
            if (StringUtils.isEmpty(url)) {
                enclosure = null;
            } else {
                enclosure = new Enclosure();
                enclosure.setType(propertyMap.getString("mime-type"));
                enclosure.setLength(propertyMap.getLong("length").longValue());
                enclosure.setUrl(url);
            }
        } else {
            enclosure = null;
        }
        return enclosure;
    }

    private void includeJsp(ResourceRequest request, ResourceResponse response, ListTemplate template, IPortletModule module) throws PortletException, IOException {
        String customS = module != null ? "custom/" : "";
        PortletContext portletContext = module != null ? module.getPortletContext() : this.getPortletContext();
        response.setContentType("text/html");
        String style = StringUtils.lowerCase((String)template.getKey());
        String viewPath = "/WEB-INF/" + customS + "jsp/list/view-" + style + ".jsp";
        PortletRequestDispatcher dispatcher = portletContext.getRequestDispatcher(viewPath);
        dispatcher.include((PortletRequest)request, (PortletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        String action = request.getParameter("javax.portlet.action");
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                window.setProperty("osivia.nuxeoRequest", StringUtils.trimToNull((String)request.getParameter("nuxeoRequest")));
                window.setProperty("osivia.beanShell", StringUtils.trimToNull((String)request.getParameter("beanShell")));
                window.setProperty("osivia.forceVCS", StringUtils.trimToNull((String)request.getParameter("forceVCS")));
                window.setProperty("osivia.cms.displayLiveVersion", StringUtils.trimToNull((String)request.getParameter("displayLiveVersion")));
                window.setProperty("osivia.cms.requestFilteringPolicy", StringUtils.trimToNull((String)request.getParameter("requestFilteringPolicy")));
                window.setProperty("osivia.cms.scope", StringUtils.trimToNull((String)request.getParameter("scope")));
                boolean displayMetadata = BooleanUtils.toBoolean((String)request.getParameter("metadataDisplay"));
                window.setProperty("osivia.cms.hideMetaDatas", BooleanUtils.toString((boolean)displayMetadata, null, (String)"1"));
                window.setProperty("osivia.displayNuxeoRequest", StringUtils.trimToNull((String)request.getParameter("nuxeoRequestDisplay")));
                window.setProperty("osivia.cms.maxItems", StringUtils.trimToNull((String)request.getParameter("resultsLimit")));
                window.setProperty("osivia.cms.pageSize", StringUtils.trimToNull((String)request.getParameter("normalPagination")));
                window.setProperty("osivia.cms.pageSizeMax", StringUtils.trimToNull((String)request.getParameter("maximizedPagination")));
                window.setProperty("osivia.cms.style", StringUtils.trimToNull((String)request.getParameter("template")));
                window.setProperty("osivia.permaLinkRef", StringUtils.trimToNull((String)request.getParameter("permalinkReference")));
                window.setProperty("osivia.rssLinkRef", StringUtils.trimToNull((String)request.getParameter("rssReference")));
                window.setProperty("osivia.rssTitle", StringUtils.trimToNull((String)request.getParameter("rssTitle")));
                window.setProperty("osivia.createParentPath", StringUtils.trimToNull((String)request.getParameter("creationParentPath")));
                window.setProperty("osivia.createDocType", StringUtils.trimToNull((String)request.getParameter("creationContentType")));
                window.setProperty("osivia.set.id", StringUtils.trimToNull((String)request.getParameter("setType")));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
        ListConfiguration configuration = this.getConfiguration(window);
        ListTemplate template = this.getCurrentTemplate(request.getLocale(), configuration);
        IPortletModule module = template.getModule();
        if (module != null) {
            ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(module.getClassLoader());
            try {
                module.processAction(nuxeoController.getPortalCtx());
            }
            finally {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            INuxeoCustomizer customizer = this.nuxeoService.getCMSCustomizer();
            ListConfiguration configuration = this.getConfiguration(window);
            request.setAttribute("configuration", (Object)configuration);
            request.setAttribute("versions", (Object)nuxeoController.formatDisplayLiveVersionList(configuration.getVersion()));
            request.setAttribute("contentFilters", (Object)nuxeoController.formatRequestFilteringPolicyList(configuration.getContentFilter()));
            request.setAttribute("scopes", (Object)nuxeoController.formatScopeList(configuration.getScope()));
            request.setAttribute("templates", (Object)customizer.getListTemplates(request.getLocale()));
            request.setAttribute("setTypes", (Object)customizer.getSetTypes());
            response.setContentType("text/html");
            PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(this.getPathAdmin());
            dispatcher.include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        String pathView = PATH_VIEW;
        try {
            String nuxeoRequest;
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            ListConfiguration configuration = this.getConfiguration(window);
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            INuxeoCustomizer customizer = this.nuxeoService.getCMSCustomizer();
            ListTemplate template = this.getCurrentTemplate(request.getLocale(), configuration);
            IPortletModule module = template.getModule();
            String filter = null;
            if (module instanceof IPrivilegedModule) {
                IPrivilegedModule privilegedModule = (IPrivilegedModule)module;
                nuxeoController.setAuthType(privilegedModule.getAuthType());
                nuxeoController.setCacheType(privilegedModule.getCacheType());
                filter = privilegedModule.getFilter(portalControllerContext);
            }
            boolean feed = BooleanUtils.toBoolean((String)window.getProperty("osivia.cms.feed"));
            HashMap<String, Integer> feedDocumentsOrder = null;
            boolean webidOrdering = BooleanUtils.toBoolean((String)window.getProperty("osivia.cms.ordering"));
            HashMap<String, Integer> webidOrder = null;
            if (webidOrdering) {
                int size = NumberUtils.toInt((String)window.getProperty("osivia.cms.ordering.size"));
                webidOrder = new HashMap<String, Integer>(size);
                for (int i = 0; i < size; ++i) {
                    webidOrder.put(window.getProperty("osivia.cms.ordering." + i), i);
                }
            }
            if (feed) {
                int size = NumberUtils.toInt((String)window.getProperty("osivia.cms.news.size"));
                feedDocumentsOrder = new HashMap<String, Integer>(size);
                StringBuilder builder = new StringBuilder();
                builder.append("return \"");
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        builder.append(" OR ");
                    }
                    String path = window.getProperty("osivia.cms.news." + i + ".docURI");
                    feedDocumentsOrder.put(path, NumberUtils.toInt((String)window.getProperty("osivia.cms.news." + i + ".order")));
                    builder.append("ecm:path = '").append(path).append("'");
                }
                builder.append("\";");
                nuxeoRequest = builder.toString();
            } else {
                nuxeoRequest = configuration.getNuxeoRequest();
            }
            if (configuration.isBeanShell()) {
                String orginalRequest = nuxeoRequest;
                if ((nuxeoRequest = this.beanShellInterpretation(nuxeoController, nuxeoRequest)) != null && nuxeoRequest.contains("'null") && nuxeoController.getBasePath() == null && (orginalRequest.contains("basePath") || orginalRequest.contains("domainPath") || orginalRequest.contains("spacePath") || orginalRequest.contains("navigationPath"))) {
                    request.setAttribute("error", (Object)"La requ\u00eate ne peut pas \u00eatre interpr\u00e9t\u00e9e en mode template : valeur(s) \u00e0 'null' ");
                }
            }
            boolean sets = StringUtils.isNotEmpty((String)configuration.getSetType());
            Document workspace = null;
            List setsWebidList = null;
            if (sets) {
                String basePath;
                if (nuxeoRequest == null) {
                    nuxeoRequest = "";
                }
                if ((basePath = nuxeoController.getBasePath()) == null) {
                    workspace = null;
                } else {
                    NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(basePath);
                    workspace = documentContext.getDocument();
                }
                if (workspace != null) {
                    PropertyList list = (PropertyList)workspace.getProperties().get(SETS_PROPERTY);
                    if (list != null && list.list().size() > 0) {
                        for (Object map : list.list()) {
                            if (!StringUtils.equals((String)configuration.getSetType(), (String)((PropertyMap)map).getString(NAME_PROPERTY))) continue;
                            PropertyList propertyListWebId = ((PropertyMap)map).getList(LIST_WEBID_PROPERTY);
                            setsWebidList = propertyListWebId.list();
                            break;
                        }
                    }
                    String workspacePath = workspace.getPath();
                    nuxeoRequest = this.addSetClause(nuxeoRequest, setsWebidList, workspacePath);
                } else {
                    nuxeoRequest = nuxeoRequest + "ecm:currentLifeCycleState <> 'deleted' and ecm:currentLifeCycleState = 'deleted' ";
                }
            }
            if ("EMPTY_REQUEST".equals(nuxeoRequest = this.applyFilter(nuxeoRequest, filter))) {
                request.setAttribute("osivia.emptyResponse", (Object)"1");
                request.setAttribute("error", (Object)bundle.getString("LIST_MESSAGE_EMPTY_REQUEST"));
            } else if (nuxeoRequest != null) {
                String dynamicPath;
                DocumentPathComparator comparator;
                String portalPolicyFilter;
                String displayLiveVersion;
                if (configuration.isNuxeoRequestDisplay()) {
                    request.setAttribute("nuxeoRequest", (Object)nuxeoRequest);
                }
                String cmsPath = request.getParameter("osivia.cms.path");
                String selectors = request.getParameter("selectors");
                String lastSelectors = request.getParameter("lastSelectors");
                if ("".equals(selectors)) {
                    selectors = null;
                }
                if ("__NONE__".equals(lastSelectors)) {
                    lastSelectors = null;
                }
                request.setAttribute("lastSelectors", (Object)(StringUtils.isEmpty((String)selectors) ? "__NONE__" : selectors));
                int resultsLimit = configuration.getResultsLimit() == null ? -1 : configuration.getResultsLimit();
                int pageSize = -1;
                int currentPage = 0;
                Integer pageSizeProperty = WindowState.MAXIMIZED.equals((Object)request.getWindowState()) ? configuration.getMaximizedPagination() : configuration.getNormalPagination();
                if (pageSizeProperty != null) {
                    boolean selectorsChanged;
                    pageSize = pageSizeProperty;
                    String currentStateParameter = request.getParameter("currentState");
                    String currentPageParameter = request.getParameter("currentPage");
                    boolean modeChanged = !request.getWindowState().toString().equals(currentStateParameter);
                    boolean bl = selectorsChanged = selectors != null && !selectors.equals(lastSelectors) || selectors == null && lastSelectors != null;
                    if (currentPageParameter != null && !modeChanged && !selectorsChanged) {
                        currentPage = NumberUtils.toInt((String)currentPageParameter);
                    }
                }
                request.setAttribute("currentPage", (Object)currentPage);
                request.setAttribute("templates", (Object)customizer.getListTemplates(request.getLocale()));
                request.setAttribute("style", (Object)StringUtils.lowerCase((String)template.getKey()));
                String schemas = template.getSchemas();
                int requestPageSize = 100;
                if (pageSize > 0) {
                    requestPageSize = pageSize;
                }
                if (resultsLimit > 0 && currentPage == 0) {
                    requestPageSize = Math.min(requestPageSize, resultsLimit);
                }
                if (webidOrdering) {
                    displayLiveVersion = "2";
                    portalPolicyFilter = "none";
                } else {
                    displayLiveVersion = nuxeoController.getDisplayLiveVersion();
                    portalPolicyFilter = configuration.getContentFilter();
                }
                ListCommand command = new ListCommand(nuxeoRequest, displayLiveVersion, currentPage, requestPageSize, schemas, portalPolicyFilter);
                command.setForceVCS(configuration.isForceVCS());
                PaginableDocuments documents = (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                List documentsList = documents.list();
                if (feed) {
                    comparator = new DocumentPathComparator(feedDocumentsOrder);
                    Collections.sort(documentsList, comparator);
                } else if (webidOrdering) {
                    comparator = new DocumentWebidComparator(webidOrder);
                    Collections.sort(documentsList, comparator);
                }
                ArrayList<Object> documentsDTO = new ArrayList<Object>(documentsList.size());
                for (Object document : documentsList) {
                    DocumentDTO documentDTO = this.documentDAO.toDTO(portalControllerContext, (Document)document);
                    documentsDTO.add(documentDTO);
                }
                if (sets) {
                    HashMap mapSets = new HashMap();
                    if (documentsDTO != null) {
                        for (DocumentDTO documentDTO : documentsDTO) {
                            mapSets.put(documentDTO.getProperties().get(WEBID_PROPERTY), documentDTO);
                        }
                    }
                    if (workspace != null && setsWebidList != null) {
                        documentsDTO = new ArrayList(documentsDTO == null ? 0 : documentsDTO.size());
                        for (Object e : setsWebidList) {
                            if (mapSets.get(e) == null) continue;
                            documentsDTO.add(mapSets.get(e));
                        }
                    }
                }
                request.setAttribute("documents", documentsDTO);
                int pagesCount = 0;
                if (pageSize > 0) {
                    int limit;
                    if (resultsLimit > 0) {
                        limit = Math.min(documents.getTotalSize(), resultsLimit);
                        if (documents.size() < (currentPage + 1) * requestPageSize) {
                            int n = Math.max(0, resultsLimit - currentPage * requestPageSize);
                            while (documents.size() > n) {
                                documentsList.remove(documents.size() - 1);
                            }
                        }
                    } else {
                        limit = documents.getTotalSize();
                    }
                    pagesCount = (limit - 1) / pageSize + 1;
                }
                request.setAttribute("nbPages", (Object)pagesCount);
                request.setAttribute("totalSize", (Object)documents.getTotalSize());
                if (StringUtils.isNotBlank((String)configuration.getPermalinkReference())) {
                    String type;
                    String reference = configuration.getPermalinkReference();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    if (selectors != null) {
                        Map decodedSelectors = PageSelectors.decodeProperties((String)selectors);
                        decodedSelectors.remove("selectorChanged");
                        hashMap.put("selectors", PageSelectors.encodeProperties((Map)decodedSelectors));
                    }
                    if (cmsPath == null) {
                        type = "page";
                    } else {
                        type = "cms";
                        reference = null;
                    }
                    String url = nuxeoController.getPortalUrlFactory().getPermaLink(portalControllerContext, reference, hashMap, cmsPath, type);
                    request.setAttribute("permaLinkURL", (Object)url);
                }
                if (StringUtils.isNotBlank((String)configuration.getRssReference())) {
                    boolean anonymousAccess = true;
                    if (cmsPath != null) {
                        CMSServiceCtx cMSServiceCtx = new CMSServiceCtx();
                        cMSServiceCtx.setControllerContext(ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext));
                        cMSServiceCtx.setScope(nuxeoController.getScope());
                        anonymousAccess = NuxeoController.getCMSService().checkContentAnonymousAccess(cMSServiceCtx, cmsPath);
                    }
                    if (anonymousAccess) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        if (selectors != null) {
                            Map selectorsMap = PageSelectors.decodeProperties((String)selectors);
                            selectorsMap.remove("selectorChanged");
                            hashMap.put("selectors", PageSelectors.encodeProperties((Map)selectorsMap));
                        }
                        String url = nuxeoController.getPortalUrlFactory().getPermaLink(portalControllerContext, configuration.getRssReference(), hashMap, cmsPath, "rss");
                        request.setAttribute("rssLinkURL", (Object)url);
                    }
                }
                if ((dynamicPath = window.getProperty("osivia.createParentPath")) == null) {
                    dynamicPath = window.getProperty("osivia.cms.uri");
                }
                if (dynamicPath != null) {
                    dynamicPath = NuxeoController.getLivePath((String)nuxeoController.getComputedPath(dynamicPath));
                    NuxeoDocumentContext nuxeoDocumentContext = nuxeoController.getDocumentContext(dynamicPath);
                    Document folder = nuxeoDocumentContext.getDocument();
                    nuxeoController.setCurrentDoc(folder);
                    response.setTitle(folder.getTitle());
                }
                nuxeoController.insertContentMenuBarItems();
                if (currentPage == 0 && documents.size() == 0) {
                    request.setAttribute("osivia.emptyResponse", (Object)"1");
                }
                if (module != null) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(module.getClassLoader());
                    try {
                        module.doView(portalControllerContext);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(classLoader);
                    }
                }
            } else {
                String bshTitle = (String)request.getAttribute("bsh.title");
                String bshHTML = (String)request.getAttribute("bsh.html");
                if (StringUtils.isNotEmpty((String)bshTitle) || StringUtils.isNotEmpty((String)bshHTML)) {
                    if (StringUtils.isNotEmpty((String)bshTitle)) {
                        response.setTitle(bshTitle);
                    }
                    if (StringUtils.isNotEmpty((String)bshHTML)) {
                        response.setContentType("text/html");
                        response.getWriter().print(bshHTML);
                        response.getWriter().close();
                    }
                    return;
                }
                request.setAttribute("error", (Object)"Requ\u00eate non d\u00e9finie");
            }
            if (configuration.isInfiniteScroll()) {
                pathView = INFINITE_VIEW;
            }
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (EvalError e) {
            request.setAttribute("error", (Object)"LIST_MESSAGE_INVALID_REQUEST");
            request.setAttribute("errorMessage", (Object)e.getMessage());
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(pathView);
        dispatcher.include(request, response);
    }

    private String beanShellInterpretation(NuxeoController nuxeoController, String nuxeoRequest) throws EvalError, CMSException {
        String taskPath;
        PortletRequest request = nuxeoController.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Interpreter interpreter = new Interpreter();
        interpreter.set("params", (Object)PageSelectors.decodeProperties((String)request.getParameter("selectors")));
        interpreter.set("basePath", (Object)nuxeoController.getBasePath());
        interpreter.set("domainPath", (Object)nuxeoController.getDomainPath());
        interpreter.set("spacePath", (Object)nuxeoController.getSpacePath());
        interpreter.set("navigationPath", (Object)nuxeoController.getNavigationPath());
        interpreter.set("navigationPubInfos", null);
        interpreter.set("spaceId", null);
        if (StringUtils.startsWith((String)nuxeoController.getContentPath(), (String)nuxeoController.getNavigationPath()) && nuxeoController.getNavigationPath() != null) {
            CMSPublicationInfos navigationPubInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), nuxeoController.getNavigationPath());
            interpreter.set("navigationPubInfos", (Object)navigationPubInfos);
            interpreter.set("spaceId", (Object)navigationPubInfos.getSpaceID());
        }
        interpreter.set("contentPath", (Object)nuxeoController.getContentPath());
        interpreter.set("request", (Object)request);
        interpreter.set("NXQLFormater", (Object)new NXQLFormater(nuxeoController));
        interpreter.set("navItem", (Object)nuxeoController.getNavigationItem());
        interpreter.set("storage", (Object)this.portletSequencingService.getAttributes(nuxeoController.getPortalCtx()));
        String taskId = window.getProperty("osivia.taskbar.linked.id");
        if (StringUtils.isEmpty((String)taskId)) {
            taskPath = null;
        } else {
            TaskbarTask linkedTask = null;
            try {
                List tasks = this.taskbarService.getTasks(nuxeoController.getPortalCtx(), nuxeoController.getSpacePath());
                for (TaskbarTask task : tasks) {
                    if (!taskId.equals(task.getId())) continue;
                    linkedTask = task;
                    break;
                }
            }
            catch (PortalException portalException) {
                // empty catch block
            }
            taskPath = linkedTask == null ? null : linkedTask.getPath();
        }
        interpreter.set("taskPath", taskPath);
        return (String)interpreter.eval(nuxeoRequest);
    }

    private String addSetClause(String request, List<Object> listWebid, String workspacePath) {
        StringBuilder clause = new StringBuilder();
        clause.append(request);
        clause.append("ecm:path startswith '").append(workspacePath).append("' ");
        clause.append("and ecm:currentLifeCycleState <> 'deleted' ");
        clause.append(" and ttc:webid in (");
        if (listWebid != null && listWebid.size() > 0) {
            Iterator<Object> it = listWebid.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    clause.append(",");
                }
                clause.append("'").append(it.next()).append("'");
                first = false;
            }
        } else {
            clause.append("''");
        }
        clause.append(") ");
        return clause.toString();
    }

    private String applyFilter(String request, String filter) {
        String result;
        if (StringUtils.isBlank((String)filter)) {
            result = request;
        } else {
            Pattern pattern = Pattern.compile("^(.*) ORDER *BY (.*)$", 2);
            Matcher matcher = pattern.matcher(request);
            StringBuilder builder = new StringBuilder();
            builder.append("(").append(filter).append(") AND (");
            if (matcher.matches()) {
                builder.append(matcher.group(1)).append(") ORDER BY ").append(matcher.group(2));
            } else {
                builder.append(request).append(")");
            }
            result = builder.toString();
        }
        return result;
    }

    protected ListConfiguration getConfiguration(PortalWindow window) {
        ListConfiguration configuration = new ListConfiguration();
        configuration.setNuxeoRequest(window.getProperty("osivia.nuxeoRequest"));
        configuration.setBeanShell(BooleanUtils.toBoolean((String)window.getProperty("osivia.beanShell")));
        configuration.setForceVCS(BooleanUtils.toBoolean((String)window.getProperty("osivia.forceVCS")));
        configuration.setVersion(window.getProperty("osivia.cms.displayLiveVersion"));
        configuration.setContentFilter(window.getProperty("osivia.cms.requestFilteringPolicy"));
        configuration.setScope(window.getProperty("osivia.cms.scope"));
        configuration.setMetadataDisplay(BooleanUtils.toBoolean((String)window.getProperty("osivia.cms.hideMetaDatas"), null, (String)"1"));
        configuration.setNuxeoRequestDisplay(BooleanUtils.toBoolean((String)window.getProperty("osivia.displayNuxeoRequest")));
        configuration.setResultsLimit(NumberUtils.createInteger((String)StringUtils.trimToNull((String)window.getProperty("osivia.cms.maxItems"))));
        configuration.setNormalPagination(NumberUtils.createInteger((String)StringUtils.trimToNull((String)window.getProperty("osivia.cms.pageSize"))));
        configuration.setMaximizedPagination(NumberUtils.createInteger((String)StringUtils.trimToNull((String)window.getProperty("osivia.cms.pageSizeMax"))));
        configuration.setInfiniteScroll(BooleanUtils.toBoolean((String)window.getProperty("osivia.cms.infiniteScroll")));
        configuration.setTemplate(window.getProperty("osivia.cms.style"));
        configuration.setPermalinkReference(window.getProperty("osivia.permaLinkRef"));
        configuration.setRssReference(window.getProperty("osivia.rssLinkRef"));
        configuration.setRssTitle(window.getProperty("osivia.rssTitle"));
        configuration.setCreationParentPath(window.getProperty("osivia.createParentPath"));
        configuration.setCreationContentType(window.getProperty("osivia.createDocType"));
        configuration.setSetType(window.getProperty("osivia.set.id"));
        return configuration;
    }

    public String getPathAdmin() {
        return PATH_ADMIN;
    }
}

