/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.tag;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.CustomizedJsp;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.tag.INuxeoTagService;
import fr.toutatice.portail.cms.nuxeo.portlets.bridge.Formater;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomizationPluginMgr;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.io.IOException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.FileMimeType;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;
import org.osivia.portal.core.web.IWebIdService;

public class NuxeoTagService
implements INuxeoTagService {
    private final IWebIdService webIdService = (IWebIdService)Locator.findMBean(IWebIdService.class, (String)"osivia:service=webIdService");
    private final PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
    private final IBundleFactory bundleFactory;

    public NuxeoTagService() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public Link getDocumentLink(NuxeoController nuxeoController, DocumentDTO document, String property, String displayContext, boolean picture, boolean permalink) {
        Link link;
        Object nuxeoDocument = document != null ? document.getDocument() : (nuxeoController != null ? nuxeoController.getCurrentDoc() : null);
        if (nuxeoDocument != null) {
            if (picture) {
                String url = StringUtils.isEmpty((String)property) ? nuxeoController.createPictureLink(nuxeoDocument.getPath(), StringUtils.defaultIfEmpty((String)displayContext, (String)"Original")) : (nuxeoDocument.getProperties().getMap(property) != null ? nuxeoController.createFileLink(nuxeoDocument, property) : null);
                link = url != null ? new Link(url, false) : null;
            } else if (permalink) {
                Page page = null;
                Window window = (Window)nuxeoController.getRequest().getAttribute("osivia.window");
                if (window != null) {
                    page = window.getPage();
                }
                try {
                    CMSServiceCtx cmsContext;
                    CMSService cmsService;
                    CMSItem cmsItem;
                    String path = document.getPath();
                    if (PortalObjectUtils.isSpaceSite((PortalObject)page) && StringUtils.isNotEmpty((String)(cmsItem = (cmsService = (CMSService)NuxeoController.getCMSService()).createItem(cmsContext = nuxeoController.getCMSCtx(), document.getPath(), null, nuxeoDocument)).getWebId())) {
                        path = this.webIdService.webIdToCmsPath(cmsItem.getWebId());
                    }
                    String url = nuxeoController.getPortalUrlFactory().getPermaLink(nuxeoController.getPortalCtx(), null, null, path, "cms");
                    link = new Link(url, false);
                }
                catch (Exception e) {
                    link = new Link("#", false);
                }
            } else if (StringUtils.isEmpty((String)property)) {
                String url = nuxeoDocument.getString("clink:link");
                link = url != null && "contextualLink".equals(displayContext) ? new Link(url, true) : nuxeoController.getLink(nuxeoDocument, StringUtils.trimToNull((String)displayContext));
            } else {
                String value = String.valueOf(document.getProperties().get(property));
                link = nuxeoController.getLinkFromNuxeoURL(value);
            }
        } else {
            link = null;
        }
        return link;
    }

    public Link getPreviewFileLink(NuxeoController nuxeoController, DocumentDTO document) {
        Link previewLink = null;
        ExtendedDocumentInfos infos = null;
        try {
            ICMSService cmsService = NuxeoController.getCMSService();
            if (cmsService.getClass().isAssignableFrom(CMSService.class)) {
                CMSService cmsServiceImpl = (CMSService)cmsService;
                infos = cmsServiceImpl.getExtendedDocumentInfos(nuxeoController.getCMSCtx(), document.getPath());
            }
        }
        catch (CMSException cmsService) {
            // empty catch block
        }
        if (infos != null && BooleanUtils.isTrue((Boolean)infos.isPdfConvertible())) {
            String createFileLink = nuxeoController.createFileLink(document.getDocument(), "pdf:content");
            StringBuffer previewLinkStr = new StringBuffer();
            previewLinkStr.append(createFileLink);
            previewLink = new Link(previewLinkStr.toString(), false);
        }
        return previewLink;
    }

    public Link getUserProfileLink(NuxeoController nuxeoController, String name, String displayName) {
        Person person = this.personService.getPerson(name);
        Link link = null;
        if (person != null) {
            try {
                link = this.personService.getCardUrl(nuxeoController.getPortalCtx(), person);
            }
            catch (PortalException portalException) {
                // empty catch block
            }
        }
        return link;
    }

    public Link getNuxeoIconLink(NuxeoController nuxeoController, String contextPath, DocumentDTO document) {
        String url = contextPath + Formater.formatNuxeoIcon((Document)document.getDocument());
        return new Link(url, false);
    }

    public CustomizedJsp getCustomizedJsp(NuxeoController nuxeoController, String name) throws IOException {
        DefaultCMSCustomizer cmsCustomizer = (DefaultCMSCustomizer)nuxeoController.getNuxeoCMSService().getCMSCustomizer();
        CustomizationPluginMgr pluginManager = cmsCustomizer.getPluginManager();
        return pluginManager.customizeJSP(name, nuxeoController.getPortletCtx(), nuxeoController.getRequest());
    }

    public Element getDocumentIcon(NuxeoController nuxeoController, DocumentDTO documentDto, String style) throws IOException {
        INuxeoCustomizer customizer = nuxeoController.getNuxeoCMSService().getCMSCustomizer();
        Document nuxeoDocument = documentDto.getDocument();
        DocumentType documentType = documentDto.getType();
        PropertyMap fileContent = nuxeoDocument == null ? null : nuxeoDocument.getProperties().getMap("file:content");
        FileMimeType fileMimeType = fileContent == null ? null : customizer.getFileMimeType(fileContent.getString("mime-type"));
        return this.getIcon(nuxeoController, fileMimeType, documentType, style);
    }

    public Element getMimeTypeIcon(NuxeoController nuxeoController, String mimeType, String style) throws IOException {
        INuxeoCustomizer customizer = nuxeoController.getNuxeoCMSService().getCMSCustomizer();
        FileMimeType fileMimeType = customizer.getFileMimeType(mimeType);
        return this.getIcon(nuxeoController, fileMimeType, null, style);
    }

    private Element getIcon(NuxeoController nuxeoController, FileMimeType fileMimeType, DocumentType documentType, String style) {
        PortletRequest request = nuxeoController.getRequest();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        String title = fileMimeType != null ? fileMimeType.getDescription() : (documentType != null ? bundle.getString(StringUtils.upperCase((String)documentType.getName()), documentType.getCustomizedClassLoader(), new Object[0]) : null);
        String display = fileMimeType != null ? fileMimeType.getDisplay() : null;
        String icon = fileMimeType != null ? fileMimeType.getIcon() : (documentType != null ? documentType.getIcon() : null);
        int size = StringUtils.isNotEmpty((String)display) ? display.length() : 1;
        String htmlClass = "document-type document-type-" + StringUtils.defaultIfBlank((String)style, (String)"inline");
        Element container = DOM4JUtils.generateElement((String)"span", (String)htmlClass, (String)"");
        if (StringUtils.isNotEmpty((String)title)) {
            DOM4JUtils.addAttribute((Element)container, (String)"title", (String)title);
        }
        DOM4JUtils.addDataAttribute((Element)container, (String)"size", (String)String.valueOf(size));
        if (fileMimeType != null) {
            if (fileMimeType.getMimeType() != null) {
                DOM4JUtils.addDataAttribute((Element)container, (String)"primary-type", (String)fileMimeType.getMimeType().getPrimaryType());
                DOM4JUtils.addDataAttribute((Element)container, (String)"sub-type", (String)fileMimeType.getMimeType().getSubType());
            }
            if (StringUtils.isNotEmpty((String)fileMimeType.getExtension())) {
                DOM4JUtils.addDataAttribute((Element)container, (String)"extension", (String)fileMimeType.getExtension());
            }
        } else if (documentType == null) {
            DOM4JUtils.addDataAttribute((Element)container, (String)"unknown", (String)"");
        }
        if (StringUtils.isNotEmpty((String)display)) {
            DOM4JUtils.addDataAttribute((Element)container, (String)"display", (String)display);
        } else {
            Element inner = DOM4JUtils.generateElement((String)"i", (String)icon, (String)"");
            container.add(inner);
        }
        return container;
    }
}

