/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.user;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.IdRef;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.user.UserPreferences;

public class UpdatePreferencesCommand
implements INuxeoCommand {
    public static final String METADATA_FOLDERS_PREFS = "ttc_userprofile:folders_prefs";
    public static final String METADATA_FOLDERS_PREFS_ID = "webid";
    public static final String METADATA_FOLDERS_PREFS_VALUE = "display_style";
    private final UserPreferences preferences;

    public UpdatePreferencesCommand(UserPreferences preferences) {
        this.preferences = preferences;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        PropertyMap properties = new PropertyMap();
        properties.set(METADATA_FOLDERS_PREFS, this.convertFolderPrefsJson(this.preferences.getFolderDisplays()));
        IdRef docRef = new IdRef(this.preferences.getDocId());
        documentService.update((DocRef)docRef, properties);
        return null;
    }

    private String convertFolderPrefsJson(Map<String, String> folderDisplays) {
        JSONArray array = new JSONArray();
        for (Map.Entry<String, String> entry : folderDisplays.entrySet()) {
            JSONObject object = new JSONObject();
            object.put((Object)METADATA_FOLDERS_PREFS_ID, (Object)entry.getKey());
            object.put((Object)METADATA_FOLDERS_PREFS_VALUE, (Object)entry.getValue());
            array.add((Object)object);
        }
        return array.toString();
    }

    public String getId() {
        return null;
    }
}

