/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.binaries;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.ResourceUtil;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.portlets.binaries.BytesRange;
import fr.toutatice.portail.cms.nuxeo.portlets.binaries.ConstrainedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.portlet.PortletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.core.cms.BinaryDelegation;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.page.PageProperties;

public class BinaryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final long BINARY_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private static PortletContext portletContext;
    private final Log log = LogFactory.getLog(this.getClass());

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portletContext);
        nuxeoController.setServletRequest(request);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        PageProperties.init();
        PageProperties pageProperties = PageProperties.getProperties();
        String portalName = request.getParameter("portalName");
        if (portalName == null) {
            portalName = "default";
        }
        pageProperties.getPagePropertiesMap().put("portalName", portalName);
        ServletOutputStream output = response.getOutputStream();
        try {
            BinaryDelegation delegation;
            String forcedScope;
            String scope;
            String index = request.getParameter("index");
            String pictureContent = request.getParameter("content");
            String fieldName = request.getParameter("fieldName");
            String path = request.getParameter("path");
            path = URLDecoder.decode(path, "UTF-8");
            boolean liveState = BooleanUtils.toBoolean((String)request.getParameter("liveState"));
            if (liveState) {
                nuxeoController.setDisplayLiveVersion("1");
            }
            if ((scope = request.getParameter("scope")) != null) {
                nuxeoController.setScope(scope);
            }
            if ((forcedScope = request.getParameter("forcedScope")) != null) {
                nuxeoController.setForcePublicationInfosScope(forcedScope);
            }
            if ((delegation = cmsService.validateBinaryDelegation(cmsContext, path)) != null) {
                request.setAttribute("osivia.delegation.userName", (Object)delegation.getUserName());
                if (delegation.isGrantedAccess()) {
                    nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
                    nuxeoController.setForcePublicationInfosScope("superuser_context");
                }
                request.setAttribute("osivia.isAdmin", (Object)delegation.isAdmin());
                PageProperties.getProperties().setBinarySubject(delegation.getSubject());
            }
            String type = request.getParameter("type");
            BinaryDescription.Type binaryType = BinaryDescription.Type.valueOf((String)type);
            if (BooleanUtils.toBoolean((String)request.getParameter("reload"))) {
                PageProperties.getProperties().setRefreshingPage(true);
            }
            CMSBinaryContent content = null;
            if (BinaryDescription.Type.ATTACHED_PICTURE.equals((Object)binaryType)) {
                content = nuxeoController.fetchAttachedPicture(path, index);
            } else if (BinaryDescription.Type.PICTURE.equals((Object)binaryType)) {
                content = nuxeoController.fetchPicture(path, pictureContent);
            } else if (BinaryDescription.Type.ATTACHED_FILE.equals((Object)binaryType)) {
                content = ResourceUtil.getCMSBinaryContent((NuxeoController)nuxeoController, (String)path, (String)index);
            } else if (BinaryDescription.Type.BLOB.equals((Object)binaryType)) {
                content = ResourceUtil.getBlobHolderContent((NuxeoController)nuxeoController, (String)path, (String)index);
            } else if (BinaryDescription.Type.FILE.equals((Object)binaryType)) {
                nuxeoController.setStreamingSupport(true);
                content = nuxeoController.fetchFileContent(path, fieldName);
            } else if (BinaryDescription.Type.FILE_OF_VERSION.equals((Object)binaryType)) {
                nuxeoController.setStreamingSupport(true);
                nuxeoController.setDisplayContext("downloadVersion");
                content = nuxeoController.fetchFileContent(path, fieldName);
            }
            if (content.getStream() != null) {
                this.stream(request, response, content, (OutputStream)output);
            } else {
                long lastModified = System.currentTimeMillis();
                long expires = lastModified + BINARY_TIMEOUT;
                response.setContentType(content.getMimeType());
                response.setHeader("Content-Disposition", this.getHeaderContentDisposition(request, content));
                response.setHeader("Cache-Control", "max-age=" + BINARY_TIMEOUT);
                response.setHeader("Content-Length", String.valueOf(content.getFileSize()));
                String fileName = request.getParameter("fileName");
                if (fileName == null) {
                    fileName = content.getName();
                }
                response.setDateHeader("Last-Modified", lastModified);
                response.setDateHeader("Expires", expires);
                ResourceUtil.copy((InputStream)new FileInputStream(content.getFile()), (OutputStream)response.getOutputStream(), (int)4096);
            }
        }
        catch (NuxeoException e) {
            if (e.getErrorCode() == NuxeoException.ERROR_NOTFOUND) {
                String message = "Resource BinaryServlet " + request.getParameterMap() + " not found (error 404).";
                this.log.error((Object)message);
                response.setStatus(404);
                request.setAttribute("osivia.no_redirection", (Object)"1");
            } else if (e.getErrorCode() == NuxeoException.ERROR_FORBIDDEN) {
                response.setStatus(403);
                request.setAttribute("osivia.no_redirection", (Object)"1");
            } else if (e.getErrorCode() == NuxeoException.ERROR_UNAVAILAIBLE) {
                response.setStatus(503);
                request.setAttribute("osivia.no_redirection", (Object)"1");
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    public static void setPortletContext(PortletContext portletContext) {
        BinaryServlet.portletContext = portletContext;
    }

    private String getHeaderContentDisposition(HttpServletRequest request, CMSBinaryContent content) {
        String fileName = request.getParameter("fileName");
        if (fileName == null) {
            fileName = content.getName();
        }
        StringBuilder builder = new StringBuilder();
        if ("application/pdf".equals(content.getMimeType())) {
            builder.append("inline; ");
        } else {
            builder.append("attachment; ");
        }
        builder.append("filename=\"");
        builder.append(fileName);
        builder.append("\"");
        return builder.toString();
    }

    private void stream(HttpServletRequest request, HttpServletResponse response, CMSBinaryContent content, OutputStream output) throws IOException {
        long length = content.getFileSize();
        long lastModified = System.currentTimeMillis();
        long expires = lastModified + BINARY_TIMEOUT;
        String contentType = content.getMimeType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        String disposition = this.getHeaderContentDisposition(request, content);
        long ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= lastModified) {
            response.sendError(412);
            return;
        }
        BytesRange full = new BytesRange(0L, length - 1L, length);
        ArrayList<BytesRange> ranges = new ArrayList<BytesRange>();
        String range = request.getHeader("Range");
        if (range != null) {
            if (!range.matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$")) {
                response.setHeader("Content-Range", "bytes */" + length);
                response.sendError(416);
                return;
            }
            if (ranges.isEmpty()) {
                for (String part : range.substring(6).split(",")) {
                    NumberUtils.toInt((String)StringUtils.substringBefore((String)part, (String)"-"), (int)-1);
                    long start = NumberUtils.toInt((String)StringUtils.substringBefore((String)part, (String)"-"), (int)-1);
                    long end = NumberUtils.toInt((String)StringUtils.substringAfter((String)part, (String)"-"), (int)-1);
                    if (start == -1L) {
                        start = length - end;
                        end = length - 1L;
                    } else if (end == -1L || end > length - 1L) {
                        end = length - 1L;
                    }
                    if (start > end) {
                        response.setHeader("Content-Range", "bytes */" + length);
                        response.sendError(416);
                        return;
                    }
                    ranges.add(new BytesRange(start, end, length));
                }
            }
        }
        response.reset();
        response.setBufferSize(8192);
        response.setHeader("Content-Disposition", disposition);
        response.setDateHeader("Last-Modified", lastModified);
        response.setDateHeader("Expires", expires);
        if (range == null) {
            response.setContentType(contentType);
            response.setHeader("Content-Length", String.valueOf(content.getFileSize()));
            this.copy(content, output, 0L, content.getFileSize().longValue());
        } else {
            BytesRange r;
            response.setHeader("Accept-Ranges", "bytes");
            response.setStatus(206);
            if (ranges.isEmpty() || full.equals(ranges.get(0))) {
                r = full;
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.getStart() + "-" + r.getEnd() + "/" + r.getTotal());
                response.setHeader("Content-Length", String.valueOf(r.getLength()));
                this.copy(content, output, r.getStart(), r.getLength());
            } else if (ranges.size() == 1) {
                r = (BytesRange)ranges.get(0);
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.getStart() + "-" + r.getEnd() + "/" + r.getTotal());
                response.setHeader("Content-Length", String.valueOf(r.getLength()));
                this.copy(content, output, r.getStart(), r.getLength());
            } else {
                response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                ServletOutputStream sos = (ServletOutputStream)output;
                for (BytesRange r2 : ranges) {
                    sos.println();
                    sos.println("--MULTIPART_BYTERANGES");
                    sos.println("Content-Type: " + contentType);
                    sos.println("Content-Range: bytes " + r2.getStart() + "-" + r2.getEnd() + "/" + r2.getTotal());
                    this.copy(content, output, r2.getStart(), r2.getLength());
                }
                sos.println();
                sos.println("--MULTIPART_BYTERANGES--");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(CMSBinaryContent content, OutputStream output, long start, long length) throws IOException {
        InputStream input = content.getStream();
        try {
            int read;
            byte[] buffer = new byte[8192];
            if (start > 0L || length != content.getFileSize()) {
                input = new ConstrainedInputStream(input, length);
                input.skip(start);
            }
            while ((read = input.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }
}

