/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.impl.BasicPermissions;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.ecm.EcmCommonCommands;
import org.osivia.portal.api.ecm.EcmViews;
import org.osivia.portal.api.html.AccessibilityRoles;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemTypeComparator;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.portal.core.portalobjects.PortalObjectUtils;

public class MenuBarFormater {
    private final Log log = LogFactory.getLog(this.getClass());
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final DefaultCMSCustomizer customizer;
    private final IContributionService contributionService;
    private final ITaskbarService taskbarService;
    private final IBundleFactory bundleFactory;

    public MenuBarFormater(DefaultCMSCustomizer customizer) {
        this.customizer = customizer;
        this.contributionService = (IContributionService)Locator.findMBean(IContributionService.class, (String)"osivia:service=ContributionService");
        this.taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void formatDefaultContentMenuBar(CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, ExtendedDocumentInfos extendedInfos) throws CMSException, PortalException {
        List menubar;
        PortalControllerContext portalControllerContext;
        NuxeoDocumentContext documentContext;
        block17: {
            Document document = (Document)cmsContext.getDoc();
            if (document == null && cmsContext.getCreationPath() == null) {
                return;
            }
            try {
                documentContext = NuxeoController.getDocumentContext((CMSServiceCtx)cmsContext, (String)document.getPath());
            }
            catch (PortletException e) {
                throw new CMSException((Throwable)e);
            }
            PortletRequest request = cmsContext.getRequest();
            portalControllerContext = new PortalControllerContext(cmsContext.getPortletCtx(), request, (PortletResponse)cmsContext.getResponse());
            Bundle bundle = this.bundleFactory.getBundle(cmsContext.getRequest().getLocale());
            menubar = (List)request.getAttribute("osivia.menuBar");
            Portal portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext());
            boolean webPageFragment = false;
            if (PortalObjectUtils.isSpaceSite((PortalObject)portal) && cmsContext.getDoc() != null) {
                String webPagePath = (String)request.getAttribute("osivia.cms.webPagePath");
                String docLivePath = ContextualizationHelper.getLivePath((String)((Document)cmsContext.getDoc()).getPath());
                if (StringUtils.equals((String)docLivePath, (String)webPagePath)) {
                    webPageFragment = true;
                }
            }
            boolean isGlobalAdministrator = BooleanUtils.isTrue((Boolean)((Boolean)request.getAttribute("osivia.isAdministrator")));
            boolean isWorkspaceOrRoom = this.isWorkspaceOrRoom(document);
            boolean insideUserWorkspace = this.isInUserWorkspace(cmsContext, document);
            boolean isTaskbarItem = !isWorkspaceOrRoom && this.isTaskbarItem(portalControllerContext, cmsContext, documentContext);
            boolean isWorkspaceAdmin = (isWorkspaceOrRoom || isTaskbarItem) && this.isWorkspaceAdmin(cmsContext, documentContext);
            try {
                DocumentType documentType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
                this.addShareDropdown(portalControllerContext, documentType, bundle);
                this.addOtherOptionsDropdown(portalControllerContext, documentType, bundle);
                if (!isWorkspaceOrRoom) {
                    this.getCreateLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                }
                if (!webPageFragment) {
                    this.addCMSEditionDropdown(portalControllerContext, documentType, bundle);
                    this.addDraftLinks(portalControllerContext, cmsContext, pubInfos, extendedInfos, menubar, bundle);
                    this.getPermaLinkLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    this.getContextualizationLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    if (!isWorkspaceOrRoom) {
                        if (!isTaskbarItem || isWorkspaceAdmin) {
                            this.getReorderLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                            this.getRenameLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                            this.getEditLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, isTaskbarItem);
                            this.getDeleteLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                        }
                        if (!isTaskbarItem) {
                            this.getChangeModeLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, extendedInfos);
                        }
                    }
                    if (!isTaskbarItem) {
                        this.getMoveLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    }
                    this.getLiveContentBrowserLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    this.getSynchronizeLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                    this.getVersionsLink(portalControllerContext, cmsContext, menubar, bundle);
                    if (isGlobalAdministrator) {
                        this.getAdministrationLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
                    }
                    if (!insideUserWorkspace) {
                        this.getSubscribeLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                        if (!isWorkspaceOrRoom && !isTaskbarItem) {
                            this.getLockLink(portalControllerContext, cmsContext, menubar, bundle, extendedInfos);
                            this.getValidationWfLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, extendedInfos);
                            this.getRemotePublishingLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle, extendedInfos);
                        }
                    }
                }
            }
            catch (CMSException e) {
                if (e.getErrorCode() == 1 || e.getErrorCode() == 3) break block17;
                throw e;
            }
        }
        List modules = this.customizer.getPluginManager().customizeMenubarModules();
        for (MenubarModule module : modules) {
            module.customizeDocument(portalControllerContext, menubar, (DocumentContext)documentContext);
        }
    }

    protected boolean isWorkspaceOrRoom(Document document) {
        String type = document.getType();
        return "Workspace".equals(type) || "Room".equals(type);
    }

    protected boolean isInUserWorkspace(CMSServiceCtx cmsContext, Document document) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        boolean userWorkspace = false;
        if (document != null) {
            String path = document.getPath() + "/";
            List userWorkspaces = cmsService.getWorkspaces(cmsContext, true, false);
            for (CMSItem cmsItem : userWorkspaces) {
                if (!StringUtils.startsWith((String)path, (String)(cmsItem.getPath() + "/"))) continue;
                userWorkspace = true;
                break;
            }
        }
        return userWorkspace;
    }

    protected boolean isTaskbarItem(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, NuxeoDocumentContext documentContext) throws CMSException, PortalException {
        boolean taskbarItem;
        String parentPath;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        Document document = documentContext.getDoc();
        BasicPublicationInfos publicationInfos = (BasicPublicationInfos)documentContext.getPublicationInfos(BasicPublicationInfos.class);
        String basePath = publicationInfos.getBasePath();
        if (StringUtils.equals((String)basePath, (String)(parentPath = StringUtils.substringBeforeLast((String)document.getPath(), (String)"/")))) {
            String prefix;
            CMSItem spaceConfig = cmsService.getSpaceConfig(cmsContext, basePath);
            Document space = (Document)spaceConfig.getNativeItem();
            String shortname = space.getString("webc:url");
            String webId = document.getString("ttc:webid");
            if (StringUtils.startsWith((String)webId, (String)(prefix = "workspace_" + shortname + "_"))) {
                String taskId = StringUtils.upperCase((String)StringUtils.removeStart((String)webId, (String)prefix));
                TaskbarItems items = this.taskbarService.getItems(portalControllerContext);
                TaskbarItem item = items.get(taskId);
                taskbarItem = item != null && !item.isHidden();
            } else {
                taskbarItem = false;
            }
        } else {
            taskbarItem = false;
        }
        return taskbarItem;
    }

    protected boolean isWorkspaceAdmin(CMSServiceCtx cmsContext, NuxeoDocumentContext documentContext) throws CMSException {
        NuxeoDocumentContext workspaceDocumentContext;
        BasicPublicationInfos publicationInfos = (BasicPublicationInfos)documentContext.getPublicationInfos(BasicPublicationInfos.class);
        String basePath = publicationInfos.getBasePath();
        if (StringUtils.equals((String)basePath, (String)publicationInfos.getContentPath())) {
            workspaceDocumentContext = documentContext;
        } else {
            try {
                workspaceDocumentContext = NuxeoController.getDocumentContext((CMSServiceCtx)cmsContext, (String)basePath);
            }
            catch (PortletException e) {
                throw new CMSException((Throwable)e);
            }
        }
        BasicPermissions permissions = (BasicPermissions)workspaceDocumentContext.getPermissions(BasicPermissions.class);
        return permissions.isManageableByUser();
    }

    public void formatContentMenuBar(CMSServiceCtx cmsCtx, CMSPublicationInfos publicationInfos, ExtendedDocumentInfos extendedDocumentInfos) throws Exception {
        this.formatDefaultContentMenuBar(cmsCtx, publicationInfos, extendedDocumentInfos);
    }

    public boolean hasWebId(CMSServiceCtx cmsCtx) {
        boolean has = false;
        Document document = (Document)cmsCtx.getDoc();
        if (document != null) {
            String webid = document.getString("ttc:webid");
            has = StringUtils.isNotBlank((String)webid);
        }
        return has;
    }

    protected void addCMSEditionDropdown(PortalControllerContext portalControllerContext, DocumentType type, Bundle bundle) {
        MenubarDropdown dropdown = new MenubarDropdown("CMS_EDITION", bundle.getString("CMS_EDITION"), "glyphicons glyphicons-pencil", MenubarGroup.CMS, 6, false, false);
        dropdown.setBreadcrumb(type != null && type.isFolderish() && BooleanUtils.isNotTrue((Boolean)type.getEditorialContent()));
        this.menubarService.addDropdown(portalControllerContext, dropdown);
    }

    protected void addShareDropdown(PortalControllerContext portalControllerContext, DocumentType type, Bundle bundle) {
        MenubarDropdown dropdown = new MenubarDropdown("SHARE", bundle.getString("SHARE"), "glyphicons glyphicons-share-alt", MenubarGroup.GENERIC, 8);
        dropdown.setBreadcrumb(type != null && type.isFolderish() && BooleanUtils.isNotTrue((Boolean)type.getEditorialContent()));
        this.menubarService.addDropdown(portalControllerContext, dropdown);
    }

    protected void addOtherOptionsDropdown(PortalControllerContext portalControllerContext, DocumentType type, Bundle bundle) {
        MenubarDropdown dropdown = new MenubarDropdown("OTHER_OPTIONS", bundle.getString("OTHER_OPTIONS"), "glyphicons glyphicons-option-vertical", MenubarGroup.GENERIC, 40, false, false);
        dropdown.setBreadcrumb(type != null && type.isFolderish() && BooleanUtils.isNotTrue((Boolean)type.getEditorialContent()));
        this.menubarService.addDropdown(portalControllerContext, dropdown);
    }

    protected void getAdministrationLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        if (!pubInfos.isDraft() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            String url = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + pubInfos.getLiveId() + "/view_documents";
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
            MenubarItem item = new MenubarItem("MANAGE", bundle.getString("MANAGE_IN_NUXEO"), null, (MenubarContainer)parent, 21, url, "nuxeo", null, null);
            item.setAjaxDisabled(true);
            item.setDivider(true);
            menubar.add(item);
        }
    }

    protected void addDraftLinks(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, ExtendedDocumentInfos extendedInfos, List<MenubarItem> menubar, Bundle bundle) {
        Document document = (Document)cmsContext.getDoc();
        if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            if (DocumentHelper.isLeaf((Document)document)) {
                MenubarDropdown dropdown = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                int order = 1;
                if (pubInfos.isDraft()) {
                    MenubarItem indicator = new MenubarItem("DRAFT", bundle.getString("DRAFT"), (MenubarContainer)MenubarGroup.CMS, -12, "label label-info");
                    indicator.setState(true);
                    menubar.add(indicator);
                    if (pubInfos.isNotOrphanDraft()) {
                        String webId = DocumentHelper.getCheckinedWebIdFromDraft((Document)document);
                        String path = NuxeoController.webIdToCmsPath((String)webId);
                        String url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, null, null, null, null, null);
                        MenubarItem item = new MenubarItem("GO_TO_DRAFT_SOURCE", bundle.getString("GO_TO_DRAFT_SOURCE"), "glyphicons glyphicons-undo", (MenubarContainer)dropdown, order, url, null, null, null);
                        item.setAjaxDisabled(true);
                        menubar.add(item);
                    }
                } else if (pubInfos.hasDraft()) {
                    String path = pubInfos.getDraftPath();
                    String url = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, path, null, null, null, null, null, null, null);
                    MenubarItem item = new MenubarItem("GO_TO_DRAFT", bundle.getString("GO_TO_DRAFT"), "glyphicons glyphicons-redo", (MenubarContainer)dropdown, order, url, null, null, null);
                    item.setAjaxDisabled(true);
                    menubar.add(item);
                }
            } else if (extendedInfos.getDraftCount() > 0) {
                String url;
                String webId = DocumentHelper.getWebId((Document)document);
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("osivia.drafts.folderWebId", webId);
                try {
                    url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-viewDraftsListPortletInstance", properties, PortalUrlType.MODAL);
                }
                catch (PortalException e) {
                    url = "#";
                }
                String title = bundle.getString("DRAFTS_LIST");
                MenubarItem item = new MenubarItem("DRAFTS_LIST", title, "glyphicons glyphicons-construction-cone", (MenubarContainer)MenubarGroup.CMS, 4, "#", null, null, null);
                item.getData().put("target", "#osivia-modal");
                item.getData().put("load-url", url);
                item.getData().put("title", title);
                item.getData().put("footer", String.valueOf(true));
                item.setCounter(Integer.valueOf(extendedInfos.getDraftCount()));
                menubar.add(item);
            }
        }
    }

    protected void getChangeModeLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException, PortalException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        if (cmsContext.getRequest().getRemoteUser() == null || StringUtils.isBlank((String)pubInfos.getPublishSpacePath())) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        String path = document.getPath();
        Map managedTypes = this.customizer.getCMSItemTypes();
        DocumentType documentType = (DocumentType)managedTypes.get(document.getType());
        if (documentType != null && documentType.isSupportsPortalForms() && pubInfos.isEditableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && !pubInfos.isLiveSpace()) {
            IContributionService.EditionState editionState;
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
            if (!DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos) && pubInfos.isBeingModified()) {
                MenubarItem modificationIndicator = new MenubarItem("MODIFICATION_MESSAGE", null, (MenubarContainer)MenubarGroup.CMS, -12, "label label-default");
                modificationIndicator.setGlyphicon("halflings halflings-asterisk");
                modificationIndicator.setTooltip(bundle.getString("MODIFICATION_MESSAGE"));
                modificationIndicator.setState(true);
                menubar.add(modificationIndicator);
            }
            if (DocumentHelper.isInLiveMode((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                editionState = new IContributionService.EditionState(IContributionService.EditionState.CONTRIBUTION_MODE_ONLINE, path);
                MenubarItem liveIndicator = new MenubarItem("LIVE_VERSION", bundle.getString("LIVE_VERSION"), (MenubarContainer)MenubarGroup.CMS, -12, "label label-info");
                liveIndicator.setGlyphicon("halflings halflings-pencil visible-xs-inline-block");
                liveIndicator.setState(true);
                menubar.add(liveIndicator);
                if (extendedInfos != null && extendedInfos.isOnlineTaskPending()) {
                    MenubarItem pendingIndicator = new MenubarItem("ON_LINE_WF_PENDING", bundle.getString("ON_LINE_WF_PENDING"), (MenubarContainer)MenubarGroup.CMS, -11, "label label-warning");
                    pendingIndicator.setGlyphicon("glyphicons glyphicons-history");
                    pendingIndicator.setState(true);
                    menubar.add(pendingIndicator);
                }
            } else {
                editionState = new IContributionService.EditionState(IContributionService.EditionState.CONTRIBUTION_MODE_EDITION, path);
                this.contributionService.removeWindowEditionState(portalControllerContext);
            }
            if (DocumentHelper.isInLiveMode((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                if (extendedInfos.isOnlineTaskPending()) {
                    if (extendedInfos.isCanUserValidateOnlineTask()) {
                        if ("validate-online".equals(extendedInfos.getTaskName())) {
                            this.addValidatePublishingItems(portalControllerContext, cmsContext, pubInfos, menubar, (MenubarContainer)parent, bundle);
                        } else {
                            HashMap requestParameters = new HashMap();
                            String validateURL = cmsService.getEcmUrl(cmsContext, EcmViews.validateRemotePublishing, pubInfos.getDocumentPath(), requestParameters);
                            MenubarItem validateItem = new MenubarItem("REMOTE_ONLINE_WF_VALIDATE", bundle.getString("REMOTE_ONLINE_WF_VALIDATE"), null, (MenubarContainer)parent, 14, validateURL, null, null, null);
                            validateItem.setAjaxDisabled(true);
                            menubar.add(validateItem);
                        }
                    } else if (extendedInfos.isUserOnlineTaskInitiator()) {
                        String cancelAskPublishURL = this.contributionService.getCancelPublishingAskContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                        MenubarItem cancelAskPublishItem = new MenubarItem("CANCEL_ASK_PUBLISH", bundle.getString("CANCEL_ASK_PUBLISH"), null, (MenubarContainer)MenubarGroup.CMS, 12, cancelAskPublishURL, null, null, null);
                        cancelAskPublishItem.setAjaxDisabled(true);
                        menubar.add(cancelAskPublishItem);
                    }
                } else if (!DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos) && pubInfos.isBeingModified()) {
                    if (pubInfos.isPublished()) {
                        String cmsEraseModificationURL = this.portalUrlFactory.getEcmCommandUrl(portalControllerContext, path, EcmCommonCommands.eraseModifications);
                        MenubarItem eraseItem = new MenubarItem("ERASE", bundle.getString("ERASE"), "halflings halflings-erase", (MenubarContainer)parent, 11, "#erase_cms_page", null, null, "fancybox_inline");
                        eraseItem.setAssociatedHTML(this.generateEraseFancyBox(bundle, cmsEraseModificationURL));
                        menubar.add(eraseItem);
                    }
                    if (pubInfos.isUserCanValidate()) {
                        String publishURL = this.contributionService.getPublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                        MenubarItem publishItem = new MenubarItem("PUBLISH", bundle.getString("PUBLISH"), "glyphicons glyphicons-ok", (MenubarContainer)parent, 12, publishURL, null, null, null);
                        publishItem.setAjaxDisabled(true);
                        publishItem.setDivider(true);
                        menubar.add(publishItem);
                    } else {
                        String askPublishURL = this.contributionService.getAskPublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                        MenubarItem askPublishItem = new MenubarItem("ASK_PUBLISH", bundle.getString("ASK_PUBLISH"), null, (MenubarContainer)parent, 12, askPublishURL, null, null, null);
                        askPublishItem.setAjaxDisabled(true);
                        menubar.add(askPublishItem);
                    }
                }
                if (pubInfos.isPublished()) {
                    String proxyURL = this.contributionService.getChangeEditionStateUrl(portalControllerContext, editionState);
                    MenubarItem proxyItem = new MenubarItem("PROXY_RETURN", bundle.getString("PROXY_RETURN"), "halflings halflings-eye-close", (MenubarContainer)parent, 1, proxyURL, null, null, null);
                    proxyItem.setAjaxDisabled(true);
                    menubar.add(proxyItem);
                }
            } else {
                if (pubInfos.isUserCanValidate()) {
                    MenubarItem unpublishItem = new MenubarItem("UNPUBLISH", bundle.getString("UNPUBLISH"), (MenubarContainer)parent, 12, null);
                    unpublishItem.setAjaxDisabled(true);
                    unpublishItem.setDivider(true);
                    if (documentType == null || !documentType.isRootType()) {
                        String unpublishURL = this.contributionService.getUnpublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
                        unpublishItem.setUrl(unpublishURL);
                    } else {
                        unpublishItem.setUrl("#");
                        unpublishItem.setDisabled(true);
                        unpublishItem.setTooltip(bundle.getString("CANNOT_UNPUBLISH_ROOT"));
                    }
                    menubar.add(unpublishItem);
                }
                if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                    String liveURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, pubInfos.getLiveId(), null, "1", "preview", null, null, null, null);
                    MenubarItem liveItem = new MenubarItem("GO_TO_LIVE", bundle.getString("GO_TO_LIVE"), "halflings halflings-eye-open", (MenubarContainer)parent, 1, liveURL, null, null, null);
                    liveItem.setAjaxDisabled(true);
                    menubar.add(liveItem);
                } else {
                    String previewURL = this.contributionService.getChangeEditionStateUrl(portalControllerContext, editionState);
                    MenubarItem previewItem = new MenubarItem("LIVE_PREVIEW", bundle.getString("LIVE_PREVIEW"), "halflings halflings-eye-open", (MenubarContainer)parent, 1, previewURL, null, null, null);
                    previewItem.setAjaxDisabled(true);
                    menubar.add(previewItem);
                }
            }
        }
    }

    protected void addValidatePublishingItems(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, MenubarContainer parent, Bundle bundle) throws CMSException {
        String validateURL = this.contributionService.getValidatePublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
        MenubarItem validateItem = new MenubarItem("ONLINE_WF_VALIDATE", bundle.getString("VALIDATE_PUBLISH"), "glyphicons glyphicons-ok", parent, 13, validateURL, null, null, null);
        validateItem.setAjaxDisabled(true);
        menubar.add(validateItem);
        String rejectURL = this.contributionService.getRejectPublishContributionURL(portalControllerContext, pubInfos.getDocumentPath());
        MenubarItem rejectItem = new MenubarItem("ONLINE_WF_REJECT", bundle.getString("REJECT_PUBLISH"), "glyphicons glyphicons-remove", parent, 14, rejectURL, null, null, null);
        rejectItem.setAjaxDisabled(true);
        menubar.add(rejectItem);
    }

    protected void getLiveContentBrowserLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        boolean folderish;
        String navigationPath;
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        if (!ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            return;
        }
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        Document document = (Document)cmsContext.getDoc();
        if (document == null) {
            navigationPath = cmsContext.getCreationPath();
            Object cmsItemType = null;
            folderish = navigationPath != null;
        } else {
            navigationPath = nuxeoController.getContentPath();
            DocumentType cmsItemType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
            boolean bl = folderish = cmsItemType != null && cmsItemType.isFolderish();
        }
        if (!pubInfos.isLiveSpace() && !pubInfos.getSubTypes().isEmpty() && folderish) {
            String browserURL;
            Portal portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext());
            boolean spaceSite = PortalObjectUtils.isSpaceSite((PortalObject)portal);
            try {
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("osivia.browser.basePath", nuxeoController.getBasePath());
                properties.put("osivia.browser.navigationPath", navigationPath);
                properties.put("osivia.browser.space", String.valueOf(spaceSite));
                browserURL = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-portal-browser-portlet-instance", properties, PortalUrlType.POPUP);
            }
            catch (PortalException e) {
                browserURL = "#";
            }
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
            MenubarItem browserItem = new MenubarItem("BROWSE_LIVE_CONTENT", bundle.getString("BROWSE_LIVE_CONTENT"), "glyphicons glyphicons-book-open", (MenubarContainer)parent, 50, browserURL, null, null, "fancyframe_refresh");
            browserItem.setAjaxDisabled(true);
            browserItem.setDivider(true);
            browserItem.setBreadcrumb(true);
            menubar.add(browserItem);
        }
    }

    protected void getVersionsLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle) {
        Document document;
        if (cmsContext.getRequest().getRemoteUser() != null && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && StringUtils.equals((String)"File", (String)(document = (Document)cmsContext.getDoc()).getType())) {
            try {
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("osivia.cms.contentPath", document.getId());
                String versionsURL = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-versions-instance", properties, PortalUrlType.POPUP);
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
                MenubarItem versionsItem = new MenubarItem("VERSIONS", bundle.getString("VERSIONS"), "glyphicons glyphicons-history", (MenubarContainer)parent, 10, versionsURL, null, null, "fancyframe");
                versionsItem.setAjaxDisabled(true);
                versionsItem.setDivider(true);
                versionsItem.setBreadcrumb(false);
                menubar.add(versionsItem);
            }
            catch (PortalException e) {
                this.log.warn((Object)e.getMessage());
            }
        }
    }

    protected void getSynchronizeLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        if (!ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        String path = document.getPath();
        String command = null;
        String icon = null;
        EcmCommonCommands ecmAction = null;
        if (extendedInfos.isCanSynchronize()) {
            command = "SYNCHRONIZE_ACTION";
            icon = "glyphicons glyphicons-synchronization";
            ecmAction = EcmCommonCommands.synchronizeFolder;
        } else if (extendedInfos.isCanUnsynchronize()) {
            command = "UNSYNCHRONIZE_ACTION";
            icon = "glyphicons glyphicons-synchronization-ban";
            ecmAction = EcmCommonCommands.unsynchronizeFolder;
            MenubarItem synchronizedIndicator = new MenubarItem("SYNCHRONIZED", null, (MenubarContainer)MenubarGroup.CMS, -2, "label label-success");
            synchronizedIndicator.setGlyphicon("halflings halflings-refresh");
            synchronizedIndicator.setTooltip(bundle.getString("SYNCHRONIZED"));
            synchronizedIndicator.setState(true);
            menubar.add(synchronizedIndicator);
        }
        MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
        if (command != null) {
            try {
                String synchronizeURL = this.portalUrlFactory.getEcmCommandUrl(portalControllerContext, path, ecmAction);
                MenubarItem synchronizeItem = new MenubarItem(command, bundle.getString(command), icon, (MenubarContainer)parent, 12, synchronizeURL, null, null, null);
                synchronizeItem.setAjaxDisabled(true);
                synchronizeItem.setDivider(true);
                menubar.add(synchronizeItem);
            }
            catch (PortalException e) {
                this.log.warn((Object)e.getMessage());
            }
        } else if (extendedInfos.getSynchronizationRootPath() != null) {
            String rootURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, extendedInfos.getSynchronizationRootPath(), null, null, null, null, null, null, null);
            MenubarItem rootURLItem = new MenubarItem("SYNCHRO_ROOT_URL", bundle.getString("SYNCHRO_ROOT_URL"), null, (MenubarContainer)parent, 12, rootURL, null, null, null);
            rootURLItem.setAjaxDisabled(true);
            rootURLItem.setDivider(true);
            menubar.add(rootURLItem);
        }
    }

    protected void getSubscribeLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() != null) {
            ExtendedDocumentInfos.SubscriptionStatus subscriptionStatus;
            Document document = (Document)cmsContext.getDoc();
            String path = document.getPath();
            if (!"Staple".equals(document.getType()) && !DocumentHelper.hasDraft((Document)document) && (subscriptionStatus = extendedInfos.getSubscriptionStatus()) != null && subscriptionStatus != ExtendedDocumentInfos.SubscriptionStatus.no_subscriptions) {
                String url = "";
                try {
                    MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
                    MenubarItem subscribeItem = new MenubarItem("SUBSCRIBE_URL", null, null, (MenubarContainer)parent, 11, url, null, null, null);
                    subscribeItem.setAjaxDisabled(true);
                    subscribeItem.setDivider(true);
                    if (subscriptionStatus == ExtendedDocumentInfos.SubscriptionStatus.can_subscribe) {
                        url = this.portalUrlFactory.getEcmCommandUrl(portalControllerContext, path, EcmCommonCommands.subscribe);
                        subscribeItem.setUrl(url);
                        subscribeItem.setGlyphicon("glyphicons glyphicons-flag");
                        subscribeItem.setTitle(bundle.getString("SUBSCRIBE_ACTION"));
                    } else if (subscriptionStatus == ExtendedDocumentInfos.SubscriptionStatus.can_unsubscribe) {
                        url = this.portalUrlFactory.getEcmCommandUrl(portalControllerContext, path, EcmCommonCommands.unsubscribe);
                        subscribeItem.setUrl(url);
                        subscribeItem.setGlyphicon("glyphicons glyphicons-ban-circle");
                        subscribeItem.setTitle(bundle.getString("UNSUBSCRIBE_ACTION"));
                        MenubarItem subscribedIndicator = new MenubarItem("SUBSCRIBED", null, (MenubarContainer)MenubarGroup.CMS, -3, "label label-success");
                        subscribedIndicator.setGlyphicon("halflings halflings-flag");
                        subscribedIndicator.setTooltip(bundle.getString("SUBSCRIBED"));
                        subscribedIndicator.setState(true);
                        menubar.add(subscribedIndicator);
                    } else if (subscriptionStatus == ExtendedDocumentInfos.SubscriptionStatus.has_inherited_subscriptions) {
                        subscribeItem.setUrl("#");
                        subscribeItem.setGlyphicon("glyphicons glyphicons-flag");
                        subscribeItem.setTitle(bundle.getString("INHERITED_SUBSCRIPTION"));
                        subscribeItem.setDisabled(true);
                    }
                    menubar.add(subscribeItem);
                }
                catch (PortalException ex) {
                    this.log.warn((Object)ex.getMessage());
                }
            }
        }
    }

    private void getLockLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) {
        Document document = (Document)cmsContext.getDoc();
        String path = document.getPath();
        ExtendedDocumentInfos.LockStatus lockStatus = extendedInfos.getLockStatus();
        if (lockStatus != null && lockStatus != ExtendedDocumentInfos.LockStatus.no_lock) {
            String url = "";
            try {
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
                MenubarItem lockItem = new MenubarItem("LOCK_URL", null, null, (MenubarContainer)parent, 14, url, null, null, null);
                lockItem.setAjaxDisabled(true);
                if (lockStatus == ExtendedDocumentInfos.LockStatus.can_lock) {
                    url = this.portalUrlFactory.getEcmCommandUrl(portalControllerContext, path, EcmCommonCommands.lock);
                    lockItem.setUrl(url);
                    lockItem.setGlyphicon("glyphicons glyphicons-lock");
                    lockItem.setTitle(bundle.getString("LOCK_ACTION"));
                } else if (lockStatus == ExtendedDocumentInfos.LockStatus.can_unlock) {
                    url = this.portalUrlFactory.getEcmCommandUrl(portalControllerContext, path, EcmCommonCommands.unlock);
                    lockItem.setUrl(url);
                    lockItem.setGlyphicon("glyphicons glyphicons-unlock");
                    lockItem.setTitle(bundle.getString("UNLOCK_ACTION"));
                    menubar.add(this.makeLockedIndicator(cmsContext, bundle, extendedInfos));
                } else if (lockStatus == ExtendedDocumentInfos.LockStatus.locked) {
                    lockItem.setUrl("#");
                    lockItem.setGlyphicon("glyphicons glyphicons-lock");
                    lockItem.setTitle(bundle.getString("INHERITED_LOCK"));
                    lockItem.setDisabled(true);
                    menubar.add(this.makeLockedIndicator(cmsContext, bundle, extendedInfos));
                }
                menubar.add(lockItem);
            }
            catch (PortalException ex) {
                this.log.warn((Object)ex.getMessage());
            }
        }
    }

    protected MenubarItem makeLockedIndicator(CMSServiceCtx cmsContext, Bundle bundle, ExtendedDocumentInfos extendedInfos) {
        MenubarItem lockedIndicator = new MenubarItem("LOCKED", null, (MenubarContainer)MenubarGroup.CMS, -1, "label label-warning");
        lockedIndicator.setGlyphicon("halflings halflings-lock");
        String displayName = this.getUserDisplayName(extendedInfos);
        Object[] args = new Object[]{displayName};
        String tooltip = bundle.getString("LOCKED_BY", args);
        lockedIndicator.setTooltip(tooltip);
        lockedIndicator.setState(true);
        String currentUser = cmsContext.getRequest().getRemoteUser();
        boolean currentUserIsOwner = StringUtils.equals((String)currentUser, (String)extendedInfos.getLockOwner());
        if (currentUserIsOwner) {
            lockedIndicator.setGlyphicon("glyphicons glyphicons-user-lock");
            lockedIndicator.setTooltip(bundle.getString("LOCKED"));
        }
        return lockedIndicator;
    }

    protected String getUserDisplayName(ExtendedDocumentInfos extendedInfos) {
        PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        Person person = personService.getPerson(extendedInfos.getLockOwner());
        String displayName = person != null && StringUtils.isNotBlank((String)person.getDisplayName()) ? person.getDisplayName() : extendedInfos.getLockOwner();
        return displayName;
    }

    protected void getValidationWfLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        Document document = (Document)cmsContext.getDoc();
        if (!DocumentHelper.isFolder((Document)document) && pubInfos.isLiveSpace() && !pubInfos.hasDraft() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            Boolean isValidationWfRunning = extendedInfos.isValidationWorkflowRunning();
            String url = "";
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
            MenubarItem validationWfItem = new MenubarItem("VALIDATION_WF_URL", null, null, (MenubarContainer)parent, 13, "", null, null, "fancyframe_refresh");
            String onClick = this.generateCallbackParams(portalControllerContext, cmsContext);
            validationWfItem.setOnclick(onClick);
            if (BooleanUtils.isTrue((Boolean)isValidationWfRunning)) {
                HashMap requestParameters = new HashMap();
                String followWfURL = cmsService.getEcmUrl(cmsContext, EcmViews.followWfValidation, pubInfos.getDocumentPath(), requestParameters);
                validationWfItem.setUrl(followWfURL);
                validationWfItem.setTitle(bundle.getString("FOLLOW_VALIDATION_WF"));
                menubar.add(validationWfItem);
            } else if (!"approved".equals(document.getState()) && pubInfos.isEditableByUser()) {
                HashMap requestParameters = new HashMap();
                String startWfURL = cmsService.getEcmUrl(cmsContext, EcmViews.startValidationWf, pubInfos.getDocumentPath(), requestParameters);
                validationWfItem.setUrl(startWfURL);
                validationWfItem.setTitle(bundle.getString("START_VALIDATION_WF"));
                menubar.add(validationWfItem);
            }
        }
    }

    private String generateCallbackParams(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext) {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        String callbackURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, "_NEWID_", null, null, "_LIVE_", null, null, null, null);
        String ecmBaseURL = cmsService.getEcmDomain(cmsContext);
        StringBuilder onClick = new StringBuilder();
        onClick.append("javascript:setCallbackFromEcmParams('");
        onClick.append(callbackURL);
        onClick.append("', '");
        onClick.append(ecmBaseURL);
        onClick.append("');");
        return onClick.toString();
    }

    protected void getRemotePublishingLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, ExtendedDocumentInfos extendedInfos) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        Document document = (Document)cmsContext.getDoc();
        if (!DocumentHelper.isFolder((Document)document)) {
            boolean isDraftActivated;
            boolean bl = isDraftActivated = pubInfos.hasDraft() || pubInfos.isDraft();
            if (!isDraftActivated && pubInfos.isRemotePublishable() && pubInfos.isLiveSpace() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
                String url = "#";
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                MenubarItem remotePubItem = new MenubarItem("REMOTE_PUBLISHING_URL", bundle.getString("REMOTE_PUBLISHING"), null, (MenubarContainer)parent, 14, "#", null, null, null);
                Boolean isValidationWfRunning = extendedInfos.isValidationWorkflowRunning();
                if (BooleanUtils.isFalse((Boolean)isValidationWfRunning)) {
                    HashMap requestParameters = new HashMap();
                    String remotePublishingURL = cmsService.getEcmUrl(cmsContext, EcmViews.remotePublishing, pubInfos.getDocumentPath(), requestParameters);
                    remotePubItem.setUrl(remotePublishingURL);
                    remotePubItem.setHtmlClasses("fancyframe_refresh");
                    menubar.add(remotePubItem);
                } else {
                    remotePubItem.setDisabled(true);
                    menubar.add(remotePubItem);
                }
            }
        }
    }

    protected void getRenameLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) {
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        if (pubInfos.isEditableByUser()) {
            Document document = (Document)cmsContext.getDoc();
            HashMap<String, String> windowProperties = new HashMap<String, String>(1);
            windowProperties.put("osivia.cms.uri", document.getPath());
            String renameDocumentUrl = null;
            Object refreshUrl = null;
            try {
                renameDocumentUrl = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-rename-portlet-instance", windowProperties, PortalUrlType.MODAL);
            }
            catch (PortalException portalException) {
                // empty catch block
            }
            if (renameDocumentUrl != null || refreshUrl == null) {
                MenubarDropdown editionDropdown = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                MenubarItem renameMenubarItem = new MenubarItem("RENAME", bundle.getString("RENAME"), "glyphicons glyphicons-edit", (MenubarContainer)editionDropdown, 0, "#", null, null, null);
                renameMenubarItem.getData().put("target", "#osivia-modal");
                renameMenubarItem.getData().put("load-url", renameDocumentUrl);
                renameMenubarItem.getData().put("title", bundle.getString("RENAME_DOCUMENT"));
                menubar.add(renameMenubarItem);
            }
        }
    }

    protected void getEditLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle, boolean isTaskbarItem) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        String id = "EDIT";
        String icon = "glyphicons glyphicons-pencil";
        MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
        int order = 1;
        if (pubInfos.isEditableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            MenubarItem item;
            DocumentType type = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
            if (isTaskbarItem) {
                String title = bundle.getString("EDIT");
                item = new MenubarItem(id, title, icon, (MenubarContainer)parent, order, "#", null, null, null);
                item.setDisabled(true);
                menubar.add(item);
            } else if (type != null && type.isSupportsPortalForms()) {
                String callbackURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, "_NEWID_", null, null, "_LIVE_", null, null, null, null);
                String ecmBaseURL = cmsService.getEcmDomain(cmsContext);
                HashMap requestParameters = new HashMap();
                String docPathToEdit = pubInfos.getDocumentPath();
                if (pubInfos.hasDraft()) {
                    docPathToEdit = pubInfos.getDraftPath();
                }
                String url = cmsService.getEcmUrl(cmsContext, EcmViews.editDocument, docPathToEdit, requestParameters);
                StringBuilder onClick = new StringBuilder();
                onClick.append("javascript:setCallbackFromEcmParams('");
                onClick.append(callbackURL);
                onClick.append("', '");
                onClick.append(ecmBaseURL);
                onClick.append("');");
                String editLabel = null;
                if (StringUtils.isNotBlank((String)pubInfos.getPublishSpacePath())) {
                    if (!pubInfos.isLiveSpace() && !DocumentHelper.isInLiveMode((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos) && pubInfos.isBeingModified()) {
                        editLabel = bundle.getString("EDIT_LIVE_VERSION");
                    } else if (pubInfos.isLiveSpace() && (pubInfos.isDraft() || pubInfos.hasDraft())) {
                        editLabel = bundle.getString("EDIT_DRAFT");
                    } else if (type.isFile()) {
                        editLabel = bundle.getString("EDIT_METADATA");
                        icon = "glyphicons glyphicons-tags";
                    } else {
                        editLabel = bundle.getString("EDIT");
                    }
                } else {
                    editLabel = bundle.getString("EDIT");
                }
                item = new MenubarItem(id, editLabel, icon, (MenubarContainer)parent, 1, url, null, onClick.toString(), "fancyframe_refresh");
                item.setAjaxDisabled(true);
            } else {
                item = null;
            }
            if (item != null) {
                menubar.add(item);
            }
        }
    }

    protected void getMoveLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        boolean authorizedSpace = true;
        if (!NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_62)) {
            if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                return;
            }
            authorizedSpace = pubInfos.isLiveSpace();
        }
        if (authorizedSpace && pubInfos.isEditableByUser() && !pubInfos.isDraft() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
            DocumentType cmsItemType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType());
            if (cmsItemType != null && (cmsItemType.isSupportsPortalForms() || "Room".equals(document.getType()))) {
                boolean isMovable = cmsItemType.isMovable();
                if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                    isMovable = false;
                }
                if (isMovable) {
                    String moveDocumentURL;
                    try {
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("osivia.move.documentPath", document.getPath());
                        properties.put("osivia.move.cmsBasePath", nuxeoController.getBasePath());
                        properties.put("osivia.move.acceptedTypes", cmsItemType.getName());
                        moveDocumentURL = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-move-portlet-instance", properties, PortalUrlType.POPUP);
                    }
                    catch (PortalException e) {
                        moveDocumentURL = null;
                    }
                    if (moveDocumentURL != null) {
                        MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                        MenubarItem item = new MenubarItem("MOVE", bundle.getString("MOVE"), "glyphicons glyphicons-move", (MenubarContainer)parent, 2, moveDocumentURL, null, null, "fancyframe_refresh");
                        item.setAjaxDisabled(true);
                        menubar.add(item);
                    }
                }
            }
        }
    }

    protected void getReorderLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        DocumentType cmsItemType;
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        boolean authorizedSpace = true;
        if (!NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_62)) {
            if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
                return;
            }
            authorizedSpace = pubInfos.isLiveSpace();
        }
        if (authorizedSpace && pubInfos.isEditableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && (cmsItemType = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType())) != null && cmsItemType.isOrdered()) {
            String reorderDocumentsURL;
            try {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("osivia.reorder.path", document.getPath());
                reorderDocumentsURL = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, "toutatice-portail-cms-nuxeo-reorder-portlet-instance", properties, PortalUrlType.POPUP);
            }
            catch (PortalException e) {
                reorderDocumentsURL = null;
            }
            if (reorderDocumentsURL != null) {
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                MenubarItem item = new MenubarItem("REORDER", bundle.getString("REORDER"), "glyphicons glyphicons-sorting", (MenubarContainer)parent, 3, reorderDocumentsURL, null, null, "fancyframe_refresh");
                item.setAjaxDisabled(true);
                item.setBreadcrumb(true);
                menubar.add(item);
            }
        }
    }

    protected void getCreateLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        String creationType = cmsContext.getCreationType();
        String creationPath = cmsContext.getCreationPath();
        Document parentDoc = (Document)cmsContext.getDoc();
        if (creationPath != null) {
            parentDoc = (Document)cmsService.getContent(cmsContext, creationPath).getNativeItem();
        }
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        if (creationPath != null || ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
            int size;
            String url;
            String callbackURL = this.portalUrlFactory.getRefreshPageUrl(portalControllerContext, true);
            String ecmBaseURL = cmsService.getEcmDomain(cmsContext);
            StringBuilder builder = new StringBuilder();
            builder.append("javascript:setCallbackFromEcmParams('");
            builder.append(callbackURL);
            builder.append("', '");
            builder.append(ecmBaseURL);
            builder.append("');");
            String onclick = builder.toString();
            Map subTypes = pubInfos.getSubTypes();
            CMSItemTypeComparator comparator = new CMSItemTypeComparator(bundle);
            TreeMap<DocumentType, String> folderishTypes = new TreeMap<DocumentType, String>((Comparator<DocumentType>)comparator);
            TreeMap<DocumentType, String> notFolderishTypes = new TreeMap<DocumentType, String>((Comparator<DocumentType>)comparator);
            Map managedTypes = this.customizer.getCMSItemTypes();
            DocumentType containerDocType = (DocumentType)managedTypes.get(parentDoc.getType());
            if (containerDocType != null) {
                Portal portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext());
                boolean spaceSite = PortalObjectUtils.isSpaceSite((PortalObject)portal);
                for (String docType : subTypes.keySet()) {
                    DocumentType cmsItemType;
                    DocumentType docTypeDef;
                    if (!containerDocType.getPortalFormSubTypes().contains(docType) || creationType != null && !creationType.equals(docType) || (docTypeDef = (DocumentType)managedTypes.get(docType)) == null || !docTypeDef.isSupportsPortalForms() || (cmsItemType = (DocumentType)managedTypes.get(docType)) == null || spaceSite && "PortalPage".equals(cmsItemType.getName())) continue;
                    HashMap<String, String> requestParameters = new HashMap<String, String>();
                    requestParameters.put("type", docType);
                    url = cmsService.getEcmUrl(cmsContext, EcmViews.createDocument, pubInfos.getDocumentPath(), requestParameters);
                    if (cmsItemType.isFolderish()) {
                        folderishTypes.put(cmsItemType, url);
                        continue;
                    }
                    notFolderishTypes.put(cmsItemType, url);
                }
            }
            if ((size = folderishTypes.size() + notFolderishTypes.size()) == 1) {
                Map.Entry entry = folderishTypes.size() == 1 ? folderishTypes.entrySet().iterator().next() : notFolderishTypes.entrySet().iterator().next();
                String url2 = (String)entry.getValue();
                MenubarItem item = new MenubarItem("ADD", bundle.getString("ADD"), "halflings halflings-plus", (MenubarContainer)MenubarGroup.CMS, 2, url2, null, onclick, "fancyframe_refresh");
                item.setAjaxDisabled(true);
                menubar.add(item);
            } else if (size > 0) {
                MenubarItem item;
                String displayName;
                String typeName;
                DocumentType cmsItemType;
                MenubarDropdown dropdown = new MenubarDropdown("ADD", bundle.getString("ADD"), "halflings halflings-plus", MenubarGroup.CMS, 2);
                this.menubarService.addDropdown(portalControllerContext, dropdown);
                int order = 1;
                boolean divider = false;
                for (Map.Entry entry : folderishTypes.entrySet()) {
                    cmsItemType = (DocumentType)entry.getKey();
                    url = (String)entry.getValue();
                    typeName = StringUtils.upperCase((String)cmsItemType.getName());
                    displayName = bundle.getString(typeName, cmsItemType.getCustomizedClassLoader(), new Object[0]);
                    item = new MenubarItem("ADD_" + typeName, displayName, cmsItemType.getGlyph(), (MenubarContainer)dropdown, order, url, null, onclick, "fancyframe_refresh");
                    item.setAjaxDisabled(true);
                    menubar.add(item);
                    ++order;
                    divider = true;
                }
                for (Map.Entry entry : notFolderishTypes.entrySet()) {
                    cmsItemType = (DocumentType)entry.getKey();
                    url = (String)entry.getValue();
                    typeName = StringUtils.upperCase((String)cmsItemType.getName());
                    displayName = bundle.getString(typeName, cmsItemType.getCustomizedClassLoader(), new Object[0]);
                    item = new MenubarItem("ADD_" + typeName, displayName, cmsItemType.getGlyph(), (MenubarContainer)dropdown, order, url, null, onclick, "fancyframe_refresh");
                    item.setAjaxDisabled(true);
                    item.setDivider(divider);
                    menubar.add(item);
                    ++order;
                    divider = false;
                }
            }
        }
    }

    protected void getDeleteLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException, PortalException {
        DocumentType docTypeDef;
        if (cmsContext.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsContext.getDoc();
        if (DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) {
            return;
        }
        if (pubInfos.isDeletableByUser() && (pubInfos.isLiveSpace() || DocumentHelper.isInLiveMode((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos)) && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext) && (docTypeDef = (DocumentType)this.customizer.getCMSItemTypes().get(document.getType())) != null && docTypeDef.isSupportsPortalForms()) {
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
            String itemLabel = bundle.getString("DELETE");
            if (pubInfos.isDraft()) {
                itemLabel = bundle.getString("DELETE_DRAFT");
            }
            MenubarItem item = new MenubarItem("DELETE", itemLabel, "glyphicons glyphicons-bin", (MenubarContainer)parent, 20, null, null, null, null);
            item.setAjaxDisabled(true);
            item.setDivider(true);
            if (docTypeDef.isRootType()) {
                item.setUrl("#");
                item.setDisabled(true);
                item.setTooltip(bundle.getString("CANNOT_DELETE_ROOT"));
            } else {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("docId", document.getId());
                properties.put("docPath", document.getPath());
                String fancyboxId = cmsContext.getResponse().getNamespace() + "_PORTAL_DELETE";
                String removeURL = this.portalUrlFactory.getPutDocumentInTrashUrl(portalControllerContext, pubInfos.getLiveId(), pubInfos.getDocumentPath());
                if (pubInfos.isDraft()) {
                    String redirectionPath;
                    if (!pubInfos.isNotOrphanDraft()) {
                        redirectionPath = pubInfos.getDraftContextualizationPath();
                    } else {
                        String hasDraftDocWebId = DocumentHelper.getCheckinedWebIdFromDraft((Document)document);
                        redirectionPath = "webId:".concat(hasDraftDocWebId);
                    }
                    removeURL = this.portalUrlFactory.getEcmCommandUrl(portalControllerContext, document.getPath(), EcmCommonCommands.deleteDocument, redirectionPath);
                }
                String fancybox = this.generateDeleteConfirmationFancybox(properties, bundle, fancyboxId, removeURL);
                item.setAssociatedHTML(fancybox);
                String url = "#" + fancyboxId;
                item.setUrl(url);
                item.setHtmlClasses("fancybox_inline");
            }
            menubar.add(item);
        }
    }

    private String generateEraseFancyBox(Bundle bundle, String urlErase) {
        Element root = DOM4JUtils.generateDivElement((String)"hidden");
        Element container = DOM4JUtils.generateDivElement((String)"container-fluid text-center");
        DOM4JUtils.addAttribute((Element)container, (String)"id", (String)"erase_cms_page");
        root.add(container);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("ERASE_CONFIRM_MESSAGE"));
        container.add(message);
        Element okButton = DOM4JUtils.generateLinkElement((String)urlErase, null, null, (String)"btn btn-default btn-warning", (String)bundle.getString("YES"), (String)"halflings halflings-alert");
        container.add(okButton);
        Element cancelButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("NO"));
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"type", (String)"button");
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"onclick", (String)"closeFancybox()");
        container.add(cancelButton);
        return DOM4JUtils.write((Element)root);
    }

    private String generateDeleteConfirmationFancybox(Map<String, String> properties, Bundle bundle, String fancyboxId, String actionURL) {
        Element fancyboxContainer = DOM4JUtils.generateDivElement((String)"hidden");
        Element container = DOM4JUtils.generateDivElement(null);
        DOM4JUtils.addAttribute((Element)container, (String)"id", (String)fancyboxId);
        fancyboxContainer.add(container);
        Element form = DOM4JUtils.generateElement((String)"form", (String)"text-center", null, null, (AccessibilityRoles)AccessibilityRoles.FORM);
        DOM4JUtils.addAttribute((Element)form, (String)"action", (String)actionURL);
        DOM4JUtils.addAttribute((Element)form, (String)"method", (String)"post");
        container.add(form);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("CMS_DELETE_CONFIRM_MESSAGE"));
        form.add(message);
        for (Map.Entry<String, String> property : properties.entrySet()) {
            Element hidden = DOM4JUtils.generateElement((String)"input", null, null);
            DOM4JUtils.addAttribute((Element)hidden, (String)"type", (String)"hidden");
            DOM4JUtils.addAttribute((Element)hidden, (String)"name", (String)property.getKey());
            DOM4JUtils.addAttribute((Element)hidden, (String)"value", (String)property.getValue());
            form.add(hidden);
        }
        Element okButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-warning", (String)bundle.getString("YES"), (String)"halflings halflings-alert", null);
        DOM4JUtils.addAttribute((Element)okButton, (String)"type", (String)"submit");
        form.add(okButton);
        Element cancelButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("NO"));
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"type", (String)"button");
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"onclick", (String)"closeFancybox()");
        form.add(cancelButton);
        return DOM4JUtils.write((Element)fancyboxContainer);
    }

    protected void addContextualizationLinkItem(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, String displayName, String url) throws CMSException {
        MenubarItem item = new MenubarItem("CONTEXTUALIZE", bundle.getString("CONTEXTUALIZE_SPACE", new Object[]{displayName}), "halflings halflings-level-up", (MenubarContainer)MenubarGroup.SPECIFIC, 1, url, null, null, null);
        item.setAjaxDisabled(true);
        menubar.add(item);
    }

    protected void getContextualizationLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        Page page;
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        PortletRequest request = cmsContext.getRequest();
        if (!WindowState.MAXIMIZED.equals((Object)request.getWindowState())) {
            return;
        }
        if (pubInfos.isDraft()) {
            return;
        }
        Page currentPage = null;
        Window window = (Window)request.getAttribute("osivia.window");
        if (window != null) {
            currentPage = window.getPage();
        }
        Document document = (Document)cmsContext.getDoc();
        try {
            page = this.portalUrlFactory.getPortalCMSContextualizedPage(portalControllerContext, document.getPath());
        }
        catch (PortalException e) {
            page = null;
        }
        if (page == null || !page.getId().equals((Object)currentPage.getId())) {
            CMSItem pubConfig;
            String spaceDisplayName = null;
            if (page != null) {
                spaceDisplayName = PortalObjectUtils.getDisplayName((PortalObject)page, (Locale)request.getLocale());
            } else if (pubInfos.getPublishSpacePath() != null && "1".equals((pubConfig = cmsService.getSpaceConfig(cmsContext, pubInfos.getPublishSpacePath())).getProperties().get("contextualizeInternalContents"))) {
                spaceDisplayName = pubInfos.getPublishSpaceDisplayName();
            }
            if (spaceDisplayName != null) {
                String url = this.portalUrlFactory.getCMSUrl(portalControllerContext, currentPage.getId().toString(PortalObjectPath.CANONICAL_FORMAT), document.getPath(), null, "portal", null, null, null, null, null);
                this.addContextualizationLinkItem(portalControllerContext, cmsContext, menubar, bundle, spaceDisplayName, url);
            }
        }
    }

    protected void addPermaLinkItem(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle, String url) throws CMSException {
        String id = cmsContext.getResponse().getNamespace() + "PermalinkModal";
        String htmlContent = this.generatePermalinkModal(bundle, id, url);
        MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "SHARE");
        MenubarItem item = new MenubarItem("PERMALINK", bundle.getString("PERMALINK"), "glyphicons glyphicons-link", (MenubarContainer)parent, 1, "#", null, null, null);
        item.getData().put("toggle", "modal");
        item.getData().put("target", "#" + id);
        item.setAjaxDisabled(true);
        item.setAssociatedHTML(htmlContent);
        menubar.add(item);
    }

    private void addEmailLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        if (pubInfos.isLiveSpace() || !pubInfos.isLiveSpace() && pubInfos.isPublished()) {
            HashMap requestParameters = new HashMap();
            String url = cmsService.getEcmUrl(cmsContext, EcmViews.shareDocument, pubInfos.getDocumentPath(), requestParameters);
            String callbackURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, "_NEWID_", null, null, "_LIVE_", null, null, null, null);
            String ecmBaseURL = cmsService.getEcmDomain(cmsContext);
            StringBuilder onClick = new StringBuilder();
            onClick.append("javascript:setCallbackFromEcmParams('");
            onClick.append(callbackURL);
            onClick.append("', '");
            onClick.append(ecmBaseURL);
            onClick.append("');");
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "SHARE");
            MenubarItem item = new MenubarItem("SHARE_BY_EMAIL", bundle.getString("SHARE_EMAIL"), "social social-e-mail", (MenubarContainer)parent, 2, url, null, onClick.toString(), "fancyframe_refresh");
            item.setAjaxDisabled(true);
            menubar.add(item);
        }
    }

    protected String computePermaLinkUrl(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        String url;
        PortletRequest request = cmsContext.getRequest();
        HashMap<String, String> parameters = null;
        String selectors = request.getParameter("selectors");
        if (selectors != null) {
            parameters = new HashMap<String, String>();
            Map decodedSelectors = PageSelectors.decodeProperties((String)selectors);
            parameters.put("selectors", PageSelectors.encodeProperties((Map)decodedSelectors));
        }
        String path = this.customizer.getContentWebIdPath(cmsContext);
        String permaLinkType = "cms";
        if (this.hasWebId(cmsContext) && !DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsContext, (CMSPublicationInfos)pubInfos) && (pubInfos.isLiveSpace() || !pubInfos.isLiveSpace() && StringUtils.isNotBlank((String)pubInfos.getPublishSpacePath()))) {
            permaLinkType = "share";
        }
        try {
            url = this.portalUrlFactory.getPermaLink(portalControllerContext, null, parameters, path, permaLinkType);
        }
        catch (PortalException e) {
            url = null;
        }
        return ContextualizationHelper.getLivePath(url);
    }

    protected boolean mustDisplayPermalink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        boolean displayPermalink = false;
        if (WindowState.MAXIMIZED.equals((Object)cmsContext.getRequest().getWindowState()) && cmsContext.getDoc() != null) {
            displayPermalink = !DocumentHelper.isLocalPublishLive((Document)((Document)cmsContext.getDoc())) && !DocumentHelper.isDraft((Document)((Document)cmsContext.getDoc()));
        } else {
            Portal portal;
            boolean spaceSite;
            if (ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsContext)) {
                displayPermalink = true;
            }
            if (spaceSite = PortalObjectUtils.isSpaceSite((PortalObject)(portal = PortalObjectUtils.getPortal((ControllerContext)cmsContext.getControllerContext())))) {
                displayPermalink = false;
            }
        }
        return displayPermalink;
    }

    protected void getPermaLinkLink(PortalControllerContext portalControllerContext, CMSServiceCtx cmsContext, CMSPublicationInfos pubInfos, List<MenubarItem> menubar, Bundle bundle) throws CMSException {
        if (!this.mustDisplayPermalink(portalControllerContext, cmsContext, menubar, bundle)) {
            return;
        }
        String url = this.computePermaLinkUrl(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
        if (url != null) {
            this.addPermaLinkItem(portalControllerContext, cmsContext, menubar, bundle, url);
            this.addEmailLink(portalControllerContext, cmsContext, pubInfos, menubar, bundle);
        }
    }

    private String generatePermalinkModal(Bundle bundle, String id, String url) {
        String labelId = id + "Label";
        Element container = DOM4JUtils.generateDivElement((String)"modal fade", (AccessibilityRoles)AccessibilityRoles.DIALOG);
        DOM4JUtils.addAttribute((Element)container, (String)"id", (String)id);
        DOM4JUtils.addAttribute((Element)container, (String)"tabindex", (String)"-1");
        DOM4JUtils.addAriaAttribute((Element)container, (String)"labelledby", (String)labelId);
        Element document = DOM4JUtils.generateDivElement((String)"modal-dialog", (AccessibilityRoles)AccessibilityRoles.DOCUMENT);
        container.add(document);
        Element content = DOM4JUtils.generateDivElement((String)"modal-content");
        document.add(content);
        Element header = DOM4JUtils.generateDivElement((String)"modal-header");
        content.add(header);
        Element close = DOM4JUtils.generateElement((String)"button", (String)"close", null);
        DOM4JUtils.addAttribute((Element)close, (String)"type", (String)"button");
        DOM4JUtils.addDataAttribute((Element)close, (String)"dismiss", (String)"modal");
        DOM4JUtils.addAriaAttribute((Element)close, (String)"label", (String)bundle.getString("CLOSE"));
        header.add(close);
        Element closeLabel = DOM4JUtils.generateElement((String)"span", null, (String)"&times;");
        DOM4JUtils.addAriaAttribute((Element)closeLabel, (String)"hidden", (String)String.valueOf(true));
        close.add(closeLabel);
        Element title = DOM4JUtils.generateElement((String)"h4", (String)"modal-title", (String)bundle.getString("PERMALINK"), (String)"glyphicons glyphicons-link", null);
        DOM4JUtils.addAttribute((Element)title, (String)"id", (String)labelId);
        header.add(title);
        Element body = DOM4JUtils.generateDivElement((String)"modal-body");
        content.add(body);
        Element paragraph = DOM4JUtils.generateElement((String)"p", null, null);
        body.add(paragraph);
        Element link = DOM4JUtils.generateLinkElement((String)url, null, null, null, (String)url);
        paragraph.add(link);
        return DOM4JUtils.write((Element)container);
    }

    public IMenubarService getMenubarService() {
        return this.menubarService;
    }

    public ICMSServiceLocator getCmsServiceLocator() {
        return this.cmsServiceLocator;
    }

    public IPortalUrlFactory getPortalUrlFactory() {
        return this.portalUrlFactory;
    }

    public DefaultCMSCustomizer getCustomizer() {
        return this.customizer;
    }

    public IContributionService getContributionService() {
        return this.contributionService;
    }

    public ITaskbarService getTaskbarService() {
        return this.taskbarService;
    }

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }
}

