/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.UserPagesPreloadCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetUserProfileCommand;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class UserPagesLoader {
    private final ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws Exception {
        CMSService cmsService = (CMSService)this.cmsServiceLocator.getCMSService();
        ArrayList<CMSPage> pages = new ArrayList<CMSPage>();
        if (cmsCtx.getServerInvocation().getServerContext().getClientRequest().getUserPrincipal() != null) {
            String userName = cmsCtx.getServerInvocation().getServerContext().getClientRequest().getUserPrincipal().getName();
            cmsService.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new GetUserProfileCommand(userName));
            Documents children = (Documents)cmsService.executeNuxeoCommand(cmsCtx, (INuxeoCommand)new UserPagesPreloadCommand());
            for (Document child : children) {
                String spacePath = DocumentHelper.computeNavPath((String)child.getPath());
                CMSItem publishSpace = cmsService.createNavigationItem(cmsCtx, spacePath, child.getTitle(), child, spacePath);
                CMSPage userPage = new CMSPage();
                userPage.setPublishSpace(publishSpace);
                pages.add(userPage);
            }
        }
        return pages;
    }
}

