/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.comments;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.ThreadPostDTO;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class AddCommentCommand
implements INuxeoCommand {
    private final Document document;
    private final CommentDTO comment;
    private final String parentId;

    public AddCommentCommand(Document document, CommentDTO comment, String parentId) {
        this.document = document;
        this.comment = comment;
        this.parentId = parentId;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request;
        String title = null;
        File attachment = null;
        String filename = null;
        if (this.comment instanceof ThreadPostDTO) {
            ThreadPostDTO threadPost = (ThreadPostDTO)this.comment;
            title = threadPost.getTitle();
            attachment = threadPost.getAttachment();
            filename = threadPost.getFilename();
        }
        if (StringUtils.isBlank((String)this.parentId)) {
            request = nuxeoSession.newRequest("Document.AddComment");
        } else {
            request = nuxeoSession.newRequest("Document.CreateChildComment");
            request.set("parent", (Object)this.parentId);
        }
        request.set("document", (Object)this.document.getId());
        request.set("content", (Object)this.comment.getContent());
        request.set("author", (Object)this.comment.getAuthor());
        request.set("creationDate", (Object)this.comment.getCreationDate());
        request.set("title", (Object)title);
        if (attachment != null) {
            request.set("fileName", (Object)filename);
            request.setInput((OperationInput)new FileBlob(attachment));
        }
        return request.execute();
    }

    public String getId() {
        return null;
    }
}

