/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.CustomizedJsp;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.fragment.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.CommentsFormatter;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.NuxeoCommentsServiceImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.BinaryTimestamp;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomizationPluginMgr;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.BrowserAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.DefaultPlayer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.MenuBarFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.NavigationItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.UserPagesLoader;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WysiwygParser;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.XSLFunctions;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.ContextDocumentsHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.AttachmentsFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.DocumentPictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.LinkFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.NavigationPictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.PropertyFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.SitePictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.SpaceMenubarFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.service.commands.DeleteDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.EraseModificationsCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.LockCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.SubscribeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.SynchronizeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnlockCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnsubscribeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnsynchronizeCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.FragmentEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.HTMLEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.ListEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.PictureEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.PortletEditableWindow;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceURL;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpSessionEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.server.ServerInvocation;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.ecm.EcmCommand;
import org.osivia.portal.api.ecm.EcmCommonCommands;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.panels.PanelPlayer;
import org.osivia.portal.api.player.Player;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarFactory;
import org.osivia.portal.api.taskbar.TaskbarItem;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.BinaryDelegation;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.customization.ICustomizationService;
import org.osivia.portal.core.page.PageProperties;
import org.osivia.portal.core.web.IWebIdService;
import org.osivia.portal.core.web.IWebUrlService;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DefaultCMSCustomizer
implements INuxeoCustomizer {
    public static final String DEFAULT_SCHEMAS = "dublincore, common, toutatice, file";
    public static final String TEMPLATE_DOWNLOAD = "download";
    private static final String AVATAR_SERVLET = "/toutatice-portail-cms-nuxeo/avatar?username=";
    private static final String BINARY_SERVLET = "/toutatice-portail-cms-nuxeo/binary";
    private static final String TABS_PROPERTY = "osivia.navigationInSpaceTabs";
    private final Log log = LogFactory.getLog(this.getClass());
    private final PortletContext portletContext;
    private final CMSService cmsService;
    private final Map<String, Map<String, BinaryDelegation>> delegations;
    private final Map<String, INuxeoPlayerModule> players;
    private final Map<String, PanelPlayer> navigationPanelPlayers;
    private final Map<String, String> avatarMap;
    private final Map<String, BinaryTimestamp> binaryTimestamps;
    private final CustomizationPluginMgr pluginManager;
    private final NuxeoConnectionProperties nuxeoConnection;
    private final UserPagesLoader userPagesLoader;
    private final MenuBarFormater menubarFormater;
    private final BrowserAdapter browserAdapter;
    @Deprecated
    private final NavigationItemAdapter navigationItemAdapter;
    private final ClassLoader classLoader;
    private final XMLReader parser;
    private final IPortalUrlFactory portalUrlFactory;
    private final IWebIdService webIdService;
    private final IWebUrlService webUrlService;
    private final ITaskbarService taskbarService;
    private final ICustomizationService customizationService;
    private final INuxeoCommentsService nuxeoCommentsService;
    private final IInternationalizationService internationalizationService;
    private final IBundleFactory bundleFactory;
    private final INotificationsService notificationsService;

    public DefaultCMSCustomizer(PortletContext portletContext, CMSService cmsService) {
        this.portletContext = portletContext;
        this.cmsService = cmsService;
        this.delegations = new ConcurrentHashMap();
        this.players = new ConcurrentHashMap();
        this.players.put("defaultPlayer", new DefaultPlayer());
        this.navigationPanelPlayers = new ConcurrentHashMap();
        this.navigationPanelPlayers.put("toutatice-portail-cms-nuxeo-fileBrowserPortletInstance", this.getFileBrowserPanelPlayer());
        this.avatarMap = new ConcurrentHashMap();
        this.binaryTimestamps = new ConcurrentHashMap();
        this.pluginManager = new CustomizationPluginMgr(this);
        this.nuxeoConnection = new NuxeoConnectionProperties();
        this.userPagesLoader = new UserPagesLoader();
        this.menubarFormater = new MenuBarFormater(this);
        this.browserAdapter = BrowserAdapter.getInstance((CMSService)cmsService);
        this.navigationItemAdapter = new NavigationItemAdapter(this);
        try {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            this.parser = WysiwygParser.getInstance().getParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
        this.webIdService = (IWebIdService)Locator.findMBean(IWebIdService.class, (String)"osivia:service=webIdService");
        this.webUrlService = (IWebUrlService)Locator.findMBean(IWebUrlService.class, (String)"osivia:service=webUrlService");
        this.taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
        this.customizationService = (ICustomizationService)Locator.findMBean(ICustomizationService.class, (String)"osivia:service=CustomizationService");
        this.nuxeoCommentsService = new NuxeoCommentsServiceImpl(this.cmsService);
        this.internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = this.internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.notificationsService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
    }

    public final Map<String, EditableWindow> getEditableWindows(Locale locale) {
        return this.pluginManager.customizeEditableWindows(locale);
    }

    public Map<String, EditableWindow> initEditableWindows(Locale locale) {
        HashMap<String, EditableWindow> map = new HashMap<String, EditableWindow>();
        map.put("fgt.html", (EditableWindow)new HTMLEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "html_Frag_"));
        map.put("fgt.list", (EditableWindow)new ListEditableWindow("toutatice-portail-cms-nuxeo-viewListPortletInstance", "liste_Frag_"));
        map.put("fgt.picture", (EditableWindow)new PictureEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "picture_Frag_"));
        map.put("fgt.portlet", (EditableWindow)new PortletEditableWindow("", "portlet_Frag_"));
        map.put("ew.fragment", (EditableWindow)new FragmentEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "ew_frag_"));
        return map;
    }

    public final List<ListTemplate> getListTemplates(Locale locale) {
        return this.pluginManager.customizeListTemplates(locale);
    }

    public List<ListTemplate> initListTemplates(Locale locale) {
        ArrayList<ListTemplate> templates = new ArrayList<ListTemplate>();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        templates.add(new ListTemplate("mini", bundle.getString("LIST_TEMPLATE_MINI"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("normal", bundle.getString("LIST_TEMPLATE_NORMAL"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("detailed", bundle.getString("LIST_TEMPLATE_DETAILED"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("editorial", bundle.getString("LIST_TEMPLATE_EDITORIAL"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("contextual-links", bundle.getString("LIST_TEMPLATE_CONTEXTUAL_LINKS"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("search-results", bundle.getString("LIST_TEMPLATE_SEARCH_RESULTS"), "*"));
        return templates;
    }

    public final Map<String, FragmentType> getFragmentTypes(Locale locale) {
        return this.pluginManager.getFragments(locale);
    }

    public Map<String, FormFilter> getFormsFilters() {
        return this.pluginManager.getFormFilters();
    }

    public List<FragmentType> initListFragments(Locale locale) {
        ArrayList<FragmentType> fragmentTypes = new ArrayList<FragmentType>();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        fragmentTypes.add(new FragmentType("text_property", bundle.getString("FRAGMENT_TYPE_TEXT"), (IFragmentModule)new PropertyFragmentModule(this.portletContext, false)));
        fragmentTypes.add(new FragmentType("html_property", bundle.getString("FRAGMENT_TYPE_HTML"), (IFragmentModule)new PropertyFragmentModule(this.portletContext, true)));
        fragmentTypes.add(new FragmentType("navigation_picture", bundle.getString("FRAGMENT_TYPE_NAVIGATION_PICTURE"), (IFragmentModule)new NavigationPictureFragmentModule(this.portletContext)));
        fragmentTypes.add(new FragmentType("document_picture", bundle.getString("FRAGMENT_TYPE_DOCUMENT_PICTURE"), (IFragmentModule)new DocumentPictureFragmentModule(this.portletContext)));
        fragmentTypes.add(new FragmentType("doc_link", bundle.getString("FRAGMENT_TYPE_LINK"), (IFragmentModule)new LinkFragmentModule(this.portletContext)));
        fragmentTypes.add(new FragmentType("space_menubar", bundle.getString("FRAGMENT_TYPE_MENUBAR"), (IFragmentModule)new SpaceMenubarFragmentModule(this.portletContext)));
        fragmentTypes.add(new FragmentType("site_picture", bundle.getString("FRAGMENT_TYPE_SITE_PICTURE"), (IFragmentModule)new SitePictureFragmentModule(this.portletContext)));
        fragmentTypes.add(new FragmentType("attachments", bundle.getString("FRAGMENT_TYPE_ATTACHMENTS"), (IFragmentModule)new AttachmentsFragmentModule(this.portletContext)));
        return fragmentTypes;
    }

    public SortedMap<String, String> getMenuTemplates(Locale locale) {
        return this.pluginManager.customizeMenuTemplates(locale);
    }

    public SortedMap<String, String> initMenuTemplates(Locale locale) {
        SortedMap<String, String> templates = Collections.synchronizedSortedMap(new TreeMap());
        Bundle bundle = this.bundleFactory.getBundle(locale);
        templates.put("", bundle.getString("MENU_TEMPLATE_DEFAULT"));
        templates.put("horizontal", bundle.getString("MENU_TEMPLATE_HORIZONTAL"));
        templates.put("footer", bundle.getString("MENU_TEMPLATE_FOOTER"));
        templates.put("fancytree-lazy", bundle.getString("MENU_TEMPLATE_FANCYTREE_LAZY"));
        templates.put("fancytree-filter", bundle.getString("MENU_TEMPLATE_FANCYTREE_FILTER"));
        return templates;
    }

    public static String getSearchSchema() {
        return "dublincore,common,file,toutatice";
    }

    public Player getCMSDefaultPlayer(CMSServiceCtx ctx) throws PortletException {
        Document doc = (Document)ctx.getDoc();
        NuxeoDocumentContext docCtx = NuxeoController.getDocumentContext((CMSServiceCtx)ctx, (String)doc.getPath());
        return this.getCMSDefaultPlayer((DocumentContext)docCtx);
    }

    public Player getCMSDefaultPlayer(DocumentContext<Document> docCtx) {
        return ((INuxeoPlayerModule)this.players.get("defaultPlayer")).getCMSPlayer(docCtx);
    }

    public Player getCMSOrderedFolderPlayer(DocumentContext<Document> docCtx) throws CMSException {
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        Document doc = (Document)docCtx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", NuxeoController.createFolderRequest(docCtx, (boolean)true));
        windowProperties.put("osivia.cms.style", "editorial");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", navigationInfos.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", navigationInfos.getState().toString());
        windowProperties.put("osivia.document.metadata", String.valueOf(false));
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public Player getCMSFileBrowser(DocumentContext<Document> docCtx) {
        Document document = (Document)docCtx.getDoc();
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.displayLiveVersion", navigationInfos.getState().toString());
        windowProperties.put("osivia.cms.uri", document.getPath());
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-fileBrowserPortletInstance");
        return linkProps;
    }

    public Player getCMSFolderPlayer(DocumentContext<Document> docCtx) throws CMSException {
        Document doc = (Document)docCtx.getDoc();
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", NuxeoController.createFolderRequest(docCtx, (boolean)false));
        windowProperties.put("osivia.cms.style", "editorial");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", navigationInfos.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", navigationInfos.getState().toString());
        windowProperties.put("osivia.title", doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public Player getCMSSectionPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", "ecm:path STARTSWITH '" + doc.getPath() + "' AND ecm:mixinType != 'Folderish' ORDER BY dc:modified DESC");
        windowProperties.put("osivia.cms.style", "editorial");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public Player createPortletLink(CMSServiceCtx ctx, String portletInstance, String uid) {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.cms.uri", uid);
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance(portletInstance);
        return linkProps;
    }

    public Player getCMSPlayer(CMSServiceCtx cmsContext) throws Exception {
        Document document = (Document)cmsContext.getDoc();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsContext, document.getPath());
        boolean workspace = cmsContext.getContextualizationBasePath() != null && pubInfos.isLiveSpace();
        List modules = this.pluginManager.customizeModules();
        NuxeoDocumentContext docCtx = NuxeoController.getDocumentContext((CMSServiceCtx)cmsContext, (String)document.getPath());
        for (INuxeoPlayerModule module : modules) {
            Player player = module.getCMSPlayer((DocumentContext)docCtx);
            if (player == null) continue;
            return player;
        }
        if ("UserWorkspace".equals(document.getType())) {
            cmsContext.setDisplayLiveVersion("1");
            return this.getCMSFileBrowser((DocumentContext)docCtx);
        }
        if ("UserProfile".equals(document.getType())) {
            return this.getUserProfilePlayer((DocumentContext)docCtx);
        }
        if ("Folder".equals(document.getType()) || "OrderedFolder".equals(document.getType()) || "Section".equals(document.getType())) {
            if (workspace) {
                cmsContext.setDisplayLiveVersion("1");
                Player player = this.getCMSFileBrowser((DocumentContext)docCtx);
                Map properties = player.getWindowProperties();
                properties.put("osivia.title", document.getTitle());
                properties.put("osivia.subtitle", document.getString("dc:description"));
                PropertyMap vignetteProperties = document.getProperties().getMap("ttc:vignette");
                if (vignetteProperties != null && StringUtils.isNotEmpty((String)vignetteProperties.getString("data"))) {
                    BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.FILE, document.getPath());
                    binary.setFieldName("ttc:vignette");
                    binary.setDocument((Object)document);
                    Link vignetteLink = this.cmsService.getBinaryResourceURL(cmsContext, binary);
                    properties.put("osivia.vignette.url", vignetteLink.getUrl());
                }
                return player;
            }
            if ("Folder".equals(document.getType())) {
                return this.getCMSFolderPlayer((DocumentContext)docCtx);
            }
            return this.getCMSOrderedFolderPlayer((DocumentContext)docCtx);
        }
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)cmsContext);
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.CMS_PLAYER);
            Documents configs = null;
            try {
                configs = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)cmsContext, (CMSService)this.cmsService, (WebConfigurationQueryCommand)command);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configs != null && configs.size() > 0) {
                for (Document config : configs) {
                    String documentType = config.getProperties().getString("wconf:code");
                    String playerInstance = config.getProperties().getString("wconf:code2");
                    if (!document.getType().equals(documentType) || !this.players.containsKey(playerInstance)) continue;
                    HashMap<String, String> windowProperties = new HashMap<String, String>();
                    PropertyList list = config.getProperties().getList("wconf:options");
                    for (Object o : list.list()) {
                        if (!(o instanceof PropertyMap)) continue;
                        PropertyMap map = (PropertyMap)o;
                        windowProperties.put(map.get("propertyName").toString(), map.get("propertyDefaultValue").toString());
                    }
                    return ((INuxeoPlayerModule)this.players.get(playerInstance)).getCMSPlayer((DocumentContext)docCtx);
                }
            }
        }
        return ((INuxeoPlayerModule)this.players.get("defaultPlayer")).getCMSPlayer((DocumentContext)docCtx);
    }

    public Player getUserProfilePlayer(DocumentContext<Document> docCtx) {
        Document doc = (Document)docCtx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "true");
        windowProperties.put("osivia.title", doc.getTitle());
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("uidFichePersonne", doc.getProperties().getString("ttc_userprofile:login"));
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("directory-person-card-instance");
        return linkProps;
    }

    public String getDefaultExternalViewer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        String externalUrl = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + doc.getId() + "/view_documents";
        return externalUrl;
    }

    public String createPortletDelegatedExternalLink(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        ResourceURL resourceURL = ctx.getResponse().createResourceURL();
        resourceURL.setResourceID(doc.getId());
        resourceURL.setParameter("type", "link");
        return resourceURL.toString();
    }

    public String createPortletDelegatedFileContentLink(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        ResourceURL resourceURL = ctx.getResponse().createResourceURL();
        resourceURL.setResourceID(doc.getId() + "/file:content");
        resourceURL.setParameter("type", "file");
        resourceURL.setParameter("docPath", doc.getPath());
        resourceURL.setParameter("fieldName", "file:content");
        resourceURL.setCacheability("cacheLevelPage");
        return resourceURL.toString();
    }

    public String getNuxeoNativeViewerUrl(CMSServiceCtx ctx) {
        if ("file-browser-menu-workspace".equals(ctx.getDisplayContext())) {
            return this.getDefaultExternalViewer(ctx);
        }
        return null;
    }

    public Link createCustomLink(CMSServiceCtx cmsContext) throws Exception {
        Document document = (Document)cmsContext.getDoc();
        String displayContext = cmsContext.getDisplayContext();
        String url = null;
        boolean externalLink = false;
        boolean downloadable = false;
        if (!"detailedView".equals(displayContext)) {
            if (("File".equals(document.getType()) || "Audio".equals(document.getType()) || "Video".equals(document.getType())) && (TEMPLATE_DOWNLOAD.equals(displayContext) || "downloadVersion".equals(displayContext))) {
                url = this.createFileDownloadLink(cmsContext, document, displayContext);
                boolean bl = downloadable = url != null;
            }
            if ("ContextualLink".equals(document.getType()) && !"document".equals(displayContext) && !"fileExplorer".equals(displayContext)) {
                url = this.createPortletDelegatedExternalLink(cmsContext);
                externalLink = true;
            }
            if (url == null) {
                url = this.getNuxeoNativeViewerUrl(cmsContext);
                externalLink = true;
            }
        }
        if (url != null) {
            Link link = new Link(url, externalLink);
            link.setDownloadable(downloadable);
            return link;
        }
        return null;
    }

    public String createFileDownloadLink(CMSServiceCtx cmsContext, Document document, String displayContext) {
        String downloadUrl = null;
        PropertyMap attachedFileProperties = document.getProperties().getMap("file:content");
        if (attachedFileProperties != null && !attachedFileProperties.isEmpty()) {
            NuxeoController nuxeoCtl = new NuxeoController(cmsContext.getRequest(), (PortletResponse)cmsContext.getResponse(), cmsContext.getPortletCtx());
            nuxeoCtl.setCurrentDoc(document);
            if (TEMPLATE_DOWNLOAD.equals(displayContext)) {
                downloadUrl = nuxeoCtl.createFileLink(document, "file:content");
            } else if ("downloadVersion".equals(displayContext)) {
                downloadUrl = nuxeoCtl.createFileLinkOfVersion(document, "file:content");
            }
        }
        return downloadUrl;
    }

    public void formatContentMenuBar(CMSServiceCtx ctx) throws Exception {
        CMSPublicationInfos publicationInfos = null;
        ExtendedDocumentInfos extendedDocumentInfos = null;
        if (ctx.getDoc() != null) {
            Document doc = (Document)ctx.getDoc();
            publicationInfos = this.cmsService.getPublicationInfos(ctx, doc.getPath());
            extendedDocumentInfos = this.cmsService.getExtendedDocumentInfos(ctx, doc.getPath());
        }
        this.menubarFormater.formatContentMenuBar(ctx, publicationInfos, extendedDocumentInfos);
    }

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws Exception {
        return this.userPagesLoader.computeUserPreloadedPages(cmsCtx);
    }

    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws Exception {
        return null;
    }

    public String addPublicationFilter(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy) throws Exception {
        String requestFilter = "";
        String hiddenOrUserProfileAndNotDeleted = "((ecm:mixinType != 'HiddenInNavigation' AND ecm:primaryType != 'UserProfile') OR (ecm:primaryType = 'UserProfile')) AND ecm:currentLifeCycleState <> 'deleted' AND ecm:isCheckedInVersion = 0 ";
        requestFilter = "1".equals(ctx.getDisplayLiveVersion()) ? hiddenOrUserProfileAndNotDeleted + " AND ecm:isProxy = 0 " : ("2".equals(ctx.getDisplayLiveVersion()) ? hiddenOrUserProfileAndNotDeleted + " AND ecm:mixinType <> 'isLocalPublishLive'" : hiddenOrUserProfileAndNotDeleted + " AND ecm:isProxy = 1");
        return this.addExtraNxQueryFilters(ctx, nuxeoRequest, requestFilteringPolicy, requestFilter);
    }

    protected String addExtraNxQueryFilters(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy, String requestFilter) throws Exception {
        String policyFilter = null;
        ServerInvocation invocation = ctx.getServerInvocation();
        String portalName = null;
        if (invocation != null) {
            portalName = (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
        }
        if (portalName != null) {
            String extraFilter;
            PortalObjectContainer portalObjectContainer = (PortalObjectContainer)invocation.getAttribute(Scope.REQUEST_SCOPE, (Object)"osivia.portalObjectContainer");
            PortalObject po = portalObjectContainer.getObject(PortalObjectId.parse((String)"", (String)("/" + portalName), (PortalObjectPath.Format)PortalObjectPath.CANONICAL_FORMAT));
            if (requestFilteringPolicy != null) {
                policyFilter = requestFilteringPolicy;
            } else {
                String sitePolicy = po.getProperty("osivia.cms.requestFilteringPolicy");
                if (sitePolicy != null) {
                    if ("local".equals(sitePolicy)) {
                        policyFilter = "local";
                    }
                } else {
                    String portalType = po.getProperty("osivia.portal.portalType");
                    if ("space".equals(portalType)) {
                        policyFilter = "local";
                    }
                }
            }
            if ("local".equals(policyFilter)) {
                String pathFilter = "";
                for (PortalObject child : ((Portal)po).getChildren(4)) {
                    String cmsPath = child.getDeclaredProperty("osivia.cms.basePath");
                    if (cmsPath == null || cmsPath.length() <= 0) continue;
                    if (pathFilter.length() > 0) {
                        pathFilter = pathFilter + " OR ";
                    }
                    pathFilter = pathFilter + "ecm:path STARTSWITH '" + cmsPath + "'";
                }
                if (pathFilter.length() > 0) {
                    requestFilter = requestFilter + " AND (" + pathFilter + ")";
                }
            }
            if ((extraFilter = this.getExtraRequestFilter(ctx, requestFilteringPolicy)) != null) {
                requestFilter = requestFilter + " OR (" + extraFilter + ")";
            }
        }
        String beforeOrderBy = "";
        String orderBy = "";
        String editedNuxeoRequest = nuxeoRequest;
        try {
            Pattern ressourceExp = Pattern.compile("(.*)ORDER([ ]*)BY(.*)");
            Matcher m = ressourceExp.matcher(editedNuxeoRequest.toUpperCase());
            m.matches();
            if (m.groupCount() == 3) {
                beforeOrderBy = editedNuxeoRequest.substring(0, m.group(1).length());
                orderBy = editedNuxeoRequest.substring(m.group(1).length());
            }
        }
        catch (IllegalStateException e) {
            beforeOrderBy = editedNuxeoRequest;
        }
        String finalRequest = beforeOrderBy;
        if (StringUtils.isNotBlank((String)requestFilter)) {
            if (finalRequest.length() > 0) {
                finalRequest = finalRequest + " AND ";
            }
            finalRequest = finalRequest + "(" + requestFilter + ") ";
        }
        editedNuxeoRequest = finalRequest = finalRequest + " " + orderBy;
        return editedNuxeoRequest;
    }

    public String addSearchFilter(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy) throws Exception {
        StringBuilder filter = new StringBuilder();
        filter.append(" ecm:mixinType <> 'HiddenInNavigation' AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0");
        filter.append(" AND ecm:mixinType <> 'isLocalPublishLive'");
        return this.addExtraNxQueryFilters(ctx, nuxeoRequest, requestFilteringPolicy, filter.toString());
    }

    public String getExtraRequestFilter(CMSServiceCtx ctx, String requestFilteringPolicy) throws Exception {
        String extraRequetFilter = null;
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)ctx);
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.EXTRA_REQUEST_FILTER);
            Documents configs = null;
            configs = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)ctx, (CMSService)this.cmsService, (WebConfigurationQueryCommand)command);
            if (configs.size() > 0) {
                extraRequetFilter = "";
                int i = 0;
                for (Document config : configs) {
                    String nxqlCode = config.getProperties().getString("wconf:code");
                    if (nxqlCode == null) continue;
                    if (i > 0) {
                        extraRequetFilter = extraRequetFilter.concat("OR");
                    }
                    extraRequetFilter = extraRequetFilter.concat(" ").concat(nxqlCode);
                    ++i;
                }
            }
        }
        return extraRequetFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transformHTMLContent(CMSServiceCtx ctx, String htmlContent) throws Exception {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            Transformer transformer = WysiwygParser.getInstance().getTemplate().newTransformer();
            transformer.setParameter("bridge", new XSLFunctions((INuxeoCustomizer)this, ctx));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            XMLReader parser = WysiwygParser.getInstance().getParser();
            transformer.transform(new SAXSource(parser, new InputSource(new StringReader(htmlContent))), new StreamResult(output));
            String string = ((Object)output).toString();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    public String transformLink(CMSServiceCtx ctx, String link) {
        XSLFunctions xslFunctions = new XSLFunctions((INuxeoCustomizer)this, ctx);
        String nxPublicDomainUri = NuxeoConnectionProperties.getPublicDomainUri().toString();
        if (StringUtils.isBlank((String)nxPublicDomainUri) && ctx != null && ctx.getRequest() != null) {
            nxPublicDomainUri = ctx.getRequest().getScheme() + "://" + ctx.getRequest().getServerName();
        }
        return xslFunctions.link(nxPublicDomainUri + link);
    }

    public Link getLinkFromNuxeoURL(CMSServiceCtx cmsContext, String url) {
        Link link;
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsContext.getControllerContext());
        if (StringUtils.startsWith((String)url, (String)"/nuxeo/")) {
            Page page;
            Window window;
            String nuxeoURL = StringUtils.substringBefore((String)url, (String)"#");
            String anchor = StringUtils.substringAfter((String)url, (String)"#");
            String cmsPath = this.transformNuxeoURL(cmsContext, nuxeoURL);
            HashMap parameters = new HashMap(0);
            String currentPagePath = null;
            if (cmsContext.getRequest() != null && (window = (Window)cmsContext.getRequest().getAttribute("osivia.window")) != null && (page = window.getPage()) != null) {
                currentPagePath = page.getId().toString(PortalObjectPath.CANONICAL_FORMAT);
            }
            String portalURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, currentPagePath, cmsPath, parameters, null, null, null, null, null, null);
            if (StringUtils.isNotBlank((String)anchor)) {
                portalURL = portalURL + "#" + anchor;
            }
            link = new Link(portalURL, false);
        } else if (StringUtils.isBlank((String)url)) {
            link = new Link("#", false);
        } else {
            boolean external;
            StringBuilder builder = new StringBuilder();
            if (!StringUtils.startsWithIgnoreCase((String)url, (String)"http://") && !StringUtils.startsWithIgnoreCase((String)url, (String)"https://")) {
                builder.append("http://");
            }
            builder.append(url);
            String absoluteURL = builder.toString();
            try {
                URL urlObject = new URL(absoluteURL);
                String serverName = cmsContext.getRequest().getServerName();
                external = !StringUtils.equals((String)urlObject.getHost(), (String)serverName);
            }
            catch (Exception e) {
                external = false;
            }
            link = new Link(absoluteURL, external);
        }
        return link;
    }

    private String transformNuxeoURL(CMSServiceCtx cmsContext, String url) {
        String cmsPath = null;
        if (StringUtils.startsWith((String)url, (String)"/nuxeo/web/")) {
            String webId = StringUtils.removeStart((String)url, (String)"/nuxeo/web/");
            if (webId.contains("/")) {
                webId = StringUtils.substringAfterLast((String)webId, (String)"/");
            }
            if (webId.contains(".")) {
                webId = StringUtils.substringBefore((String)webId, (String)".");
            }
            cmsPath = this.webIdService.webIdToCmsPath(webId);
        } else if (StringUtils.startsWith((String)url, (String)"/nuxeo/nxpath/")) {
            cmsPath = StringUtils.removeStart((String)url, (String)"/nuxeo/nxpath/");
            cmsPath = "/" + StringUtils.substringAfter((String)cmsPath, (String)"/");
        }
        if (cmsPath == null) {
            this.log.warn((Object)("Invalid Nuxeo URL: '" + url + "'."));
        }
        return cmsPath;
    }

    public Map<String, DocumentType> getCMSItemTypes() {
        return this.pluginManager.customizeCMSItemTypes();
    }

    protected List<DocumentType> getCustomizedCMSItemTypes() {
        return new ArrayList<DocumentType>();
    }

    public List<DocumentType> getDefaultCMSItemTypes() {
        ArrayList<DocumentType> defaultTypes = new ArrayList<DocumentType>();
        defaultTypes.add(new DocumentType("Workspace", true, false, false, true, false, false, Arrays.asList("Folder", "Note", "Room"), "/default/templates/workspace", "glyphicons glyphicons-wallet", true));
        defaultTypes.add(new DocumentType("PortalSite", true, false, false, true, true, true, Arrays.asList("File", "PortalPage", "ContextualLink", "Note"), null, "glyphicons glyphicons-global", true));
        defaultTypes.add(new DocumentType("PortalPage", true, true, true, true, true, true, Arrays.asList("File", "PortalPage", "ContextualLink", "Note"), null, "glyphicons glyphicons-more-items"));
        defaultTypes.add(new DocumentType("Folder", true, true, true, false, false, true, Arrays.asList("File", "Folder", "Note"), null, "glyphicons glyphicons-folder-closed"));
        defaultTypes.add(new DocumentType("OrderedFolder", true, true, true, true, false, true, Arrays.asList("File", "Folder", "Note"), null, "glyphicons glyphicons-folder-closed"));
        DocumentType file = new DocumentType("File", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-file", false, true, true);
        file.setFile(true);
        defaultTypes.add(file);
        defaultTypes.add(new DocumentType("Note", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-note"));
        defaultTypes.add(new DocumentType("ContextualLink", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-link"));
        defaultTypes.add(new DocumentType("Room", true, false, true, true, false, false, Arrays.asList("Folder", "Note"), "/default/templates/room", "glyphicons glyphicons-cube-black", false, false));
        defaultTypes.add(new DocumentType("Staple", false, true, false, false, false, false, new ArrayList(0), null, "glyphicons glyphicons-nails"));
        defaultTypes.add(new DocumentType("UserProfile", false, false, false, false, false, false, new ArrayList(0), null, "glyphicons glyphicons-user"));
        return defaultTypes;
    }

    public String getCommentsHTMLContent(CMSServiceCtx cmsContext, Document document) throws CMSException {
        List comments = this.getNuxeoCommentsService().getDocumentComments(cmsContext, document);
        CommentsFormatter formatter = new CommentsFormatter(comments);
        Locale locale = cmsContext.getRequest().getLocale();
        return formatter.generateHTMLContent(locale);
    }

    public String getContentWebIdPath(CMSServiceCtx cmsCtx) {
        Document doc = (Document)cmsCtx.getDoc();
        String webId = doc.getString("ttc:webid");
        String permLinkPath = ((Document)cmsCtx.getDoc()).getPath();
        if (StringUtils.isNotEmpty((String)webId) && !ContextDocumentsHelper.isRemoteProxy((Document)doc)) {
            String explicitUrl = doc.getString("ttc:explicitUrl");
            String extension = doc.getString("ttc:extensionUrl");
            HashMap<String, String> properties = new HashMap<String, String>();
            if (explicitUrl != null) {
                properties.put("explicitUrl", explicitUrl);
            }
            if (extension != null) {
                properties.put("extensionUrl", extension);
            }
            permLinkPath = this.webIdService.webIdToCmsPath(webId);
        }
        return permLinkPath;
    }

    public Link getUserAvatar(String username) {
        String src = "";
        String avatarTime = (String)this.avatarMap.get(username);
        if (avatarTime == null) {
            avatarTime = this.refreshUserAvatar(username);
        }
        try {
            src = AVATAR_SERVLET.concat(URLEncoder.encode(username, "UTF-8")).concat("&t=").concat(avatarTime.toString());
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)e);
        }
        return new Link(src, false);
    }

    public Link getUserAvatar(CMSServiceCtx cmsCtx, String username) throws CMSException {
        return this.getUserAvatar(username);
    }

    public String refreshUserAvatar(String username) {
        String avatarTime = Long.toString(new Date().getTime());
        this.avatarMap.put(username, avatarTime);
        return avatarTime;
    }

    public String refreshUserAvatar(CMSServiceCtx cmsCtx, String username) {
        return this.refreshUserAvatar(username);
    }

    public boolean isPathInLiveState(CMSServiceCtx cmsCtx, Document doc) {
        if ("1".equals(cmsCtx.getDisplayLiveVersion())) {
            return true;
        }
        return doc.getPath().equals(cmsCtx.getForcedLivePath());
    }

    public BinaryDelegation validateBinaryDelegation(CMSServiceCtx cmsCtx, String path) {
        String id = cmsCtx.getServletRequest().getSession().getId();
        Map delegationMap = (Map)this.delegations.get(id);
        if (delegationMap != null) {
            return (BinaryDelegation)delegationMap.get(path);
        }
        return null;
    }

    public Link getBinaryResourceURL(CMSServiceCtx cmsCtx, BinaryDescription binary) throws CMSException {
        Document document = binary.getDocument() == null ? null : (Document)binary.getDocument();
        String src = "";
        String path = "";
        boolean liveState = false;
        BinaryDelegation delegation = new BinaryDelegation();
        try {
            boolean reload;
            Date date;
            String portalName = null;
            ServerInvocation invocation = cmsCtx.getServerInvocation();
            Boolean isAdmin = false;
            if (invocation != null) {
                portalName = (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
                isAdmin = (Boolean)invocation.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)"osivia.isAdmin");
            }
            if (document != null) {
                path = document.getPath();
                if (BinaryDescription.Type.FILE_OF_VERSION.equals((Object)binary.getType())) {
                    path = document.getId();
                }
                liveState = this.isPathInLiveState(cmsCtx, document);
                delegation.setGrantedAccess(true);
            } else {
                path = binary.getPath();
            }
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            delegation.setSubject(subject);
            delegation.setAdmin(isAdmin.booleanValue());
            if (StringUtils.endsWith((String)path, (String)".proxy") && !StringUtils.endsWith((String)path, (String)".remote.proxy")) {
                path = StringUtils.removeEnd((String)path, (String)".proxy");
            }
            delegation.setUserName(cmsCtx.getServletRequest().getRemoteUser());
            Map delegationMap = this.getUserDelegation(cmsCtx);
            delegationMap.put(path, delegation);
            String fileName = binary.getFileName();
            if (fileName == null) {
                if (document != null) {
                    PropertyMap fileMap = document.getProperties().getMap("file:content");
                    if (fileMap != null) {
                        fileName = fileMap.getString("name");
                    }
                } else if (binary.getIndex() != null && cmsCtx.getDoc() != null) {
                    PropertyMap fileMap;
                    int index = NumberUtils.toInt((String)binary.getIndex());
                    Document contextDocument = (Document)cmsCtx.getDoc();
                    PropertyList files = contextDocument.getProperties().getList("files:files");
                    if (files != null && files.size() > index && (fileMap = files.getMap(index)) != null) {
                        fileName = fileMap.getString("filename");
                    }
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(BINARY_SERVLET);
            if (StringUtils.isNotBlank((String)fileName)) {
                sb.append("/").append(URLEncoder.encode(fileName, "UTF-8"));
            }
            sb.append("?type=").append(binary.getType().name()).append("&path=").append(URLEncoder.encode(path, "UTF-8"));
            if (portalName != null) {
                sb.append("&portalName=").append(portalName);
            }
            if (binary.getIndex() != null) {
                sb.append("&index=").append(binary.getIndex());
            }
            if (liveState) {
                sb.append("&liveState=").append(liveState);
            }
            if (binary.getContent() != null) {
                sb.append("&content=").append(binary.getContent());
            }
            if (binary.getFieldName() != null) {
                sb.append("&fieldName=").append(binary.getFieldName());
            }
            if (binary.getFileName() != null) {
                sb.append("&fileName=").append(URLEncoder.encode(binary.getFileName(), "UTF-8"));
            }
            if (cmsCtx.getScope() != null) {
                sb.append("&scope=").append(cmsCtx.getScope());
            }
            if (cmsCtx.getForcePublicationInfosScope() != null) {
                sb.append("&fscope=").append(cmsCtx.getForcePublicationInfosScope());
            }
            long timestamp = System.currentTimeMillis();
            Long modified = document == null ? null : ((date = document.getDate("dc:modified")) == null ? null : Long.valueOf(date.getTime()));
            boolean refreshingPage = PageProperties.getProperties().isRefreshingPage();
            BinaryTimestamp binaryTimestamp = (BinaryTimestamp)this.binaryTimestamps.get(path);
            if (binaryTimestamp == null) {
                binaryTimestamp = new BinaryTimestamp();
                binaryTimestamp.setTimestamp(timestamp);
                binaryTimestamp.setModified(modified);
                binaryTimestamp.setReloadingRequired(true);
                this.binaryTimestamps.put(path, binaryTimestamp);
            }
            if ("pdf:content".equals(binary.getFieldName()) && refreshingPage) {
                reload = true;
            } else if (binaryTimestamp.isReloadingRequired()) {
                reload = true;
                if (timestamp - binaryTimestamp.getTimestamp() > TimeUnit.SECONDS.toMillis(10L)) {
                    binaryTimestamp.setReloadingRequired(false);
                }
            } else if (modified == null) {
                reload = false;
                if (refreshingPage && BinaryDescription.Type.PICTURE.equals((Object)binary.getType())) {
                    binaryTimestamp.setTimestamp(timestamp);
                }
            } else if (binaryTimestamp.getModified() == null) {
                binaryTimestamp.setTimestamp(timestamp);
                binaryTimestamp.setModified(modified);
                binaryTimestamp.setReloadingRequired(true);
                reload = true;
            } else if (Math.abs(binaryTimestamp.getModified() - modified) > TimeUnit.SECONDS.toMillis(1L)) {
                binaryTimestamp.setTimestamp(timestamp);
                binaryTimestamp.setModified(modified);
                binaryTimestamp.setReloadingRequired(true);
                reload = true;
            } else {
                reload = false;
            }
            if (reload) {
                sb.append("&t=");
                sb.append(timestamp);
                sb.append("&reload=true");
            } else {
                sb.append("&t=");
                sb.append(TimeUnit.MILLISECONDS.toSeconds(binaryTimestamp.getTimestamp()));
            }
            src = sb.toString();
        }
        catch (Exception e) {
            new CMSException((Throwable)e);
        }
        return new Link(src, false);
    }

    private Map<String, BinaryDelegation> getUserDelegation(CMSServiceCtx cmsCtx) {
        String id = cmsCtx.getServletRequest().getSession(true).getId();
        ConcurrentHashMap delegationMap = (ConcurrentHashMap)this.delegations.get(id);
        if (delegationMap == null) {
            delegationMap = new ConcurrentHashMap();
            this.delegations.put(id, delegationMap);
        }
        return delegationMap;
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        this.delegations.remove(sessionEvent.getSession().getId());
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public Object executeNuxeoCommand(CMSServiceCtx cmsContext, INuxeoCommand command) throws CMSException {
        try {
            return this.cmsService.executeNuxeoCommand(cmsContext, command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public Map<String, EcmCommand> getEcmCommands() {
        ConcurrentHashMap<String, EcmCommand> commands = new ConcurrentHashMap<String, EcmCommand>();
        commands.put(EcmCommonCommands.lock.name(), (EcmCommand)new LockCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.unlock.name(), (EcmCommand)new UnlockCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.subscribe.name(), (EcmCommand)new SubscribeCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.unsubscribe.name(), (EcmCommand)new UnsubscribeCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.synchronizeFolder.name(), (EcmCommand)new SynchronizeCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.unsynchronizeFolder.name(), (EcmCommand)new UnsynchronizeCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.eraseModifications.name(), (EcmCommand)new EraseModificationsCommand(this.notificationsService, this.internationalizationService));
        commands.put(EcmCommonCommands.deleteDocument.name(), (EcmCommand)new DeleteDocumentCommand(this.notificationsService, this.internationalizationService));
        return commands;
    }

    public TaskbarItems getDefaultTaskbarItems() throws CMSException {
        TaskbarFactory factory = this.taskbarService.getFactory();
        TaskbarItems taskbarItems = factory.createTaskbarItems();
        TaskbarItem home = factory.createTransversalTaskbarItem("HOME", "HOME_TASK", "glyphicons glyphicons-home", null);
        taskbarItems.add(home);
        PanelPlayer searchPlayer = new PanelPlayer();
        searchPlayer.setInstance("toutatice-portail-cms-nuxeo-searchPortletInstance");
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("osivia.cms.uri", "${basePath}");
        searchPlayer.setProperties(properties);
        TaskbarItem search = factory.createTransversalTaskbarItem("SEARCH", "SEARCH_TASK", "glyphicons glyphicons-search", searchPlayer);
        taskbarItems.add(search);
        TaskbarItem documents = factory.createCmsTaskbarItem("DOCUMENTS", "DOCUMENTS_TASK", "glyphicons glyphicons-folder-closed", "Folder");
        documents.setToDefault(1);
        taskbarItems.add(documents);
        return taskbarItems;
    }

    protected PanelPlayer getFileBrowserPanelPlayer() {
        PanelPlayer player = new PanelPlayer();
        player.setInstance("toutatice-portail-cms-nuxeo-publishMenuPortletInstance");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.bootstrapPanelStyle", String.valueOf(true));
        properties.put("osivia.cms.template", "fancytree-lazy");
        properties.put("osivia.cms.startLevel", String.valueOf(2));
        properties.put("osivia.cms.forceNavigation", String.valueOf(true));
        player.setProperties(properties);
        return player;
    }

    public String getJSPName(String name, PortletContext portletContext, PortletRequest request) throws CMSException {
        try {
            CustomizedJsp customizedPage = this.pluginManager.customizeJSP(name, portletContext, request);
            String customizedName = customizedPage != null ? customizedPage.getName() : null;
            return customizedName;
        }
        catch (IOException e) {
            throw new CMSException((Throwable)e);
        }
    }

    public String getTarget(DocumentDTO document) {
        if (System.getProperty(TABS_PROPERTY) != null && "true".equals(System.getProperty(TABS_PROPERTY))) {
            Object spaceUuid = document.getProperties().get("ttc:spaceUuid");
            if (spaceUuid != null) {
                return spaceUuid.toString();
            }
            return null;
        }
        return null;
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public CMSService getCmsService() {
        return this.cmsService;
    }

    public Map<String, Map<String, BinaryDelegation>> getDelegations() {
        return this.delegations;
    }

    public Map<String, INuxeoPlayerModule> getPlayers() {
        return this.players;
    }

    public Map<String, PanelPlayer> getNavigationPanelPlayers() {
        return this.navigationPanelPlayers;
    }

    public Map<String, String> getAvatarMap() {
        return this.avatarMap;
    }

    public CustomizationPluginMgr getPluginManager() {
        return this.pluginManager;
    }

    public NuxeoConnectionProperties getNuxeoConnection() {
        return this.nuxeoConnection;
    }

    public UserPagesLoader getUserPagesLoader() {
        return this.userPagesLoader;
    }

    public MenuBarFormater getMenubarFormater() {
        return this.menubarFormater;
    }

    public BrowserAdapter getBrowserAdapter() {
        return this.browserAdapter;
    }

    public NavigationItemAdapter getNavigationItemAdapter() {
        return this.navigationItemAdapter;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public XMLReader getParser() {
        return this.parser;
    }

    public IPortalUrlFactory getPortalUrlFactory() {
        return this.portalUrlFactory;
    }

    public IWebIdService getWebIdService() {
        return this.webIdService;
    }

    public IWebUrlService getWebUrlService() {
        return this.webUrlService;
    }

    public ITaskbarService getTaskbarService() {
        return this.taskbarService;
    }

    public ICustomizationService getCustomizationService() {
        return this.customizationService;
    }

    public INuxeoCommentsService getNuxeoCommentsService() {
        return this.nuxeoCommentsService;
    }

    public IInternationalizationService getInternationalizationService() {
        return this.internationalizationService;
    }

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }

    public INotificationsService getNotificationsService() {
        return this.notificationsService;
    }
}

