/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.portlets.list.ListCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.RequestPublishStatus;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.server.ServerInvocation;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class BrowserAdapter {
    protected static final String CURRENT_USER_WORKSPACES_PRINCIPAL_ATTRIBUTE = "osivia.browser.currentUserWorkspaces";
    private static final String USER_WORKSPACES_DEFAULT_PATH = "/default-domain/UserWorkspaces";
    private static final String USER_WORKSPACES_DEFAULT_TYPE = "Workspace";
    private static BrowserAdapter instance;
    private final CMSService cmsService;

    private BrowserAdapter(CMSService cmsService) {
        this.cmsService = cmsService;
    }

    public static BrowserAdapter getInstance(CMSService cmsService) {
        if (instance == null) {
            instance = new BrowserAdapter(cmsService);
        }
        return instance;
    }

    public List<CMSItem> getWorkspaces(CMSServiceCtx cmsContext, boolean administrator) throws CMSException {
        ArrayList<Object> workspaces;
        if (administrator && !this.areWorkspacesDisplayedForAdministrator()) {
            workspaces = new ArrayList<CMSItem>(0);
        } else {
            NuxeoController nuxeoController = new NuxeoController(cmsContext.getRequest(), (PortletResponse)cmsContext.getResponse(), cmsContext.getPortletCtx());
            String query = this.getWorkspacesQuery();
            String schemas = this.getWorkspacesSchemas();
            String filter = "none";
            String liveStatus = RequestPublishStatus.live.getStatus();
            ListCommand nuxeoCommand = new ListCommand(query, liveStatus, 0, -1, schemas, filter, true);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
            workspaces = new ArrayList(documents.size());
            for (Document document : documents.list()) {
                CMSItem workspace = this.cmsService.createItem(cmsContext, document.getPath(), document.getTitle(), document);
                workspaces.add(workspace);
            }
        }
        return workspaces;
    }

    public List<CMSItem> getUserWorkspaces(CMSServiceCtx cmsContext) throws CMSException {
        List workspaces;
        ServerInvocation invocation = cmsContext.getServerInvocation();
        Object attribute = invocation.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)CURRENT_USER_WORKSPACES_PRINCIPAL_ATTRIBUTE);
        if (attribute != null && attribute instanceof List) {
            List list = (List)attribute;
            workspaces = new ArrayList(list.size());
            for (Object object : list) {
                if (!(object instanceof CMSItem)) continue;
                CMSItem workspace = (CMSItem)object;
                workspaces.add((CMSItem)workspace);
            }
        } else {
            String userName = null;
            if (invocation.getServerContext().getClientRequest().getUserPrincipal() != null) {
                userName = invocation.getServerContext().getClientRequest().getUserPrincipal().getName();
            }
            workspaces = userName == null ? new ArrayList(0) : this.getUserWorkspaces(cmsContext, userName);
            invocation.setAttribute(Scope.PRINCIPAL_SCOPE, (Object)CURRENT_USER_WORKSPACES_PRINCIPAL_ATTRIBUTE, workspaces);
        }
        return workspaces;
    }

    public List<CMSItem> getAllUserWorkspaces(CMSServiceCtx cmsContext) throws CMSException {
        return this.getUserWorkspaces(cmsContext, null);
    }

    private List<CMSItem> getUserWorkspaces(CMSServiceCtx cmsContext, String userName) throws CMSException {
        ArrayList<CMSItem> workspaces;
        String query = this.getUserWorkspacesQuery(userName);
        String schemas = this.getWorkspacesSchemas();
        String filter = "none";
        try {
            String liveStatus = RequestPublishStatus.live.getStatus();
            ListCommand nuxeoCommand = new ListCommand(query, liveStatus, 0, -1, schemas, filter, true);
            Documents documents = (Documents)this.cmsService.executeNuxeoCommand(cmsContext, (INuxeoCommand)nuxeoCommand);
            workspaces = new ArrayList<CMSItem>(documents.size());
            for (Document document : documents.list()) {
                CMSItem workspace = this.cmsService.createItem(cmsContext, document.getPath(), document.getTitle(), document);
                workspaces.add(workspace);
            }
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
        return workspaces;
    }

    protected boolean areWorkspacesDisplayedForAdministrator() {
        return true;
    }

    public String getUserWorkspacesPath() {
        return USER_WORKSPACES_DEFAULT_PATH;
    }

    public String getUserWorkspacesType() {
        return USER_WORKSPACES_DEFAULT_TYPE;
    }

    public String getWorkspacesQuery() {
        StringBuilder query = new StringBuilder();
        query.append("ecm:primaryType = 'Workspace' AND NOT ecm:path STARTSWITH '");
        query.append(this.getUserWorkspacesPath());
        query.append("/'");
        return query.toString();
    }

    public String getUserWorkspacesQuery(String userName) {
        StringBuilder query = new StringBuilder();
        query.append("ecm:primaryType = '");
        query.append(this.getUserWorkspacesType());
        query.append("' AND ecm:path STARTSWITH '");
        query.append(this.getUserWorkspacesPath());
        query.append("/'");
        if (StringUtils.isNotEmpty((String)userName)) {
            query.append(" AND dc:creator = '");
            query.append(userName);
            query.append("'");
        }
        return query.toString();
    }

    public String getWorkspacesSchemas() {
        return "dublincore";
    }
}

