/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.list.draft;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.list.ListCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.list.ViewListPortlet;
import java.io.IOException;
import java.util.ArrayList;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class ViewDraftsListPortlet
extends ViewListPortlet {
    protected static final String DRAFTS_LIST_SCHEMAS = "dublincore, common, toutatice, file".concat(", ").concat("ottcDraft");
    protected static final String DRAFTS_LIST_TEMPLATE = "drafts";
    public static final String DRAFTS_QUERY_WHERE_CLAUSE = " ecm:mixinType = 'OttcDraft' and dc:lastContributor = '%s'".concat(" and ottcDft:checkoutParentId = '%s'");

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        try {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
            IBundleFactory bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
            Bundle bundle = bundleFactory.getBundle(request.getLocale());
            String folderPath = window.getProperty("osivia.drafts.folderWebId");
            String query = String.format(DRAFTS_QUERY_WHERE_CLAUSE, request.getRemoteUser(), folderPath);
            int pageSize = Integer.valueOf("-1");
            ListCommand command = new ListCommand(query, String.valueOf(1), 0, pageSize, DRAFTS_LIST_SCHEMAS, null, true);
            Documents draftDocs = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            ArrayList<DocumentDTO> draftDocsDTO = new ArrayList<DocumentDTO>(draftDocs.size());
            for (Document document : draftDocs) {
                DocumentDTO documentDTO = DocumentDAO.getInstance().toDTO(document);
                draftDocsDTO.add(documentDTO);
            }
            request.setAttribute("documents", draftDocsDTO);
            response.setTitle(bundle.getString("DRAFTS_PORTLET_TITLE"));
            window.setProperty("osivia.bootstrapPanelStyle", "true");
            request.setAttribute("style", (Object)DRAFTS_LIST_TEMPLATE);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/list/view.jsp");
        dispatcher.include(request, response);
    }
}

