/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.forms;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoServiceFactory;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.FormsServiceImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.GetDocumentCommand;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.naming.Name;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Group;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.tasks.ITasksService;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

/*
 * Exception performing whole class analysis ignored.
 */
public class TransformationFunctions {
    private static Log log = LogFactory.getLog(TransformationFunctions.class);
    private static IPortalUrlFactory portalUrlFactory;
    private static ICMSServiceLocator cmsServiceLocator;
    private static ITasksService tasksService;
    private static INuxeoCustomizer cmsCustomizer;
    private static DocumentDAO documentDao;

    private TransformationFunctions() {
    }

    private static IPortalUrlFactory getPortalUrlFactory() {
        if (portalUrlFactory == null) {
            portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
        }
        return portalUrlFactory;
    }

    private static ICMSService getCmsService() {
        if (cmsServiceLocator == null) {
            cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
        }
        return cmsServiceLocator.getCMSService();
    }

    private static ITasksService getTasksService() {
        if (tasksService == null) {
            tasksService = (ITasksService)Locator.findMBean(ITasksService.class, (String)"osivia:service=TasksService");
        }
        return tasksService;
    }

    private static DocumentDAO getDocumentDAO() {
        if (documentDao == null) {
            documentDao = DocumentDAO.getInstance();
        }
        return documentDao;
    }

    private static INuxeoCustomizer getNuxeoCustomizer() {
        if (cmsCustomizer == null) {
            cmsCustomizer = NuxeoServiceFactory.getNuxeoService().getCMSCustomizer();
        }
        return cmsCustomizer;
    }

    public static String getUserDisplayName(String user) {
        PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        Person person = personService.getPerson(user);
        String displayName = person == null ? user : StringUtils.defaultIfBlank((String)person.getDisplayName(), (String)user);
        return displayName;
    }

    public static Method getUserDisplayNameMethod() throws NoSuchMethodException, SecurityException {
        return TransformationFunctions.class.getMethod("getUserDisplayName", String.class);
    }

    public static String getUserLink(String user) {
        Element element;
        IPortalUrlFactory portalUrlFactory = TransformationFunctions.getPortalUrlFactory();
        PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        PortalControllerContext portalControllerContext = FormsServiceImpl.getPortalControllerContext();
        Person person = personService.getPerson(user);
        if (person == null) {
            element = DOM4JUtils.generateElement((String)"span", null, (String)user);
        } else {
            String url;
            String displayName = StringUtils.defaultIfEmpty((String)person.getDisplayName(), (String)user);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.title", displayName);
            properties.put("osivia.hideTitle", "1");
            properties.put("osivia.ajaxLink", "1");
            properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
            properties.put("uidFichePersonne", user);
            HashMap parameters = new HashMap(0);
            try {
                url = portalUrlFactory.getStartPortletInNewPage(portalControllerContext, "myprofile", displayName, "directory-person-card-instance", properties, parameters);
            }
            catch (PortalException e) {
                url = "#";
            }
            element = DOM4JUtils.generateLinkElement((String)url, null, null, (String)"no-ajax-link", (String)displayName);
        }
        return DOM4JUtils.writeCompact((Element)element);
    }

    public static Method getUserLinkMethod() throws NoSuchMethodException, SecurityException {
        return TransformationFunctions.class.getMethod("getUserLink", String.class);
    }

    public static String getUserEmail(String user) {
        PersonService personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        Person person = personService.getPerson(user);
        String email = person == null ? null : person.getMail();
        return email;
    }

    public static Method getUserEmailMethod() throws NoSuchMethodException, SecurityException {
        return TransformationFunctions.class.getMethod("getUserEmail", String.class);
    }

    public static String getGroupEmails(String id) {
        String emails;
        GroupService groupService = (GroupService)DirServiceFactory.getService(GroupService.class);
        Group group = groupService.get(id);
        if (group == null) {
            emails = null;
        } else {
            Name dn = group.getDn();
            List members = groupService.getMembers(dn);
            if (CollectionUtils.isEmpty((Collection)members)) {
                emails = null;
            } else {
                HashSet<String> list = new HashSet<String>(members.size());
                for (Person member : members) {
                    String email = member.getMail();
                    if (!StringUtils.isNotBlank((String)email)) continue;
                    list.add(email);
                }
                emails = StringUtils.join(list, (String)",");
            }
        }
        return emails;
    }

    public static Method getGroupEmailsMethod() throws NoSuchMethodException, SecurityException {
        return TransformationFunctions.class.getMethod("getGroupEmails", String.class);
    }

    public static String getDocumentTitle(String path) {
        PortalControllerContext portalControllerContext = FormsServiceImpl.getPortalControllerContext();
        Document document = TransformationFunctions.getDocument((PortalControllerContext)portalControllerContext, (String)path);
        String title = document == null ? null : document.getTitle();
        return title;
    }

    public static Method getDocumentTitleMethod() throws NoSuchMethodException, SecurityException {
        return TransformationFunctions.class.getMethod("getDocumentTitle", String.class);
    }

    public static String getDocumentLink(String path) {
        String result;
        IPortalUrlFactory portalUrlFactory = TransformationFunctions.getPortalUrlFactory();
        PortalControllerContext portalControllerContext = FormsServiceImpl.getPortalControllerContext();
        Document document = TransformationFunctions.getDocument((PortalControllerContext)portalControllerContext, (String)path);
        if (document == null) {
            result = null;
        } else {
            String url = portalUrlFactory.getCMSUrl(portalControllerContext, null, document.getPath(), null, null, null, null, null, null, null);
            DocumentDTO dto = TransformationFunctions.getDocumentDAO().toDTO(document);
            String target = TransformationFunctions.getNuxeoCustomizer().getTarget(dto);
            Element link = DOM4JUtils.generateLinkElement((String)url, (String)target, null, (String)"no-ajax-link", (String)document.getTitle());
            result = DOM4JUtils.writeCompact((Element)link);
        }
        return result;
    }

    public static Method getDocumentLinkMethod() throws NoSuchMethodException, SecurityException {
        return TransformationFunctions.class.getMethod("getDocumentLink", String.class);
    }

    private static Document getDocument(PortalControllerContext portalControllerContext, String path) {
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        cmsContext.setForcePublicationInfosScope("superuser_context");
        GetDocumentCommand command = new GetDocumentCommand(path);
        Document document = null;
        try {
            Documents documents = (Documents)TransformationFunctions.getNuxeoCustomizer().executeNuxeoCommand(cmsContext, (INuxeoCommand)command);
            if (documents.size() == 1) {
                document = documents.get(0);
            }
        }
        catch (CMSException e) {
            log.error((Object)e);
        }
        return document;
    }

    public static String getCommandLink(String title, String actionId, String redirectionPath) {
        String result;
        IPortalUrlFactory portalUrlFactory = TransformationFunctions.getPortalUrlFactory();
        ITasksService tasksService = TransformationFunctions.getTasksService();
        PortalControllerContext portalControllerContext = FormsServiceImpl.getPortalControllerContext();
        boolean disabledLinks = FormsServiceImpl.areLinksDisabled();
        if (disabledLinks) {
            result = "";
        } else {
            String url;
            String redirectionUrl;
            UUID uuid = FormsServiceImpl.getUuid();
            if (StringUtils.isEmpty((String)redirectionPath)) {
                redirectionUrl = null;
            } else {
                try {
                    String host = System.getProperty("osivia.tasks.host");
                    redirectionUrl = StringUtils.isEmpty((String)host) ? portalUrlFactory.getPermaLink(portalControllerContext, null, null, redirectionPath, "cms") : host + "/portal/auth/cms/" + redirectionPath;
                }
                catch (PortalException e) {
                    redirectionUrl = null;
                }
            }
            try {
                url = tasksService.getCommandUrl(portalControllerContext, uuid, actionId, redirectionUrl);
            }
            catch (PortalException e) {
                url = "#";
            }
            Element link = DOM4JUtils.generateLinkElement((String)url, null, null, null, (String)title);
            result = DOM4JUtils.write((Element)link);
        }
        return result;
    }

    public static Method getCommandLinkMethod() throws NoSuchMethodException, SecurityException {
        return TransformationFunctions.class.getMethod("getCommandLink", String.class, String.class, String.class);
    }
}

