/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentAttachmentDTO;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.IOException;
import java.util.ArrayList;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class AttachmentsFragmentModule
extends FragmentModule {
    public static final String ID = "attachments";
    private static final String PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    private static final String ATTACHEMENTS_DOCUMENT_PROPERTY = "files:files";
    private static final String JSP_NAME = "attachments";
    private final DocumentDAO documentDao = DocumentDAO.getInstance();

    public AttachmentsFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }

    public void doView(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(PATH_WINDOW_PROPERTY);
        if (StringUtils.isBlank((String)path)) {
            request.setAttribute("messageKey", (Object)"MESSAGE_PATH_UNDEFINED");
        } else {
            path = nuxeoController.getComputedPath(path);
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
            Document document = documentContext.getDoc();
            nuxeoController.setCurrentDoc(document);
            PropertyMap properties = document.getProperties();
            PropertyList list = properties.getList(ATTACHEMENTS_DOCUMENT_PROPERTY);
            if (list == null || list.isEmpty()) {
                request.setAttribute("osivia.emptyResponse", (Object)"1");
            } else {
                ArrayList<DocumentAttachmentDTO> attachments = new ArrayList<DocumentAttachmentDTO>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    PropertyMap map = list.getMap(i);
                    DocumentAttachmentDTO attachment = new DocumentAttachmentDTO();
                    PropertyMap file = map.getMap("file");
                    String name = file.getString("name");
                    if (StringUtils.isEmpty((String)name)) {
                        name = map.getString("filename");
                    }
                    attachment.setName(name);
                    String mimeType = file.getString("mime-type");
                    String icon = this.documentDao.getIcon(mimeType);
                    attachment.setIcon(icon);
                    Long size = file.getLong("length");
                    attachment.setSize(size);
                    String url = nuxeoController.createAttachedFileLink(path, String.valueOf(i));
                    attachment.setUrl(url);
                    attachments.add(attachment);
                }
                request.setAttribute("attachments", attachments);
            }
        }
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(PATH_WINDOW_PROPERTY);
        request.setAttribute("path", (Object)path);
    }

    public void processAction(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        String action;
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if ("admin".equals(request.getPortletMode().toString()) && "save".equals(action = request.getParameter("javax.portlet.action"))) {
            String path = StringUtils.trimToNull((String)request.getParameter("path"));
            window.setProperty(PATH_WINDOW_PROPERTY, path);
        }
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }

    public String getViewJSPName() {
        return "attachments";
    }

    public String getAdminJSPName() {
        return "attachments";
    }
}

