/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class DocumentPictureFragmentModule
extends FragmentModule {
    public static final String ID = "document_picture";
    public static final String NUXEO_PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    public static final String PROPERTY_NAME_WINDOW_PROPERTY = "osivia.propertyName";
    public static final String SCOPE_WINDOW_PROPERTY = "osivia.cms.forcePublicationScope";
    public static final String TARGET_PATH_WINDOW_PROPERTY = "osivia.targetPath";
    private static final String ADMIN_JSP_NAME = "document-picture";
    private static final String VIEW_JSP_NAME = "picture";

    public DocumentPictureFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }

    public void doView(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        RenderResponse response = (RenderResponse)portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController(request, (PortletResponse)response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        String propertyName = window.getProperty(PROPERTY_NAME_WINDOW_PROPERTY);
        String targetPath = window.getProperty(TARGET_PATH_WINDOW_PROPERTY);
        if (StringUtils.isNotEmpty((String)nuxeoPath)) {
            if (StringUtils.startsWith((String)(nuxeoPath = nuxeoController.getComputedPath(nuxeoPath)), (String)"/nuxeo/")) {
                this.setAsCurrentDocNGet(nuxeoController, nuxeoController.getNavigationPath());
                String portalPath = nuxeoController.transformNuxeoLink(nuxeoPath);
                request.setAttribute("imageSource", (Object)portalPath);
            } else {
                Document document = this.setAsCurrentDocNGet(nuxeoController, nuxeoPath);
                if (StringUtils.isNotBlank((String)document.getTitle())) {
                    response.setTitle(document.getTitle());
                }
                if (StringUtils.isNotEmpty((String)propertyName)) {
                    String pathFile;
                    boolean emptyContent = true;
                    PropertyMap map = document.getProperties().getMap(propertyName);
                    if (map != null && (pathFile = map.getString("data")) != null) {
                        String imageSource = nuxeoController.createFileLink(document, propertyName);
                        request.setAttribute("imageSource", (Object)imageSource);
                        emptyContent = false;
                    }
                    if (emptyContent) {
                        request.setAttribute("osivia.emptyResponse", (Object)"1");
                    }
                } else {
                    request.setAttribute("messageKey", (Object)"FRAGMENT_MESSAGE_PROPERTY_UNDEFINED");
                }
            }
            if (StringUtils.isNotEmpty((String)targetPath)) {
                Link link = StringUtils.startsWith((String)(targetPath = nuxeoController.getComputedPath(targetPath)), (String)"/") && !StringUtils.startsWith((String)targetPath, (String)"/nuxeo/") ? nuxeoController.getCMSLinkByPath(targetPath, null) : nuxeoController.getLinkFromNuxeoURL(targetPath);
                request.setAttribute("link", (Object)link);
            }
        } else {
            request.setAttribute("messageKey", (Object)"MESSAGE_PATH_UNDEFINED");
        }
    }

    protected Document setAsCurrentDocNGet(NuxeoController nuxeoController, String path) {
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        Document document = documentContext.getDoc();
        nuxeoController.setCurrentDoc(document);
        return document;
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController(request, response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        request.setAttribute("nuxeoPath", (Object)nuxeoPath);
        String propertyName = window.getProperty(PROPERTY_NAME_WINDOW_PROPERTY);
        request.setAttribute("propertyName", (Object)propertyName);
        String scope = window.getProperty(SCOPE_WINDOW_PROPERTY);
        String scopes = nuxeoController.formatScopeList(scope);
        request.setAttribute("scopes", (Object)scopes);
        String targetPath = window.getProperty(TARGET_PATH_WINDOW_PROPERTY);
        request.setAttribute("targetPath", (Object)targetPath);
    }

    public void processAction(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            window.setProperty(NUXEO_PATH_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("nuxeoPath")));
            window.setProperty(PROPERTY_NAME_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("propertyName")));
            window.setProperty(SCOPE_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("scope")));
            window.setProperty(TARGET_PATH_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("targetPath")));
        }
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }

    public String getViewJSPName() {
        return VIEW_JSP_NAME;
    }

    public String getAdminJSPName() {
        return ADMIN_JSP_NAME;
    }
}

