/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.list;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.selectors.DateSelectorPortlet;
import java.text.Normalizer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

public class NXQLFormater {
    private static final String FRONTEND_DATE_PATTERN = "dd/MM/yyyy";
    private static final String BACKEND_DATE_PATTERN = "yyyy-MM-dd";

    public String formatTextSearch(String fieldName, List<String> searchValues) {
        StringBuilder request = new StringBuilder();
        request.append("(");
        boolean firstItem = true;
        for (String searchWord : searchValues) {
            String[] words;
            searchWord = Normalizer.normalize(searchWord, Normalizer.Form.NFD);
            searchWord = searchWord.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
            searchWord = searchWord.replaceAll("[^A-Za-z0-9 ]", " ");
            for (String word : words = searchWord.split(" ")) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    request.append(" AND ");
                }
                request.append(fieldName);
                request.append(" ILIKE '%");
                request.append(word);
                request.append("%'");
            }
        }
        request.append(")");
        return request.toString();
    }

    public String formatVocabularySearch(String fieldName, List<String> selectedVocabsEntries) {
        StringBuilder clause = new StringBuilder();
        clause.append("(");
        boolean firstItem = true;
        for (String selectedVocabsEntry : selectedVocabsEntries) {
            if (selectedVocabsEntry.contains("othersVocabEntries")) continue;
            if (firstItem) {
                firstItem = false;
            } else {
                clause.append(" OR ");
            }
            clause.append(fieldName);
            clause.append(" STARTSWITH '");
            clause.append(StringUtils.replace((String)selectedVocabsEntry, (String)"'", (String)"\\'"));
            clause.append("'");
        }
        clause.append(")");
        return clause.toString();
    }

    public String formatOthersVocabularyEntriesSearch(PortletRequest portletRequest, List<?> vocabsNames, String fieldName, List<String> selectedVocabsEntries) throws Exception {
        String resultClause;
        StringBuilder clause = new StringBuilder();
        int nbOtherEntries = 0;
        for (String selectedEntry : selectedVocabsEntries) {
            if (!selectedEntry.contains("othersVocabEntries")) continue;
            if (nbOtherEntries > 0) {
                clause.append(" OR ");
            }
            ++nbOtherEntries;
            StringBuilder clauseBeforeOther = new StringBuilder();
            StringBuilder otherClause = new StringBuilder();
            String selectedValuesBeforeOthers = StringUtils.substringBeforeLast((String)selectedEntry, (String)"/");
            selectedValuesBeforeOthers = "othersVocabEntries".equalsIgnoreCase(selectedValuesBeforeOthers) ? "" : selectedValuesBeforeOthers + "/";
            if (StringUtils.isNotEmpty((String)selectedValuesBeforeOthers)) {
                clauseBeforeOther.append(" ( ");
                clauseBeforeOther.append(fieldName);
                clauseBeforeOther.append(" STARTSWITH '");
                clauseBeforeOther.append(StringUtils.replace((String)selectedValuesBeforeOthers, (String)"'", (String)"\\'"));
                clauseBeforeOther.append("' ");
                clauseBeforeOther.append(") AND ");
            }
            int selectedLevel = selectedEntry.split("/").length;
            ArrayList<String> vocabNames = new ArrayList<String>();
            for (Object vocab : vocabsNames) {
                vocabNames.add(vocab.toString());
            }
            NuxeoController nuxeoController = (NuxeoController)portletRequest.getAttribute("nuxeoController");
            VocabularyEntry vocabEntry = VocabularyHelper.getVocabularyEntry((NuxeoController)nuxeoController, vocabNames);
            VocabularyEntry lastVocab = vocabEntry;
            String[] entries = selectedEntry.split("/");
            for (int levelIndex = 0; levelIndex < selectedLevel; ++levelIndex) {
                String entry = entries[levelIndex];
                if ("othersVocabEntries".equals(entry)) continue;
                lastVocab = lastVocab.getChild(entry);
            }
            Collection vocabsEntries = lastVocab.getChildren().values();
            if (vocabsEntries != null && vocabsEntries.size() > 0) {
                otherClause.append(" ( NOT (");
                boolean firstItem = true;
                for (VocabularyEntry displayedEntry : vocabsEntries) {
                    String entry = displayedEntry.getId();
                    if (!firstItem) {
                        otherClause.append(" OR ");
                    }
                    otherClause.append(fieldName);
                    otherClause.append(" STARTSWITH '");
                    otherClause.append(StringUtils.replace((String)selectedValuesBeforeOthers, (String)"'", (String)"\\'"));
                    otherClause.append(StringUtils.replace((String)entry, (String)"'", (String)"\\'"));
                    otherClause.append("' ");
                    firstItem = false;
                }
                otherClause.append(" ) ) ");
            }
            clause.append(clauseBeforeOther.toString());
            clause.append(otherClause.toString());
        }
        StringBuilder otherClause = new StringBuilder();
        if (nbOtherEntries > 0) {
            otherClause.append("(");
            otherClause.append(clause.toString());
            otherClause.append(")");
        }
        if ((resultClause = this.formatVocabularySearch(fieldName, selectedVocabsEntries)).equals("()")) {
            resultClause = "";
        }
        if (nbOtherEntries > 0) {
            resultClause = resultClause.length() > 0 ? "(" + resultClause + " OR " + otherClause.toString() + ")" : otherClause.toString();
        }
        return resultClause;
    }

    public String formatDateSearch(String fieldName, List<String> searchValue) {
        StringBuilder request = new StringBuilder();
        if (searchValue != null && searchValue.size() > 0) {
            request.append("(");
            int index = 0;
            for (String datesInterval : searchValue) {
                String[] interval = datesInterval.split(DateSelectorPortlet.DATES_SEPARATOR);
                try {
                    String[] frontPattern = new String[]{FRONTEND_DATE_PATTERN};
                    Date beginDate = DateUtils.parseDate((String)interval[0], (String[])frontPattern);
                    Date endDate = DateUtils.parseDate((String)interval[1], (String[])frontPattern);
                    endDate = DateUtils.addDays((Date)endDate, (int)1);
                    String from = DateFormatUtils.format((Date)beginDate, (String)BACKEND_DATE_PATTERN);
                    String to = DateFormatUtils.format((Date)endDate, (String)BACKEND_DATE_PATTERN);
                    if (index > 0) {
                        request.append(" OR ");
                    }
                    request.append("(");
                    request.append(fieldName);
                    request.append(" BETWEEN DATE '");
                    request.append(StringUtils.replace((String)from, (String)"'", (String)"\\'"));
                    request.append("' AND DATE '");
                    request.append(StringUtils.replace((String)to, (String)"'", (String)"\\'"));
                    request.append("')");
                }
                catch (ParseException e) {
                    continue;
                }
                ++index;
            }
            request.append(")");
        }
        return request.toString();
    }

    public String formatAdvancedSearch(List<String> searchValues) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> itSearchValues = searchValues.iterator();
        while (itSearchValues.hasNext()) {
            builder.append(this.formatAdvancedSearch(itSearchValues.next()));
            if (!itSearchValues.hasNext()) continue;
            builder.append(" AND ");
        }
        return builder.toString();
    }

    public String formatAdvancedSearch(String keyWords) {
        StringBuilder builder = new StringBuilder();
        String[] keyWds = StringUtils.split((String)keyWords);
        Iterator<String> itKeyWords = Arrays.asList(keyWds).iterator();
        while (itKeyWords.hasNext()) {
            String keyWord = StringUtils.replace((String)itKeyWords.next(), (String)"'", (String)"\\'");
            builder.append("(ecm:fulltext = '");
            builder.append(keyWord);
            builder.append("' OR dc:title ILIKE '");
            builder.append(keyWord);
            builder.append("%')");
            if (!itKeyWords.hasNext()) continue;
            builder.append(" AND ");
        }
        return builder.toString();
    }
}

