/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.statistics;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class GetSpaceStatisticsCommand
implements INuxeoCommand {
    private final Set<String> paths;

    public GetSpaceStatisticsCommand(Set<String> paths) {
        this.paths = paths;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:mixinType = 'Statistics' ");
        clause.append("AND ecm:path IN (");
        boolean first = true;
        for (String path : this.paths) {
            if (first) {
                first = false;
            } else {
                clause.append(", ");
            }
            clause.append("'");
            clause.append(path);
            clause.append("'");
        }
        clause.append(")");
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"statistics");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("|");
        builder.append(StringUtils.join((Collection)this.paths, (String)","));
        return builder.toString();
    }
}

