/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.list;

import bsh.EvalError;
import bsh.Interpreter;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.ResourceUtil;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPrivilegedModule;
import fr.toutatice.portail.cms.nuxeo.api.portlet.ViewList;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.list.DocumentPathComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.list.DocumentWebidComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.list.ListCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.list.ListConfiguration;
import fr.toutatice.portail.cms.nuxeo.portlets.list.NXQLFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.list.RssGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.sequencing.IPortletSequencingService;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.context.ControllerContextAdapter;

public class ViewListPortlet
extends ViewList {
    private static final int DEFAULT_REQUEST_PAGE_SIZE = 100;
    private static final int DEFAULT_RSS_RESULTS_LIMIT = 10;
    private static final String PATH_ADMIN = "/WEB-INF/jsp/list/admin.jsp";
    protected static final String PATH_VIEW = "/WEB-INF/jsp/list/view.jsp";
    private IBundleFactory bundleFactory;
    private DocumentDAO documentDAO;
    private IPortletSequencingService portletSequencingService;
    private final ITaskbarService taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
    private INuxeoService nuxeoService;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(((Object)((Object)this)).getClass().getClassLoader());
        this.documentDAO = DocumentDAO.getInstance();
        this.nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
        this.portletSequencingService = (IPortletSequencingService)Locator.findMBean(IPortletSequencingService.class, (String)"osivia:service=PortletSequencingService");
    }

    public ListTemplate getCurrentTemplate(Locale locale, ListConfiguration configuration) {
        String currentTemplateName = configuration.getTemplate();
        if (currentTemplateName == null) {
            currentTemplateName = "normal";
        }
        INuxeoCustomizer customizer = this.nuxeoService.getCMSCustomizer();
        ListTemplate currentTemplate = null;
        ListTemplate defaultTemplate = null;
        List templates = customizer.getListTemplates(locale);
        for (ListTemplate template : templates) {
            if (currentTemplateName.equals(template.getKey())) {
                currentTemplate = template;
                break;
            }
            if (!"normal".equals(template.getKey())) continue;
            defaultTemplate = template;
        }
        if (currentTemplate == null) {
            currentTemplate = defaultTemplate;
        }
        return currentTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        block17: {
            try {
                NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                ListConfiguration configuration = this.getConfiguration(window);
                ListTemplate template = this.getCurrentTemplate(request.getLocale(), configuration);
                boolean requestExecution = false;
                PaginableDocuments documents = null;
                int resultsLimit = 100;
                if ("rss".equals(request.getParameter("type"))) {
                    resultsLimit = 10;
                    requestExecution = true;
                }
                if ("true".equals(request.getParameter("injectdocs"))) {
                    requestExecution = true;
                    String limit = request.getParameter("limit");
                    if (limit != null) {
                        resultsLimit = Integer.parseInt(limit);
                    }
                }
                if (requestExecution) {
                    String nuxeoRequest = configuration.getNuxeoRequest();
                    if (configuration.isBeanShell()) {
                        Interpreter interpreter = new Interpreter();
                        interpreter.set("params", (Object)PageSelectors.decodeProperties((String)request.getParameter("selectors")));
                        interpreter.set("request", (Object)request);
                        interpreter.set("NXQLFormater", (Object)new NXQLFormater());
                        interpreter.set("basePath", (Object)nuxeoController.getBasePath());
                        interpreter.set("spacePath", (Object)nuxeoController.getSpacePath());
                        interpreter.set("navigationPath", (Object)nuxeoController.getNavigationPath());
                        interpreter.set("contentPath", (Object)nuxeoController.getContentPath());
                        nuxeoRequest = (String)interpreter.eval(nuxeoRequest);
                    }
                    if (nuxeoRequest != null) {
                        String schemas = template.getSchemas();
                        ListCommand command = new ListCommand(nuxeoRequest, nuxeoController.getDisplayLiveVersion(), 0, resultsLimit, schemas, configuration.getContentFilter(), configuration.isUseES());
                        documents = (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                        ArrayList<DocumentDTO> documentsDTO = new ArrayList<DocumentDTO>(documents.size());
                        for (Document document : documents) {
                            DocumentDTO documentDTO = this.documentDAO.toDTO(document);
                            documentsDTO.add(documentDTO);
                        }
                        request.setAttribute("documents", documentsDTO);
                    }
                }
                if ("rss".equals(request.getParameter("type"))) {
                    if (documents != null) {
                        org.w3c.dom.Document document = RssGenerator.createDocument(nuxeoController, portalControllerContext, configuration.getRssTitle(), documents, configuration.getRssReference());
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        Transformer transformer = transformerFactory.newTransformer();
                        DOMSource source = new DOMSource(document);
                        StringWriter stringWriter = new StringWriter();
                        StreamResult streamResult = new StreamResult(stringWriter);
                        transformer.transform(source, streamResult);
                        String xmlString = stringWriter.toString();
                        ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes());
                        ResourceUtil.copy((InputStream)in, (OutputStream)response.getPortletOutputStream(), (int)4096);
                        response.setContentType("application/rss+xml");
                        response.setProperty("Cache-Control", "max-age=" + response.getCacheControl().getExpirationTime());
                        response.setProperty("Last-Modified", this.formatResourceLastModified());
                        break block17;
                    }
                    throw new IllegalArgumentException("No request defined for RSS");
                }
                IPortletModule module = template.getModule();
                if (module != null) {
                    ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(module.getClassLoader());
                    try {
                        module.serveResource(portalControllerContext);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(savedClassLoader);
                    }
                }
                if (!response.isCommitted()) {
                    super.serveResource(request, response);
                }
            }
            catch (PortletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        String action = request.getParameter("javax.portlet.action");
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                window.setProperty("osivia.nuxeoRequest", StringUtils.trimToNull((String)request.getParameter("nuxeoRequest")));
                window.setProperty("osivia.beanShell", StringUtils.trimToNull((String)request.getParameter("beanShell")));
                window.setProperty("osivia.useES", StringUtils.trimToNull((String)request.getParameter("useES")));
                window.setProperty("osivia.cms.displayLiveVersion", StringUtils.trimToNull((String)request.getParameter("displayLiveVersion")));
                window.setProperty("osivia.cms.requestFilteringPolicy", StringUtils.trimToNull((String)request.getParameter("requestFilteringPolicy")));
                window.setProperty("osivia.cms.scope", StringUtils.trimToNull((String)request.getParameter("scope")));
                boolean displayMetadata = BooleanUtils.toBoolean((String)request.getParameter("metadataDisplay"));
                window.setProperty("osivia.cms.hideMetaDatas", BooleanUtils.toString((boolean)displayMetadata, null, (String)"1"));
                window.setProperty("osivia.displayNuxeoRequest", StringUtils.trimToNull((String)request.getParameter("nuxeoRequestDisplay")));
                window.setProperty("osivia.cms.maxItems", StringUtils.trimToNull((String)request.getParameter("resultsLimit")));
                window.setProperty("osivia.cms.pageSize", StringUtils.trimToNull((String)request.getParameter("normalPagination")));
                window.setProperty("osivia.cms.pageSizeMax", StringUtils.trimToNull((String)request.getParameter("maximizedPagination")));
                window.setProperty("osivia.cms.style", StringUtils.trimToNull((String)request.getParameter("template")));
                window.setProperty("osivia.permaLinkRef", StringUtils.trimToNull((String)request.getParameter("permalinkReference")));
                window.setProperty("osivia.rssLinkRef", StringUtils.trimToNull((String)request.getParameter("rssReference")));
                window.setProperty("osivia.rssTitle", StringUtils.trimToNull((String)request.getParameter("rssTitle")));
                window.setProperty("osivia.createParentPath", StringUtils.trimToNull((String)request.getParameter("creationParentPath")));
                window.setProperty("osivia.createDocType", StringUtils.trimToNull((String)request.getParameter("creationContentType")));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
        ListConfiguration configuration = this.getConfiguration(window);
        ListTemplate template = this.getCurrentTemplate(request.getLocale(), configuration);
        IPortletModule module = template.getModule();
        if (module != null) {
            ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(module.getClassLoader());
            try {
                module.processAction(nuxeoController.getPortalCtx());
            }
            finally {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        try {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            ListConfiguration configuration = this.getConfiguration(window);
            request.setAttribute("configuration", (Object)configuration);
            request.setAttribute("versions", (Object)nuxeoController.formatDisplayLiveVersionList(configuration.getVersion()));
            request.setAttribute("contentFilters", (Object)nuxeoController.formatRequestFilteringPolicyList(configuration.getContentFilter()));
            request.setAttribute("scopes", (Object)nuxeoController.formatScopeList(configuration.getScope()));
            INuxeoCustomizer customizer = this.nuxeoService.getCMSCustomizer();
            request.setAttribute("templates", (Object)customizer.getListTemplates(request.getLocale()));
            response.setContentType("text/html");
            PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(PATH_ADMIN);
            dispatcher.include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        block49: {
            try {
                String nuxeoRequest;
                NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                ListConfiguration configuration = this.getConfiguration(window);
                Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
                ListTemplate template = this.getCurrentTemplate(request.getLocale(), configuration);
                IPortletModule module = template.getModule();
                String filter = null;
                if (module instanceof IPrivilegedModule) {
                    IPrivilegedModule privilegedModule = (IPrivilegedModule)module;
                    nuxeoController.setAuthType(privilegedModule.getAuthType());
                    nuxeoController.setCacheType(privilegedModule.getCacheType());
                    filter = privilegedModule.getFilter(portalControllerContext);
                }
                boolean feed = BooleanUtils.toBoolean((String)window.getProperty("osivia.cms.feed"));
                HashMap<String, Integer> feedDocumentsOrder = null;
                boolean webidOrdering = BooleanUtils.toBoolean((String)window.getProperty("osivia.cms.ordering"));
                HashMap<String, Integer> webidOrder = null;
                if (webidOrdering) {
                    int size = NumberUtils.toInt((String)window.getProperty("osivia.cms.ordering.size"));
                    webidOrder = new HashMap<String, Integer>(size);
                    for (int i = 0; i < size; ++i) {
                        webidOrder.put(window.getProperty("osivia.cms.ordering." + i), i);
                    }
                }
                if (feed) {
                    int size = NumberUtils.toInt((String)window.getProperty("osivia.cms.news.size"));
                    feedDocumentsOrder = new HashMap<String, Integer>(size);
                    StringBuilder builder = new StringBuilder();
                    builder.append("return \"");
                    for (int i = 0; i < size; ++i) {
                        if (i > 0) {
                            builder.append(" OR ");
                        }
                        String path = window.getProperty("osivia.cms.news." + i + ".docURI");
                        feedDocumentsOrder.put(path, NumberUtils.toInt((String)window.getProperty("osivia.cms.news." + i + ".order")));
                        builder.append("ecm:path = '").append(path).append("'");
                    }
                    builder.append("\";");
                    nuxeoRequest = builder.toString();
                } else {
                    nuxeoRequest = configuration.getNuxeoRequest();
                }
                if (configuration.isBeanShell()) {
                    String orginalRequest = nuxeoRequest;
                    if ((nuxeoRequest = this.beanShellInterpretation(nuxeoController, nuxeoRequest)) != null && nuxeoRequest.contains("'null") && nuxeoController.getBasePath() == null && (orginalRequest.contains("basePath") || orginalRequest.contains("domainPath") || orginalRequest.contains("spacePath") || orginalRequest.contains("navigationPath"))) {
                        request.setAttribute("error", (Object)"La requ\u00eate ne peut pas \u00eatre interpr\u00e9t\u00e9e en mode template : valeur(s) \u00e0 'null' ");
                    }
                }
                if ("EMPTY_REQUEST".equals(nuxeoRequest = this.applyFilter(nuxeoRequest, filter))) {
                    request.setAttribute("osivia.emptyResponse", (Object)"1");
                    request.setAttribute("error", (Object)bundle.getString("LIST_MESSAGE_EMPTY_REQUEST"));
                    break block49;
                }
                if (nuxeoRequest != null) {
                    String dynamicPath;
                    Comparator<Document> comparator;
                    if (configuration.isNuxeoRequestDisplay()) {
                        request.setAttribute("nuxeoRequest", (Object)nuxeoRequest);
                    }
                    String cmsPath = request.getParameter("osivia.cms.path");
                    String selectors = request.getParameter("selectors");
                    String lastSelectors = request.getParameter("lastSelectors");
                    if ("".equals(selectors)) {
                        selectors = null;
                    }
                    if ("__NONE__".equals(lastSelectors)) {
                        lastSelectors = null;
                    }
                    request.setAttribute("lastSelectors", (Object)(StringUtils.isEmpty((String)selectors) ? "__NONE__" : selectors));
                    int resultsLimit = configuration.getResultsLimit() == null ? -1 : configuration.getResultsLimit();
                    int pageSize = -1;
                    int currentPage = 0;
                    Integer pageSizeProperty = WindowState.MAXIMIZED.equals((Object)request.getWindowState()) ? configuration.getMaximizedPagination() : configuration.getNormalPagination();
                    if (pageSizeProperty != null) {
                        boolean selectorsChanged;
                        pageSize = pageSizeProperty;
                        String currentStateParameter = request.getParameter("currentState");
                        String currentPageParameter = request.getParameter("currentPage");
                        boolean modeChanged = !request.getWindowState().toString().equals(currentStateParameter);
                        boolean bl = selectorsChanged = selectors != null && !selectors.equals(lastSelectors) || selectors == null && lastSelectors != null;
                        if (currentPageParameter != null && !modeChanged && !selectorsChanged) {
                            currentPage = NumberUtils.toInt((String)currentPageParameter);
                        }
                    }
                    request.setAttribute("currentPage", (Object)currentPage);
                    INuxeoCustomizer customizer = this.nuxeoService.getCMSCustomizer();
                    request.setAttribute("templates", (Object)customizer.getListTemplates(request.getLocale()));
                    request.setAttribute("style", (Object)StringUtils.lowerCase((String)template.getKey()));
                    String schemas = template.getSchemas();
                    int requestPageSize = 100;
                    if (pageSize > 0) {
                        requestPageSize = pageSize;
                    }
                    if (resultsLimit > 0 && currentPage == 0) {
                        requestPageSize = Math.min(requestPageSize, resultsLimit);
                    }
                    ListCommand command = new ListCommand(nuxeoRequest, nuxeoController.getDisplayLiveVersion(), currentPage, requestPageSize, schemas, configuration.getContentFilter(), configuration.isUseES());
                    PaginableDocuments documents = (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                    List documentsList = documents.list();
                    if (feed) {
                        comparator = new DocumentPathComparator(feedDocumentsOrder);
                        Collections.sort(documentsList, comparator);
                    } else if (webidOrdering) {
                        comparator = new DocumentWebidComparator(webidOrder);
                        Collections.sort(documentsList, comparator);
                    }
                    ArrayList<DocumentDTO> documentsDTO = new ArrayList<DocumentDTO>(documentsList.size());
                    for (Document document : documentsList) {
                        DocumentDTO documentDTO = this.documentDAO.toDTO(document);
                        documentsDTO.add(documentDTO);
                    }
                    request.setAttribute("documents", documentsDTO);
                    int pagesCount = 0;
                    if (pageSize > 0) {
                        int limit;
                        if (resultsLimit > 0) {
                            limit = Math.min(documents.getTotalSize(), resultsLimit);
                            if (documents.size() < (currentPage + 1) * requestPageSize) {
                                int lastPageLimit = Math.max(0, resultsLimit - currentPage * requestPageSize);
                                while (documents.size() > lastPageLimit) {
                                    documentsList.remove(documents.size() - 1);
                                }
                            }
                        } else {
                            limit = documents.getTotalSize();
                        }
                        pagesCount = (limit - 1) / pageSize + 1;
                    }
                    request.setAttribute("nbPages", (Object)pagesCount);
                    request.setAttribute("totalSize", (Object)documents.getTotalSize());
                    if (StringUtils.isNotBlank((String)configuration.getPermalinkReference())) {
                        String type;
                        String reference = configuration.getPermalinkReference();
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        if (selectors != null) {
                            Map decodedSelectors = PageSelectors.decodeProperties((String)selectors);
                            decodedSelectors.remove("selectorChanged");
                            parameters.put("selectors", PageSelectors.encodeProperties((Map)decodedSelectors));
                        }
                        if (cmsPath == null) {
                            type = "page";
                        } else {
                            type = "cms";
                            reference = null;
                        }
                        String url = nuxeoController.getPortalUrlFactory().getPermaLink(portalControllerContext, reference, parameters, cmsPath, type);
                        request.setAttribute("permaLinkURL", (Object)url);
                    }
                    if (StringUtils.isNotBlank((String)configuration.getRssReference())) {
                        boolean anonymousAccess = true;
                        if (cmsPath != null) {
                            CMSServiceCtx cmsContext = new CMSServiceCtx();
                            cmsContext.setControllerContext(ControllerContextAdapter.getControllerContext((PortalControllerContext)portalControllerContext));
                            cmsContext.setScope(nuxeoController.getScope());
                            anonymousAccess = NuxeoController.getCMSService().checkContentAnonymousAccess(cmsContext, cmsPath);
                        }
                        if (anonymousAccess) {
                            HashMap<String, String> publicParams = new HashMap<String, String>();
                            if (selectors != null) {
                                Map selectorsMap = PageSelectors.decodeProperties((String)selectors);
                                selectorsMap.remove("selectorChanged");
                                publicParams.put("selectors", PageSelectors.encodeProperties((Map)selectorsMap));
                            }
                            String url = nuxeoController.getPortalUrlFactory().getPermaLink(portalControllerContext, configuration.getRssReference(), publicParams, cmsPath, "rss");
                            request.setAttribute("rssLinkURL", (Object)url);
                        }
                    }
                    if ((dynamicPath = window.getProperty("osivia.createParentPath")) == null) {
                        dynamicPath = window.getProperty("osivia.cms.uri");
                    }
                    if (dynamicPath != null) {
                        dynamicPath = NuxeoController.getLivePath((String)nuxeoController.getComputedPath(dynamicPath));
                        NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)dynamicPath);
                        Document folder = documentContext.getDoc();
                        nuxeoController.setCurrentDoc(folder);
                        response.setTitle(folder.getTitle());
                    }
                    nuxeoController.insertContentMenuBarItems();
                    if (currentPage == 0 && documents.size() == 0) {
                        request.setAttribute("osivia.emptyResponse", (Object)"1");
                    }
                    if (module == null) break block49;
                    ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(module.getClassLoader());
                    try {
                        module.doView(portalControllerContext);
                        break block49;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(savedClassLoader);
                    }
                }
                String bshTitle = (String)request.getAttribute("bsh.title");
                String bshHTML = (String)request.getAttribute("bsh.html");
                if (StringUtils.isNotEmpty((String)bshTitle) || StringUtils.isNotEmpty((String)bshHTML)) {
                    if (StringUtils.isNotEmpty((String)bshTitle)) {
                        response.setTitle(bshTitle);
                    }
                    if (StringUtils.isNotEmpty((String)bshHTML)) {
                        response.setContentType("text/html");
                        response.getWriter().print(bshHTML);
                        response.getWriter().close();
                    }
                    return;
                }
                request.setAttribute("error", (Object)"Requ\u00eate non d\u00e9finie");
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (EvalError e) {
                request.setAttribute("error", (Object)"LIST_MESSAGE_INVALID_REQUEST");
                request.setAttribute("errorMessage", (Object)e.getMessage());
            }
            catch (PortletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
        }
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(PATH_VIEW);
        dispatcher.include(request, response);
    }

    private String beanShellInterpretation(NuxeoController nuxeoController, String nuxeoRequest) throws EvalError, CMSException {
        String taskPath;
        PortletRequest request = nuxeoController.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Interpreter interpreter = new Interpreter();
        interpreter.set("params", (Object)PageSelectors.decodeProperties((String)request.getParameter("selectors")));
        interpreter.set("basePath", (Object)nuxeoController.getBasePath());
        interpreter.set("domainPath", (Object)nuxeoController.getDomainPath());
        interpreter.set("spacePath", (Object)nuxeoController.getSpacePath());
        interpreter.set("navigationPath", (Object)nuxeoController.getNavigationPath());
        interpreter.set("navigationPubInfos", null);
        interpreter.set("spaceId", null);
        if (nuxeoController.getNavigationPath() != null) {
            CMSPublicationInfos navigationPubInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), nuxeoController.getNavigationPath());
            interpreter.set("navigationPubInfos", (Object)navigationPubInfos);
            interpreter.set("spaceId", (Object)navigationPubInfos.getSpaceID());
        }
        interpreter.set("contentPath", (Object)nuxeoController.getContentPath());
        interpreter.set("request", (Object)request);
        interpreter.set("NXQLFormater", (Object)new NXQLFormater());
        interpreter.set("navItem", (Object)nuxeoController.getNavigationItem());
        interpreter.set("storage", (Object)this.portletSequencingService.getAttributes(nuxeoController.getPortalCtx()));
        String taskId = window.getProperty("osivia.taskbar.linked.id");
        if (StringUtils.isEmpty((String)taskId)) {
            taskPath = null;
        } else {
            TaskbarTask linkedTask = null;
            try {
                List tasks = this.taskbarService.getTasks(nuxeoController.getPortalCtx(), nuxeoController.getSpacePath(), true);
                for (TaskbarTask task : tasks) {
                    if (!taskId.equals(task.getId())) continue;
                    linkedTask = task;
                    break;
                }
            }
            catch (PortalException portalException) {
                // empty catch block
            }
            taskPath = linkedTask == null ? null : linkedTask.getPath();
        }
        interpreter.set("taskPath", taskPath);
        return (String)interpreter.eval(nuxeoRequest);
    }

    private String applyFilter(String request, String filter) {
        String result;
        if (StringUtils.isEmpty((String)filter)) {
            result = request;
        } else {
            Pattern pattern = Pattern.compile("^(.*) ORDER *BY (.*)$", 2);
            Matcher matcher = pattern.matcher(request);
            StringBuilder builder = new StringBuilder();
            builder.append("(").append(filter).append(") AND (");
            if (matcher.matches()) {
                builder.append(matcher.group(1)).append(") ORDER BY ").append(matcher.group(2));
            } else {
                builder.append(request).append(")");
            }
            result = builder.toString();
        }
        return result;
    }

    private ListConfiguration getConfiguration(PortalWindow window) {
        ListConfiguration configuration = new ListConfiguration();
        configuration.setNuxeoRequest(window.getProperty("osivia.nuxeoRequest"));
        configuration.setBeanShell(BooleanUtils.toBoolean((String)window.getProperty("osivia.beanShell")));
        configuration.setUseES(BooleanUtils.toBoolean((String)window.getProperty("osivia.useES")));
        configuration.setVersion(window.getProperty("osivia.cms.displayLiveVersion"));
        configuration.setContentFilter(window.getProperty("osivia.cms.requestFilteringPolicy"));
        configuration.setScope(window.getProperty("osivia.cms.scope"));
        configuration.setMetadataDisplay(BooleanUtils.toBoolean((String)window.getProperty("osivia.cms.hideMetaDatas"), null, (String)"1"));
        configuration.setNuxeoRequestDisplay(BooleanUtils.toBoolean((String)window.getProperty("osivia.displayNuxeoRequest")));
        configuration.setResultsLimit(NumberUtils.createInteger((String)StringUtils.trimToNull((String)window.getProperty("osivia.cms.maxItems"))));
        configuration.setNormalPagination(NumberUtils.createInteger((String)StringUtils.trimToNull((String)window.getProperty("osivia.cms.pageSize"))));
        configuration.setMaximizedPagination(NumberUtils.createInteger((String)StringUtils.trimToNull((String)window.getProperty("osivia.cms.pageSizeMax"))));
        configuration.setTemplate(window.getProperty("osivia.cms.style"));
        configuration.setPermalinkReference(window.getProperty("osivia.permaLinkRef"));
        configuration.setRssReference(window.getProperty("osivia.rssLinkRef"));
        configuration.setRssTitle(window.getProperty("osivia.rssTitle"));
        configuration.setCreationParentPath(window.getProperty("osivia.createParentPath"));
        configuration.setCreationContentType(window.getProperty("osivia.createDocType"));
        return configuration;
    }
}

