/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.editablewindow;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class DocumentUpdatePropertiesCommand
implements INuxeoCommand {
    protected static final Log logger = LogFactory.getLog(DocumentUpdatePropertiesCommand.class);
    private Document inputDoc;
    private List<String> propertiesToUpdate;

    public DocumentUpdatePropertiesCommand(Document inputDoc, List<String> propertiesToUpdate) {
        this.inputDoc = inputDoc;
        this.propertiesToUpdate = propertiesToUpdate;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        Object execute = null;
        OperationRequest request = nuxeoSession.newRequest("Document.Update").setInput((OperationInput)this.inputDoc);
        StringBuilder sb = new StringBuilder();
        for (String property : this.propertiesToUpdate) {
            sb.append(property);
            sb.append("\n");
        }
        request.set("properties", (Object)sb.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sb.toString());
        }
        execute = request.execute();
        return execute;
    }

    public String getId() {
        return this.getClass().getSimpleName().concat(" : ").concat(this.inputDoc.getPath());
    }
}

