/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.cms;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPermissions;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.DocumentContextCache;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.NuxeoPermissionsImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.NuxeoPublicationInfosImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.osivia.portal.api.cms.DocumentState;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class NuxeoDocumentContextImpl
implements NuxeoDocumentContext {
    private Document document;
    private DocumentType documentType;
    private CMSPublicationInfos cmsPublicationInfos;
    private ExtendedDocumentInfos extendedInfos;
    private boolean initializedDocument;
    private boolean initializedDocumentType;
    private boolean initializedCmsPublicationInfos;
    private boolean initializedExtendedInfos;
    private final NuxeoPublicationInfosImpl publicationInfos;
    private final NuxeoPermissionsImpl permissions;
    private final CMSServiceCtx cmsContext;
    private final String path;
    private final ICMSServiceLocator cmsServiceLocator;
    private final INuxeoService nuxeoService;

    private NuxeoDocumentContextImpl(CMSServiceCtx cmsContext, String path) {
        this.cmsContext = cmsContext;
        this.path = path;
        this.publicationInfos = new NuxeoPublicationInfosImpl(this);
        this.permissions = new NuxeoPermissionsImpl(this);
        this.cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
        this.nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    }

    public static NuxeoDocumentContextImpl getDocumentContext(CMSServiceCtx cmsContext, String path) throws CMSException {
        NuxeoDocumentContextImpl documentContext;
        if (StringUtils.isEmpty((String)path)) {
            throw new CMSException("Document context path must not be empty.");
        }
        HttpServletRequest request = cmsContext.getServletRequest();
        CMSServiceCtx clonedCmsContext = new CMSServiceCtx();
        clonedCmsContext.setScope(cmsContext.getScope());
        clonedCmsContext.setDisplayLiveVersion(cmsContext.getDisplayLiveVersion());
        clonedCmsContext.setDisplayContext(cmsContext.getDisplayContext());
        clonedCmsContext.setForcePublicationInfosScope(cmsContext.getForcePublicationInfosScope());
        clonedCmsContext.setForcedLivePath(cmsContext.getForcedLivePath());
        clonedCmsContext.setForceReload(cmsContext.isForceReload());
        clonedCmsContext.setContextualizationBasePath(cmsContext.getContextualizationBasePath());
        if (cmsContext.getControllerContext() != null) {
            clonedCmsContext.setControllerContext(cmsContext.getControllerContext());
        } else {
            clonedCmsContext.setServerInvocation(cmsContext.getServerInvocation());
        }
        clonedCmsContext.setServletRequest(cmsContext.getServletRequest());
        if (request == null) {
            documentContext = new NuxeoDocumentContextImpl(cmsContext, path);
        } else {
            DocumentContextCache cache = (DocumentContextCache)request.getAttribute("osivia.document.context.cache");
            if (cache == null) {
                cache = new DocumentContextCache();
                request.setAttribute("osivia.document.context.cache", (Object)cache);
            }
            if ((documentContext = cache.get(clonedCmsContext, path)) == null) {
                documentContext = new NuxeoDocumentContextImpl(clonedCmsContext, path);
                cache.put(clonedCmsContext, path, documentContext);
            }
        }
        return documentContext;
    }

    public String getPath() {
        return this.path;
    }

    public DocumentType getDocumentType() {
        if (!this.initializedDocumentType) {
            this.initDocumentType();
        }
        return this.documentType;
    }

    private synchronized void initDocumentType() {
        if (!this.initializedDocumentType) {
            Document document = this.getDocument();
            INuxeoCustomizer cmsCustomizer = this.nuxeoService.getCMSCustomizer();
            Map types = cmsCustomizer.getDocumentTypes();
            if (document != null && types != null) {
                this.documentType = (DocumentType)types.get(document.getType());
            }
            this.initializedDocumentType = true;
        }
    }

    public DocumentState getDocumentState() {
        String displayLiveVersion = this.cmsContext.getDisplayLiveVersion();
        return DocumentState.parse((String)displayLiveVersion);
    }

    public String getScope() {
        return this.cmsContext.getScope();
    }

    public NuxeoPermissions getPermissions() {
        return this.permissions;
    }

    public NuxeoPublicationInfos getPublicationInfos() {
        return this.publicationInfos;
    }

    public Document getDocument() {
        if (!this.initializedDocument) {
            this.initDocument();
        }
        return this.document;
    }

    private synchronized void initDocument() {
        if (!this.initializedDocument) {
            CMSItem content;
            ICMSService cmsService = this.cmsServiceLocator.getCMSService();
            try {
                content = cmsService.getContent(this.cmsContext, this.path);
            }
            catch (CMSException e) {
                if (e.getErrorCode() == 3) {
                    throw new NuxeoException(3);
                }
                if (e.getErrorCode() == 1) {
                    throw new NuxeoException(1);
                }
                throw new NuxeoException(2, e.getCause());
            }
            Object nativeItem = content == null ? null : content.getNativeItem();
            if (nativeItem != null && nativeItem instanceof Document) {
                this.document = (Document)nativeItem;
            }
            this.initializedDocument = true;
        }
    }

    public String getDisplayContext() {
        return this.cmsContext.getDisplayContext();
    }

    public boolean isContextualized() {
        return StringUtils.isNotEmpty((String)this.cmsContext.getContextualizationBasePath());
    }

    public boolean isRemoteProxy() {
        Document document = this.getDocument();
        PropertyList facets = document.getFacets();
        boolean remoteProxy = facets == null ? false : facets.list().contains("isRemoteProxy");
        return remoteProxy;
    }

    public void reload() {
        this.cmsContext.setForceReload(true);
        this.refresh();
    }

    public CMSPublicationInfos getCmsPublicationInfos() {
        if (!this.initializedCmsPublicationInfos) {
            this.initCmsPublicationInfos();
        }
        return this.cmsPublicationInfos;
    }

    private synchronized void initCmsPublicationInfos() {
        if (!this.initializedCmsPublicationInfos) {
            ICMSService cmsService = this.cmsServiceLocator.getCMSService();
            try {
                this.cmsPublicationInfos = cmsService.getPublicationInfos(this.cmsContext, this.path);
            }
            catch (CMSException e) {
                if (e.getErrorCode() == 3) {
                    throw new NuxeoException(3);
                }
                if (e.getErrorCode() == 1) {
                    throw new NuxeoException(1);
                }
                throw new NuxeoException(2, e.getCause());
            }
            this.initializedCmsPublicationInfos = true;
        }
    }

    public ExtendedDocumentInfos getExtendedInfos() {
        if (!this.initializedExtendedInfos) {
            this.initExtendedInfos();
        }
        return this.extendedInfos;
    }

    private synchronized void initExtendedInfos() {
        if (!this.initializedExtendedInfos) {
            ICMSService cmsService = this.cmsServiceLocator.getCMSService();
            if (cmsService instanceof CMSService) {
                CMSService cmsServiceImpl = (CMSService)cmsService;
                try {
                    this.extendedInfos = cmsServiceImpl.getExtendedDocumentInfos(this.cmsContext, this.path);
                }
                catch (CMSException e) {
                    if (e.getErrorCode() == 3) {
                        throw new NuxeoException(3);
                    }
                    if (e.getErrorCode() == 1) {
                        throw new NuxeoException(1);
                    }
                    throw new NuxeoException(2, e.getCause());
                }
            }
            this.initializedExtendedInfos = true;
        }
    }

    private void refresh() {
        this.publicationInfos.refresh();
        this.permissions.refresh();
        this.initializedDocument = false;
        this.initializedDocumentType = false;
        this.initializedCmsPublicationInfos = false;
        this.initializedExtendedInfos = false;
    }
}

