/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.cms;

import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPermissions;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.ExtendedDocumentInfos;
import fr.toutatice.portail.cms.nuxeo.portlets.cms.NuxeoDocumentContextImpl;
import org.osivia.portal.core.cms.CMSPublicationInfos;

public class NuxeoPermissionsImpl
implements NuxeoPermissions {
    private boolean editable;
    private boolean manageable;
    private boolean deletable;
    private boolean commentable;
    private boolean anonymouslyReadable;
    private boolean canBeValidated;
    private boolean canBeCopied;
    private boolean canValidateOnlineTask;
    private boolean canSynchronize;
    private boolean canUnsynchronize;
    private boolean initializedCmsPublicationInfos;
    private boolean initializedExtendedInfos;
    private final NuxeoDocumentContextImpl documentContext;

    public NuxeoPermissionsImpl(NuxeoDocumentContextImpl documentContext) {
        this.documentContext = documentContext;
    }

    public boolean isEditable() {
        if (!this.initializedCmsPublicationInfos) {
            this.initCmsPublicationInfos();
        }
        return this.editable;
    }

    public boolean isManageable() {
        if (!this.initializedCmsPublicationInfos) {
            this.initCmsPublicationInfos();
        }
        return this.manageable;
    }

    public boolean isDeletable() {
        if (!this.initializedCmsPublicationInfos) {
            this.initCmsPublicationInfos();
        }
        return this.deletable;
    }

    public boolean isCommentable() {
        if (!this.initializedCmsPublicationInfos) {
            this.initCmsPublicationInfos();
        }
        return this.commentable;
    }

    public boolean isAnonymouslyReadable() {
        if (!this.initializedCmsPublicationInfos) {
            this.initCmsPublicationInfos();
        }
        return this.anonymouslyReadable;
    }

    public boolean canBeValidated() {
        if (!this.initializedCmsPublicationInfos) {
            this.initCmsPublicationInfos();
        }
        return this.canBeValidated;
    }

    public boolean canBeCopied() {
        if (!this.initializedCmsPublicationInfos) {
            this.initCmsPublicationInfos();
        }
        return this.canBeCopied;
    }

    private synchronized void initCmsPublicationInfos() {
        if (!this.initializedCmsPublicationInfos) {
            CMSPublicationInfos cmsPublicationInfos = this.documentContext.getCmsPublicationInfos();
            this.editable = cmsPublicationInfos.isEditableByUser();
            this.manageable = cmsPublicationInfos.isManageableByUser();
            this.deletable = cmsPublicationInfos.isDeletableByUser();
            this.commentable = cmsPublicationInfos.isCommentableByUser();
            this.anonymouslyReadable = cmsPublicationInfos.isAnonymouslyReadable();
            this.canBeValidated = cmsPublicationInfos.isUserCanValidate();
            this.canBeCopied = cmsPublicationInfos.isCopiable();
            this.initializedCmsPublicationInfos = true;
        }
    }

    public boolean canValidateOnlineTask() {
        if (!this.initializedExtendedInfos) {
            this.initExtendedInfos();
        }
        return this.canValidateOnlineTask;
    }

    public boolean canSynchronize() {
        if (!this.initializedExtendedInfos) {
            this.initExtendedInfos();
        }
        return this.canSynchronize;
    }

    public boolean canUnsynchronize() {
        if (!this.initializedExtendedInfos) {
            this.initExtendedInfos();
        }
        return this.canUnsynchronize;
    }

    private synchronized void initExtendedInfos() {
        if (!this.initializedExtendedInfos) {
            ExtendedDocumentInfos extendedInfos = this.documentContext.getExtendedInfos();
            this.canValidateOnlineTask = extendedInfos.isCanUserValidateOnlineTask();
            this.canSynchronize = extendedInfos.isCanSynchronize();
            this.canUnsynchronize = extendedInfos.isCanUnsynchronize();
            this.initializedExtendedInfos = true;
        }
    }

    public void refresh() {
        this.initializedCmsPublicationInfos = false;
        this.initializedExtendedInfos = false;
    }
}

