/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.forms;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class StartProcedureCommand
implements INuxeoCommand {
    private final String taskTitle;
    private final String actors;
    private final String additionalAuthorizations;
    private final PropertyMap properties;
    private final Blobs blobs;

    public StartProcedureCommand(String title, Set<String> actors, Set<String> additionalAuthorizations, Map<String, Object> properties) {
        this(title, actors, additionalAuthorizations, properties, null);
    }

    public StartProcedureCommand(String title, Set<String> actors, Set<String> additionalAuthorizations, Map<String, Object> properties, Blobs blobs) {
        this.taskTitle = title;
        this.actors = StringUtils.trimToNull((String)StringUtils.join(actors, (String)","));
        this.additionalAuthorizations = StringUtils.trimToNull((String)StringUtils.join(additionalAuthorizations, (String)","));
        this.properties = new PropertyMap(properties);
        this.blobs = blobs;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Services.StartProcedure");
        request.set("taskTitle", (Object)this.taskTitle);
        request.set("actors", (Object)this.actors);
        request.set("additionalAuthorizations", (Object)this.additionalAuthorizations);
        request.set("properties", (Object)this.properties);
        if (this.blobs != null) {
            request.setInput((OperationInput)this.blobs);
        }
        return request.execute();
    }

    public String getId() {
        return null;
    }
}

