/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.move;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.files.MoveDocumentCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentState;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;

public class MoveDocumentPortlet
extends CMSPortlet {
    public static final String DOCUMENT_PATH_WINDOW_PROPERTY = "osivia.move.documentPath";
    public static final String DOCUMENTS_IDENTIFIERS_WINDOW_PROPERTY = "osivia.move.documentsIdentifiers";
    public static final String IGNORED_PATHS_WINDOW_PROPERTY = "osivia.move.ignoredPaths";
    public static final String CMS_BASE_PATH_WINDOW_PROPERTY = "osivia.move.cmsBasePath";
    public static final String ACCEPTED_TYPES_WINDOW_PROPERTY = "osivia.move.acceptedTypes";
    private static final String SPACE_PATH_REQUEST_PARAMETER = "osivia.move.spacePath";
    private static final String MODE_REQUEST_PARAMETER = "osivia.move.mode";
    private static final String VIEW_PATH = "/WEB-INF/jsp/move/view.jsp";
    private static final String CHANGE_SPACE_PATH = "/WEB-INF/jsp/move/change-space.jsp";
    private DocumentDAO documentDAO;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.documentDAO = DocumentDAO.getInstance();
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String ignoredPaths;
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String cmsBasePath = request.getParameter(SPACE_PATH_REQUEST_PARAMETER);
        if (cmsBasePath == null) {
            cmsBasePath = window.getProperty(CMS_BASE_PATH_WINDOW_PROPERTY);
        }
        if (cmsBasePath != null) {
            cmsBasePath = nuxeoController.getComputedPath(cmsBasePath);
            Document currentSpace = null;
            Document rootSpace = null;
            String path = cmsBasePath;
            while (rootSpace == null && StringUtils.isNotEmpty((String)path)) {
                DocumentType type;
                CMSItem spaceConfig;
                try {
                    spaceConfig = cmsService.getSpaceConfig(cmsContext, path);
                }
                catch (CMSException e) {
                    throw new PortletException((Throwable)e);
                }
                if (currentSpace == null) {
                    currentSpace = (Document)spaceConfig.getNativeItem();
                }
                if ((type = spaceConfig.getType()) != null && type.isRoot()) {
                    rootSpace = (Document)spaceConfig.getNativeItem();
                    cmsBasePath = rootSpace.getPath();
                    continue;
                }
                CMSObjectPath objectPath = CMSObjectPath.parse((String)path);
                CMSObjectPath parentObjectPath = objectPath.getParent();
                path = parentObjectPath.toString();
            }
            Document space = rootSpace == null ? currentSpace : rootSpace;
            DocumentDTO spaceDto = this.documentDAO.toDTO(space);
            request.setAttribute("spaceDocument", (Object)spaceDto);
        }
        request.setAttribute("cmsBasePath", (Object)cmsBasePath);
        String documentPath = window.getProperty(DOCUMENT_PATH_WINDOW_PROPERTY);
        if (documentPath != null) {
            String navigationPath;
            try {
                CMSItem navigationItem = cmsService.getPortalNavigationItem(cmsContext, cmsBasePath, documentPath);
                if (navigationItem == null) {
                    CMSObjectPath objectPath = CMSObjectPath.parse((String)documentPath);
                    CMSObjectPath parentObjectPath = objectPath.getParent();
                    navigationItem = cmsService.getPortalNavigationItem(cmsContext, cmsBasePath, parentObjectPath.toString());
                }
                navigationPath = navigationItem == null ? null : navigationItem.getPath();
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
            request.setAttribute("cmsNavigationPath", (Object)navigationPath);
        }
        if ((ignoredPaths = window.getProperty(IGNORED_PATHS_WINDOW_PROPERTY)) == null) {
            ignoredPaths = documentPath;
        }
        request.setAttribute("ignoredPaths", (Object)ignoredPaths);
        String acceptedTypes = window.getProperty(ACCEPTED_TYPES_WINDOW_PROPERTY);
        request.setAttribute("acceptedTypes", (Object)acceptedTypes);
        String error = request.getParameter("error");
        request.setAttribute("error", (Object)error);
        String dispatcherPath = "space".equals(request.getParameter(MODE_REQUEST_PARAMETER)) ? CHANGE_SPACE_PATH : VIEW_PATH;
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(dispatcherPath).include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        block12: {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            nuxeoController.setDisplayLiveVersion(DocumentState.LIVE.toString());
            PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            Bundle bundle = this.getBundleFactory().getBundle(request.getLocale());
            String action = request.getParameter("javax.portlet.action");
            if ("move".equals(action)) {
                String targetPath = request.getParameter("targetPath");
                if (StringUtils.isBlank((String)targetPath)) {
                    response.setRenderParameter("error", "emptyTargetPath");
                } else {
                    String redirectionPath;
                    List<String> sourceIds;
                    String path = window.getProperty(DOCUMENT_PATH_WINDOW_PROPERTY);
                    NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
                    Document document = documentContext.getDocument();
                    String[] identifiersProperty = StringUtils.split((String)window.getProperty(DOCUMENTS_IDENTIFIERS_WINDOW_PROPERTY), (String)",");
                    if (identifiersProperty == null) {
                        sourceIds = new ArrayList<String>(1);
                        sourceIds.add(document.getId());
                    } else {
                        sourceIds = Arrays.asList(identifiersProperty);
                    }
                    NuxeoDocumentContext targetDocumentContext = nuxeoController.getDocumentContext(targetPath);
                    NuxeoPublicationInfos targetPublicationInfos = targetDocumentContext.getPublicationInfos();
                    String targetId = targetPublicationInfos.getLiveId();
                    if (identifiersProperty == null) {
                        CMSObjectPath parentPath = CMSObjectPath.parse((String)document.getPath()).getParent();
                        redirectionPath = parentPath.toString();
                    } else {
                        redirectionPath = document.getPath();
                    }
                    MoveDocumentCommand command = new MoveDocumentCommand(sourceIds, targetId);
                    try {
                        nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                        String redirectionURL = this.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, redirectionPath, null, null, "refreshPageAndNavigation", null, null, null, null);
                        redirectionURL = this.getPortalUrlFactory().adaptPortalUrlToPopup(portalControllerContext, redirectionURL, 1);
                        request.setAttribute("osivia.redirection.url", (Object)redirectionURL);
                        String message = sourceIds.size() == 1 ? bundle.getString("DOCUMENT_MOVE_SUCCESS_MESSAGE") : bundle.getString("DOCUMENTS_MOVE_SUCCESS_MESSAGE", new Object[]{sourceIds.size()});
                        this.getNotificationsService().addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
                    }
                    catch (NuxeoException e) {
                        if (1 == e.getErrorCode()) {
                            response.setRenderParameter("error", "403");
                            break block12;
                        }
                        String message = bundle.getString("DOCUMENT_MOVE_ERROR_MESSAGE");
                        this.getNotificationsService().addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
                    }
                }
            } else if ("changeSpace".equals(action)) {
                String spacePath = request.getParameter("spacePath");
                response.setRenderParameter(SPACE_PATH_REQUEST_PARAMETER, spacePath);
            }
        }
    }
}

