/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.portalsite;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.portlets.portalsite.PortalSiteBean;
import fr.toutatice.portail.cms.nuxeo.portlets.portalsite.PortalSiteFetchCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.portalsite.ServiceDisplayItem;
import java.io.IOException;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class NavigationPortlet
extends CMSPortlet {
    private static Log logger = LogFactory.getLog(NavigationPortlet.class);

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        logger.debug((Object)"processAction ");
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("modifierPrefs") != null) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
            window.setProperty("osivia.cms.uri", req.getParameter("nuxeoPath"));
            if (req.getParameter("scope") != null && req.getParameter("scope").length() > 0) {
                window.setProperty("osivia.cms.scope", req.getParameter("scope"));
            } else if (window.getProperty("osivia.cms.scope") != null) {
                window.setProperty("osivia.cms.scope", null);
            }
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("annuler") != null) {
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        NuxeoController ctx = new NuxeoController((PortletRequest)req, (PortletResponse)res, this.getPortletContext());
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        if (nuxeoPath == null) {
            nuxeoPath = "";
        }
        req.setAttribute("nuxeoPath", (Object)nuxeoPath);
        String scope = window.getProperty("osivia.cms.scope");
        req.setAttribute("scope", (Object)scope);
        req.setAttribute("ctx", (Object)ctx);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/portalsite/admin.jsp");
        rd.include(req, res);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        block7: {
            logger.debug((Object)"doView");
            try {
                ArrayList<ServiceDisplayItem> listItems;
                NuxeoController ctx;
                response.setContentType("text/html");
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String nuxeoPath = null;
                nuxeoPath = window.getProperty("osivia.cms.uri");
                if (nuxeoPath != null) {
                    ctx = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                    ctx.setAsynchronousUpdates(true);
                    PortalSiteBean portalSite = (PortalSiteBean)ctx.executeNuxeoCommand((INuxeoCommand)new PortalSiteFetchCommand(ctx.getComputedPath(nuxeoPath)));
                    if (portalSite.getPortalDocument().getTitle() != null) {
                        response.setTitle(portalSite.getPortalDocument().getTitle());
                    }
                    listItems = new ArrayList<ServiceDisplayItem>();
                    for (Document child : portalSite.getChildren()) {
                        Link link = ctx.getLink(child, "menu");
                        if (link == null) continue;
                        listItems.add(new ServiceDisplayItem(child.getTitle(), link.getUrl(), link.isExternal()));
                    }
                } else {
                    response.setContentType("text/html");
                    response.getWriter().print("<h2>Document non d\u00e9fini</h2>");
                    response.getWriter().close();
                    return;
                }
                request.setAttribute("serviceItems", listItems);
                request.setAttribute("ctx", (Object)ctx);
                this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/portalsite/view.jsp").include(request, response);
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (Exception e) {
                if (e instanceof PortletException) break block7;
                throw new PortletException((Throwable)e);
            }
        }
        logger.debug((Object)"doView end");
    }
}

