/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.Symlink;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.RequestPublishStatus;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentsMetadataImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.core.cms.DocumentsMetadata;

public class DocumentsMetadataCommand
implements INuxeoCommand {
    private static final String SCHEMAS = "dublincore, toutatice, ottc_web";
    private final String basePath;
    private final String version;
    private final List<Symlink> symlinks;
    private final Long timestamp;
    private final boolean elasticSearch;

    public DocumentsMetadataCommand(String basePath, RequestPublishStatus version, List<Symlink> symlinks, Long timestamp) {
        this.basePath = basePath;
        this.version = version.getStatus();
        this.symlinks = symlinks == null ? new ArrayList<Symlink>(0) : symlinks;
        this.timestamp = timestamp;
        this.elasticSearch = NuxeoCompatibility.canUseES();
    }

    public DocumentsMetadata execute(Session nuxeoSession) throws Exception {
        List documents = this.getDocuments(nuxeoSession).list();
        if (this.timestamp == null) {
            Document rootDocument = this.getRootDocument(nuxeoSession);
            documents.add(rootDocument);
        }
        return new DocumentsMetadataImpl(this.basePath, documents, this.symlinks);
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("/");
        builder.append(this.basePath);
        builder.append("/");
        builder.append(this.version);
        builder.append("/");
        builder.append(this.timestamp);
        return builder.toString();
    }

    private Documents getDocuments(Session nuxeoSession) throws Exception {
        String targetsFilteredRequest;
        StringBuilder documentsRequest = new StringBuilder();
        documentsRequest.append("ecm:path STARTSWITH '");
        documentsRequest.append(this.basePath);
        documentsRequest.append("'");
        this.addTimestampClause(documentsRequest);
        int state = NuxeoQueryFilter.getState((String)this.version);
        NuxeoQueryFilterContext documentsFilterContext = new NuxeoQueryFilterContext(state);
        String documentsFilteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)documentsFilterContext, (String)documentsRequest.toString());
        if (this.symlinks.isEmpty()) {
            targetsFilteredRequest = null;
        } else {
            StringBuilder targetsRequest = new StringBuilder();
            targetsRequest.append("(");
            boolean first = true;
            for (Symlink symlink : this.symlinks) {
                if (first) {
                    first = false;
                } else {
                    targetsRequest.append(" OR ");
                }
                targetsRequest.append("ecm:path = '");
                targetsRequest.append(symlink.getTargetPath());
                targetsRequest.append("' OR ecm:path STARTSWITH '");
                targetsRequest.append(symlink.getTargetPath());
                targetsRequest.append("'");
            }
            targetsRequest.append(")");
            this.addTimestampClause(targetsRequest);
            NuxeoQueryFilterContext targetsFilterContext = new NuxeoQueryFilterContext(1);
            targetsFilteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)targetsFilterContext, (String)targetsRequest.toString());
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document WHERE (");
        query.append(documentsFilteredRequest);
        query.append(")");
        if (targetsFilteredRequest != null) {
            query.append(" OR (");
            query.append(targetsFilteredRequest);
            query.append(")");
        }
        return this.executeRequest(nuxeoSession, query.toString());
    }

    private void addTimestampClause(StringBuilder request) {
        if (this.timestamp != null) {
            Date date = new Date(this.timestamp);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            request.append(" AND dc:modified > TIMESTAMP '");
            request.append(dateFormat.format(date));
            request.append("'");
        }
    }

    private Documents executeRequest(Session nuxeoSession, String query) throws Exception {
        OperationRequest operationRequest;
        if (this.elasticSearch) {
            operationRequest = nuxeoSession.newRequest("Document.QueryES");
            operationRequest.set("X-NXDocumentProperties", (Object)SCHEMAS);
            operationRequest.set("pageSize", (Object)-1);
            operationRequest.set("currentPageIndex", (Object)0);
        } else {
            operationRequest = nuxeoSession.newRequest("Document.Query");
            operationRequest.setHeader("X-NXDocumentProperties", SCHEMAS);
        }
        operationRequest.set("query", (Object)query.toString());
        return (Documents)operationRequest.execute();
    }

    private Document getRootDocument(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Document.Fetch");
        request.setHeader("X-NXDocumentProperties", SCHEMAS);
        request.set("value", (Object)this.basePath);
        return (Document)request.execute();
    }
}

