/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class FullLoadedNavigationCommand
implements INuxeoCommand {
    private static final String SCHEMAS = "dublincore, common, toutatice";
    private final String basePath;
    private final boolean liveVersion;

    public FullLoadedNavigationCommand(String basePath, boolean liveVersion) {
        this.basePath = basePath;
        this.liveVersion = liveVersion;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)SCHEMAS);
        StringBuilder clause = new StringBuilder();
        clause.append("(ecm:path = '").append(this.basePath).append("' OR ecm:path STARTSWITH '").append(this.basePath).append("') ");
        clause.append("AND (ecm:mixinType = 'Folderish' OR ttc:showInMenu = 1) ");
        clause.append("ORDER BY ecm:pos");
        int filterState = this.liveVersion ? 1 : 0;
        NuxeoQueryFilterContext filterContext = new NuxeoQueryFilterContext(filterState);
        String query = "SELECT * FROM Document WHERE " + NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)filterContext, (String)clause.toString());
        request.set("query", (Object)query);
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("|");
        builder.append(this.basePath);
        builder.append("|");
        builder.append(this.liveVersion);
        return builder.toString();
    }
}

