/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.service.PublishInfosCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.cache.services.ICacheService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.Satellite;

public class DocumentsDiscoveryService {
    private static DocumentsDiscoveryService instance;
    private long cacheTimestamp;
    private final CMSService cmsService;
    private final ICacheService cacheService;
    private final Map<String, Satellite> cache;
    private final Map<String, Satellite> satellites;

    private DocumentsDiscoveryService(CMSService cmsService) {
        Set<Satellite> satellites;
        this.cmsService = cmsService;
        this.cacheService = (ICacheService)Locator.findMBean(ICacheService.class, (String)"osivia:service=CacheServices");
        this.cache = new ConcurrentHashMap<String, Satellite>();
        try {
            satellites = this.cmsService.getSatellites();
        }
        catch (CMSException e) {
            satellites = null;
        }
        if (CollectionUtils.isEmpty(satellites)) {
            this.satellites = new ConcurrentHashMap<String, Satellite>(1);
        } else {
            this.satellites = new ConcurrentHashMap<String, Satellite>(satellites.size() + 1);
            for (Satellite satellite : satellites) {
                this.satellites.put(satellite.getId(), satellite);
            }
        }
        Satellite main = Satellite.MAIN;
        this.satellites.put(main.getId(), main);
    }

    public static DocumentsDiscoveryService getInstance(CMSService cmsService) {
        if (instance == null) {
            DocumentsDiscoveryService.initInstance(cmsService);
        }
        return instance;
    }

    private static synchronized void initInstance(CMSService cmsService) {
        if (instance == null) {
            instance = new DocumentsDiscoveryService(cmsService);
        }
    }

    public Satellite discoverLocation(String path) throws CMSException {
        Satellite satellite;
        this.handleCacheReinitialization();
        if (StringUtils.isEmpty((String)path)) {
            satellite = null;
        } else {
            Satellite cachedResult = this.cache.get(path);
            if (cachedResult == null) {
                DiscoveryResult discoveryResult;
                satellite = this.pathRegexSearch(path);
                if (satellite == null) {
                    discoveryResult = this.satellitesDiscovery(path);
                    if (discoveryResult != null) {
                        satellite = discoveryResult.satellite;
                    }
                } else {
                    discoveryResult = null;
                }
                this.cache.put(path, satellite);
                if (discoveryResult != null && StringUtils.isNotEmpty((String)discoveryResult.path) && !StringUtils.equals((String)path, (String)discoveryResult.path)) {
                    this.cache.put(discoveryResult.path, satellite);
                }
            } else {
                satellite = cachedResult;
            }
        }
        return satellite;
    }

    private void handleCacheReinitialization() {
        boolean reinitialized;
        boolean bl = reinitialized = !this.cacheService.checkIfPortalParametersReloaded(this.cacheTimestamp);
        if (reinitialized) {
            this.cache.clear();
            this.cacheTimestamp = System.currentTimeMillis();
        }
    }

    public Satellite pathRegexSearch(String path) {
        Satellite result = null;
        if (StringUtils.isNotEmpty((String)path)) {
            Iterator<Satellite> satelliteIterator = this.satellites.values().iterator();
            while (result == null && satelliteIterator.hasNext()) {
                Satellite satellite = satelliteIterator.next();
                if (!CollectionUtils.isNotEmpty((Collection)satellite.getPaths())) continue;
                Iterator pathsIterator = satellite.getPaths().iterator();
                while (result == null && pathsIterator.hasNext()) {
                    Pattern pattern = (Pattern)pathsIterator.next();
                    Matcher matcher = pattern.matcher(path);
                    if (!matcher.find()) continue;
                    result = satellite;
                }
            }
        }
        return result;
    }

    public DiscoveryResult satellitesDiscovery(String path) throws CMSException {
        DiscoveryResult discoveryResult;
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setScope("superuser_context");
        cmsContext.setForcePublicationInfosScope("superuser_context");
        List<Satellite> main = Arrays.asList(Satellite.MAIN);
        List<DiscoveryResult> discoveryResults = this.invoke(cmsContext, path, main);
        if (discoveryResults.size() == 1) {
            discoveryResult = discoveryResults.get(0);
        } else {
            ArrayList<Satellite> others = new ArrayList<Satellite>(this.satellites.values());
            others.remove(Satellite.MAIN);
            discoveryResults = this.invoke(cmsContext, path, others);
            if (discoveryResults.size() == 0) {
                throw new CMSException(3);
            }
            if (discoveryResults.size() == 1) {
                discoveryResult = discoveryResults.get(0);
            } else {
                throw new CMSException(2);
            }
        }
        return discoveryResult;
    }

    private List<DiscoveryResult> invoke(CMSServiceCtx cmsContext, String path, List<Satellite> satellites) throws CMSException {
        ArrayList<DiscoveryResult> discoveryResults;
        if (CollectionUtils.isEmpty(satellites)) {
            discoveryResults = new ArrayList<DiscoveryResult>(0);
        } else {
            List futures;
            int threadPoolSize = satellites.size();
            ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize);
            discoveryResults = new ArrayList(threadPoolSize);
            ArrayList<DiscoveryCallable> tasks = new ArrayList<DiscoveryCallable>(threadPoolSize);
            for (Satellite satellite : satellites) {
                DiscoveryCallable task = new DiscoveryCallable(this.cmsService, cmsContext, satellite, path);
                tasks.add(task);
            }
            try {
                futures = executor.invokeAll(tasks, 10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new CMSException((Throwable)e);
            }
            for (Future future : futures) {
                try {
                    DiscoveryResult discoveryResult = (DiscoveryResult)future.get();
                    if (discoveryResult.error != 0 || !StringUtils.isNotEmpty((String)discoveryResult.path)) continue;
                    discoveryResults.add(discoveryResult);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new CMSException((Throwable)e);
                }
            }
        }
        return discoveryResults;
    }

    private class DiscoveryResult {
        private int error;
        private String path;
        private final Satellite satellite;

        public DiscoveryResult(Satellite satellite) {
            this.satellite = satellite;
        }
    }

    private class DiscoveryCallable
    implements Callable<DiscoveryResult> {
        private final CMSServiceCtx cmsContext;
        private final Satellite satellite;
        private final String path;

        public DiscoveryCallable(ICMSService cmsService, CMSServiceCtx cmsContext, Satellite satellite, String path) {
            this.cmsContext = cmsContext;
            this.satellite = satellite;
            this.path = path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DiscoveryResult call() throws Exception {
            DiscoveryResult result = new DiscoveryResult(this.satellite);
            Satellite savedSatellite = this.cmsContext.getSatellite();
            try {
                this.cmsContext.setSatellite(this.satellite);
                PublishInfosCommand command = new PublishInfosCommand(this.satellite, this.path);
                CMSPublicationInfos publicationInfos = (CMSPublicationInfos)DocumentsDiscoveryService.this.cmsService.executeNuxeoCommand(this.cmsContext, command);
                if (publicationInfos != null) {
                    result.path = publicationInfos.getDocumentPath();
                }
            }
            catch (CMSException e) {
                result.error = e.getErrorCode();
            }
            finally {
                this.cmsContext.setSatellite(savedSatellite);
            }
            return result;
        }
    }
}

