/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.editablewindow;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.Map;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class DocumentAddComplexPropertyCommand
implements INuxeoCommand {
    private final Document inputDocument;
    private final String xpath;
    private final Map<String, String> value;

    public DocumentAddComplexPropertyCommand(Document inputDocument, String xpath, Map<String, String> value) {
        this.inputDocument = inputDocument;
        this.xpath = xpath;
        this.value = value;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.value.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append("\n");
            }
            builder.append(entry.getKey());
            builder.append("=");
            builder.append(entry.getValue());
        }
        OperationRequest request = nuxeoSession.newRequest("Document.AddComplexProperty");
        request.setInput((OperationInput)this.inputDocument);
        request.set("xpath", (Object)this.xpath);
        request.set("value", (Object)builder.toString());
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" : ");
        builder.append(this.xpath);
        return builder.toString();
    }
}

