/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.list;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class ListCommand
implements INuxeoCommand {
    public static final String VCS_FORCE_FLAG = "nx_querying_vcs_force";
    private final String nuxeoRequest;
    private final int pageNumber;
    private final int pageSize;
    private final String schemas;
    private final String version;
    private final String portalPolicyFilter;
    private boolean forceVCS;

    public ListCommand(String nuxeoRequest, String version, int pageNumber, int pageSize, String schemas, String portalPolicyFilter) {
        this.nuxeoRequest = nuxeoRequest;
        this.version = version;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.schemas = schemas;
        this.portalPolicyFilter = portalPolicyFilter;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = this.isForceVCS() ? this.generateVCSRequest(nuxeoSession) : this.generateESRequest(nuxeoSession);
        int state = NuxeoQueryFilter.getState((String)this.version);
        NuxeoQueryFilterContext queryFilter = new NuxeoQueryFilterContext(state, this.portalPolicyFilter);
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)queryFilter, (String)this.nuxeoRequest);
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        return request.execute();
    }

    protected OperationRequest generateESRequest(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.QueryES");
        request.set("pageSize", (Object)this.pageSize);
        request.set("currentPageIndex", (Object)this.pageNumber);
        request.set("X-NXDocumentProperties", (Object)this.schemas);
        return request;
    }

    protected OperationRequest generateVCSRequest(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.PageProvider");
        request.setHeader(VCS_FORCE_FLAG, "true");
        request.set("pageSize", (Object)this.pageSize);
        request.set("page", (Object)this.pageNumber);
        request.setHeader("X-NXDocumentProperties", this.schemas);
        request.set("maxResults", (Object)"-1");
        return request;
    }

    public boolean isForceVCS() {
        return this.forceVCS;
    }

    public void setForceVCS(boolean forceVCS) {
        this.forceVCS = forceVCS;
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("/");
        builder.append(this.version);
        builder.append("/");
        builder.append(this.pageSize);
        builder.append("/");
        builder.append(this.pageNumber);
        builder.append("/");
        builder.append(this.nuxeoRequest);
        return builder.toString();
    }
}

