/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.Customizable;
import fr.toutatice.portail.cms.nuxeo.api.domain.CustomizedJsp;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.INavigationAdapterModule;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.player.IPlayerModule;
import org.osivia.portal.api.set.SetType;
import org.osivia.portal.api.taskbar.TaskbarItems;
import org.osivia.portal.api.theming.TabGroup;
import org.osivia.portal.api.theming.TemplateAdapter;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.DomainContextualization;
import org.osivia.portal.core.customization.ICMSCustomizationObserver;
import org.osivia.portal.core.customization.ICustomizationService;

public class CustomizationPluginMgr
implements ICMSCustomizationObserver {
    private static final String CUSTOM_JSP_EXTENTION = "-custom-";
    private static final String WEB_INF_JSP = "/WEB-INF/jsp";
    private final DefaultCMSCustomizer customizer;
    private final ICustomizationService customizationService;
    private final Map<Locale, Map<String, Object>> customizationAttributesCache;
    private final Map<String, CustomizedJsp> customizedJavaServerPagesCache;
    private final Map<Locale, Map<String, FragmentType>> fragmentsCache;
    private final Map<Locale, Map<String, EditableWindow>> ewCache;
    private final Map<Locale, List<ListTemplate>> templatesCache;
    private final Map<Locale, SortedMap<String, String>> menuTemplatesCache;
    private final Map<String, ReentrantLock> jspLocks;
    private List<IPlayerModule> dynamicModules;
    private Map<String, DocumentType> typesCache;
    private List<INavigationAdapterModule> navigationAdaptersCache;
    private List<DomainContextualization> domainContextualizationCache;
    private Map<String, TabGroup> tabGroupsCache;
    private TaskbarItems taskbarItemsCache;
    private List<MenubarModule> menubarModulesCache;
    private List<TemplateAdapter> templateAdaptersCache;
    private Map<String, FormFilter> formFiltersCache;
    private Map<String, SetType> setTypesCache;
    private long customizationDeployementTS;

    public CustomizationPluginMgr(DefaultCMSCustomizer customizer) {
        this.customizer = customizer;
        this.customizationService = (ICustomizationService)Locator.findMBean(ICustomizationService.class, (String)"osivia:service=CustomizationService");
        this.customizationService.setCMSObserver((ICMSCustomizationObserver)this);
        this.customizationAttributesCache = new ConcurrentHashMap();
        this.customizedJavaServerPagesCache = new ConcurrentHashMap();
        this.fragmentsCache = new ConcurrentHashMap();
        this.ewCache = new ConcurrentHashMap();
        this.templatesCache = new ConcurrentHashMap();
        this.menuTemplatesCache = new ConcurrentHashMap();
        this.jspLocks = new ConcurrentHashMap();
        this.customizationDeployementTS = System.currentTimeMillis();
    }

    private Map<String, Object> getCustomizationAttributes(Locale locale) {
        Map attributes = (Map)this.customizationAttributesCache.get(locale);
        if (attributes == null) {
            ConcurrentHashMap<String, Map<String, DocumentType>> customizationAttributes = new ConcurrentHashMap<String, Map<String, DocumentType>>();
            CustomizationContext customizationContext = new CustomizationContext(customizationAttributes, locale);
            List defaultTypes = this.customizer.getDefaultCMSItemTypes();
            Map<String, DocumentType> types = Collections.synchronizedMap(new LinkedHashMap(defaultTypes.size()));
            for (DocumentType defaultType : defaultTypes) {
                types.put(defaultType.getName(), defaultType.clone());
            }
            List customizedTypes = this.customizer.getCustomizedCMSItemTypes();
            for (DocumentType customizedType : customizedTypes) {
                types.put(customizedType.getName(), customizedType.clone());
            }
            customizationAttributes.put(Customizable.DOC_TYPE.toString(), types);
            this.customizationService.customize("osivia.customizer.cms.id", customizationContext);
            this.customizationAttributesCache.put(locale, customizationAttributes);
        }
        return (Map)this.customizationAttributesCache.get(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomizedJsp customizeJSP(String name, PortletContext portletContext, PortletRequest request) throws IOException {
        CustomizedJsp customizedPage = (CustomizedJsp)this.customizedJavaServerPagesCache.get(name);
        if (customizedPage == null && name != null) {
            ReentrantLock jspLock = (ReentrantLock)this.jspLocks.get(name);
            if (jspLock == null) {
                jspLock = new ReentrantLock();
                this.jspLocks.put(name, jspLock);
            }
            jspLock.lock();
            try {
                customizedPage = (CustomizedJsp)this.customizedJavaServerPagesCache.get(name);
                if (customizedPage == null) {
                    String relativePath;
                    CustomizedJsp page;
                    Locale locale = request.getLocale();
                    Map customizationAttributes = this.getCustomizationAttributes(locale);
                    customizedPage = new CustomizedJsp(name, null);
                    Map customizedPages = (Map)customizationAttributes.get(Customizable.JSP.toString());
                    if (customizedPages != null && (page = (CustomizedJsp)customizedPages.get(relativePath = StringUtils.removeStart((String)name, (String)WEB_INF_JSP))) != null && name.contains(".")) {
                        StringBuilder destination = new StringBuilder();
                        destination.append(StringUtils.substringBeforeLast((String)name, (String)"."));
                        destination.append(CUSTOM_JSP_EXTENTION);
                        destination.append(this.customizationDeployementTS);
                        destination.append(".");
                        destination.append(StringUtils.substringAfterLast((String)name, (String)"."));
                        String directoryPath = portletContext.getRealPath("/");
                        File directory = new File(directoryPath);
                        File destinationFile = new File(directory, destination.toString());
                        destinationFile.delete();
                        File sourceFile = new File(page.getName());
                        FileUtils.copyFile((File)sourceFile, (File)destinationFile);
                        customizedPage = new CustomizedJsp(destination.toString(), page.getClassLoader());
                    }
                    this.customizedJavaServerPagesCache.put(name, customizedPage);
                }
            }
            finally {
                jspLock.unlock();
            }
        }
        return customizedPage;
    }

    public List<ListTemplate> customizeListTemplates(Locale locale) {
        List templates = (List)this.templatesCache.get(locale);
        if (templates == null) {
            templates = this.customizer.initListTemplates(locale);
            Map customizationAttributes = this.getCustomizationAttributes(locale);
            Map templatesMap = (Map)customizationAttributes.get(Customizable.LIST_TEMPLATE.toString() + locale);
            if (templatesMap != null) {
                Set customTemplates = templatesMap.entrySet();
                for (Map.Entry customTemplate : customTemplates) {
                    templates.add(customTemplate.getValue());
                }
            }
            this.templatesCache.put(locale, templates);
        }
        return templates;
    }

    public Map<String, FragmentType> getFragments(Locale locale) {
        Hashtable<String, FragmentType> fragments = (Hashtable<String, FragmentType>)this.fragmentsCache.get(locale);
        if (fragments == null) {
            List initList = this.customizer.initListFragments(locale);
            fragments = new Hashtable<String, FragmentType>();
            for (FragmentType fragment : initList) {
                fragments.put(fragment.getKey(), fragment);
            }
            Map customizationAttributes = this.getCustomizationAttributes(locale);
            List fragmentsList = (List)customizationAttributes.get(Customizable.FRAGMENT.toString() + locale);
            if (fragmentsList != null) {
                for (FragmentType customFragment : fragmentsList) {
                    fragments.put(customFragment.getKey(), customFragment);
                }
            }
            this.fragmentsCache.put(locale, fragments);
        }
        return fragments;
    }

    public Map<String, EditableWindow> customizeEditableWindows(Locale locale) {
        Hashtable ew = (Hashtable)this.ewCache.get(locale);
        if (ew == null) {
            Map initList = this.customizer.initEditableWindows(locale);
            ew = new Hashtable();
            for (Map.Entry customEw : initList.entrySet()) {
                ew.put(customEw.getKey(), customEw.getValue());
            }
            Map customizationAttributes = this.getCustomizationAttributes(locale);
            Map ewList = (Map)customizationAttributes.get(Customizable.EDITABLE_WINDOW.toString() + locale);
            if (ewList != null) {
                for (Map.Entry customEw : ewList.entrySet()) {
                    ew.put(customEw.getKey(), customEw.getValue());
                }
            }
            this.ewCache.put(locale, ew);
        }
        return ew;
    }

    public Map<String, DocumentType> customizeCMSItemTypes() {
        if (this.typesCache == null) {
            Map customizationAttributes = this.getCustomizationAttributes(Locale.getDefault());
            this.typesCache = (Map)customizationAttributes.get(Customizable.DOC_TYPE.toString());
        }
        return this.typesCache;
    }

    public List<MenubarModule> customizeMenubarModules() {
        if (this.menubarModulesCache == null) {
            Map attributes = this.getCustomizationAttributes(Locale.getDefault());
            this.menubarModulesCache = (List)attributes.get(Customizable.MENUBAR.toString());
            if (this.menubarModulesCache == null) {
                this.menubarModulesCache = new ArrayList(0);
            }
        }
        return this.menubarModulesCache;
    }

    public List<IPlayerModule> customizeModules() {
        if (this.dynamicModules == null) {
            Map customizationAttributes = this.getCustomizationAttributes(Locale.getDefault());
            List players = (List)customizationAttributes.get(Customizable.PLAYER.toString());
            this.dynamicModules = new ArrayList();
            if (players != null) {
                this.dynamicModules.addAll(players);
            }
        }
        return this.dynamicModules;
    }

    public SortedMap<String, String> customizeMenuTemplates(Locale locale) {
        SortedMap templates = (SortedMap)this.menuTemplatesCache.get(locale);
        if (templates == null) {
            templates = this.customizer.initMenuTemplates(locale);
            Map customizationAttributes = this.getCustomizationAttributes(locale);
            SortedMap customizedTemplates = (SortedMap)customizationAttributes.get(Customizable.MENU_TEMPLATE.toString() + locale);
            if (customizedTemplates != null) {
                Set entrySet = customizedTemplates.entrySet();
                Iterator iterator = entrySet.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry customizedTemplate = entry = iterator.next();
                    String key = (String)customizedTemplate.getKey();
                    String label = (String)customizedTemplate.getValue();
                    templates.put(key, label);
                }
            }
            this.menuTemplatesCache.put(locale, templates);
        }
        return templates;
    }

    public List<INavigationAdapterModule> customizeNavigationAdapters() {
        if (this.navigationAdaptersCache == null) {
            this.navigationAdaptersCache = new ArrayList();
            Map attributes = this.getCustomizationAttributes(Locale.getDefault());
            List customizedModules = (List)attributes.get(Customizable.NAVIGATION_ADAPTERS.toString());
            if (customizedModules != null) {
                CollectionUtils.addAll((Collection)this.navigationAdaptersCache, customizedModules.iterator());
            }
        }
        return this.navigationAdaptersCache;
    }

    public List<DomainContextualization> customizeDomainContextualization() {
        if (this.domainContextualizationCache == null) {
            this.domainContextualizationCache = new ArrayList();
            Map attributes = this.getCustomizationAttributes(Locale.getDefault());
            List customizedModules = (List)attributes.get(Customizable.DOMAIN_CONTEXTUALIZATION.toString());
            if (customizedModules != null) {
                CollectionUtils.addAll((Collection)this.domainContextualizationCache, customizedModules.iterator());
            }
        }
        return this.domainContextualizationCache;
    }

    public Map<String, TabGroup> customizeTabGroups() {
        if (this.tabGroupsCache == null) {
            Map attributes = this.getCustomizationAttributes(Locale.getDefault());
            Map tabGroups = (Map)attributes.get(Customizable.TAB_GROUPS.toString());
            this.tabGroupsCache = tabGroups == null ? new ConcurrentHashMap() : tabGroups;
        }
        return this.tabGroupsCache;
    }

    public TaskbarItems customizeTaskbarItems() throws CMSException {
        if (this.taskbarItemsCache == null) {
            TaskbarItems defaultTaskbarItems = this.customizer.getDefaultTaskbarItems();
            Map attributes = this.getCustomizationAttributes(Locale.getDefault());
            TaskbarItems customizedTaskbarItems = (TaskbarItems)attributes.get(Customizable.TASKBAR_ITEMS.toString());
            if (defaultTaskbarItems != null) {
                this.taskbarItemsCache = defaultTaskbarItems;
                if (customizedTaskbarItems != null) {
                    this.taskbarItemsCache.add(customizedTaskbarItems.getAll());
                }
            } else if (customizedTaskbarItems != null) {
                this.taskbarItemsCache = customizedTaskbarItems;
            }
        }
        return this.taskbarItemsCache;
    }

    public List<TemplateAdapter> customizeTemplateAdapters() {
        if (this.templateAdaptersCache == null) {
            Map attributes = this.getCustomizationAttributes(Locale.getDefault());
            this.templateAdaptersCache = (List)attributes.get(Customizable.TEMPLATE_ADAPTERS.toString());
            if (this.templateAdaptersCache == null) {
                this.templateAdaptersCache = new ArrayList(0);
            }
        }
        return this.templateAdaptersCache;
    }

    public Map<String, FormFilter> getFormFilters() {
        if (this.formFiltersCache == null) {
            Map attributes = this.getCustomizationAttributes(Locale.getDefault());
            this.formFiltersCache = (Map)attributes.get(Customizable.FORM_FILTERS.toString());
            if (this.formFiltersCache == null) {
                this.formFiltersCache = new ConcurrentHashMap(0);
            }
        }
        return this.formFiltersCache;
    }

    public List<String> getRegisteredPluginNames() {
        return this.customizationService.getRegisteredPluginNames();
    }

    public boolean isPluginRegistered(String pluginName) {
        return this.customizationService.isPluginRegistered(pluginName);
    }

    public Map<String, SetType> getSetTypes() {
        if (this.setTypesCache == null) {
            Map attributes = this.getCustomizationAttributes(Locale.getDefault());
            this.setTypesCache = (Map)attributes.get(Customizable.SET_TYPES.toString());
            if (this.setTypesCache == null) {
                this.setTypesCache = new ConcurrentHashMap(0);
            }
        }
        return this.setTypesCache;
    }

    public void notifyDeployment() {
        this.customizationDeployementTS = System.currentTimeMillis();
        this.dynamicModules = null;
        this.typesCache = null;
        this.navigationAdaptersCache = null;
        this.domainContextualizationCache = null;
        this.tabGroupsCache = null;
        this.taskbarItemsCache = null;
        this.menubarModulesCache = null;
        this.templateAdaptersCache = null;
        this.formFiltersCache = null;
        this.setTypesCache = null;
        this.customizationAttributesCache.clear();
        this.customizedJavaServerPagesCache.clear();
        this.fragmentsCache.clear();
        this.ewCache.clear();
        this.templatesCache.clear();
        this.menuTemplatesCache.clear();
    }
}

