/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.bridge;

import fr.toutatice.portail.cms.nuxeo.portlets.bridge.Formater;
import fr.toutatice.portail.cms.nuxeo.portlets.bridge.StringHelper;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.urls.Link;

/*
 * Exception performing whole class analysis ignored.
 */
public class AbstractFormater {
    private static Map<String, String> nuxeoIcons = new HashMap();
    private static Map<String, String> nuxeoBigIcons;
    private static Map<String, String> nuxeoTypes;

    public static String formatDate(Document doc) throws ParseException {
        String sDate = doc.getProperties().getString("dc:modified");
        if (sDate == null) {
            sDate = doc.getProperties().getString("dc:created");
        }
        if (sDate == null) {
            return "";
        }
        sDate = sDate.substring(0, 10);
        SimpleDateFormat inputFormater = new SimpleDateFormat("yyyy-MM-dd");
        Date date = inputFormater.parse(sDate);
        DateFormat outputFormater = DateFormat.getDateInstance(1, Locale.FRENCH);
        return outputFormater.format(date);
    }

    public static String formatDateAndTime(Document doc) throws ParseException {
        String sDate = doc.getProperties().getString("dc:modified");
        if (sDate == null) {
            sDate = doc.getProperties().getString("dc:created");
        }
        if (sDate == null) {
            return "";
        }
        SimpleDateFormat inputFormater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
        inputFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = inputFormater.parse(sDate);
        SimpleDateFormat outputFormater = new SimpleDateFormat("dd/MM/yy HH:mm");
        return outputFormater.format(date);
    }

    public static String formatSize(Document doc) throws ParseException {
        String sSize = doc.getProperties().getString("common:size");
        if (sSize == null || "0".equals(sSize)) {
            return "";
        }
        Long lSize = Long.decode(sSize);
        lSize = lSize / 1000L + 1L;
        return Long.toString(lSize) + " Ko";
    }

    public static String formatText(String text, boolean printLineFeeds) throws ParseException {
        if (text == null) {
            return "";
        }
        String output = text;
        if (!printLineFeeds) {
            output = output.replaceAll("\n", " ");
            output = output.replaceAll("\r", " ");
        }
        return StringHelper.escapeHTML((String)output);
    }

    public static String formatDescription(Document doc, boolean printLineFeeds) throws ParseException {
        String description = doc.getProperties().getString("dc:description");
        return AbstractFormater.formatText((String)description, (boolean)printLineFeeds);
    }

    public static String formatDescription(Document doc) throws ParseException {
        return AbstractFormater.formatDescription((Document)doc, (boolean)true);
    }

    private static String extractNuxeoIconName(Document doc) {
        String iconName = null;
        String iconURI = doc.getProperties().getString("common:icon");
        if (iconURI != null) {
            int namePos = iconURI.lastIndexOf(47);
            iconName = namePos != -1 ? iconURI.substring(namePos + 1) : iconURI;
        }
        return iconName;
    }

    public static String formatNuxeoIcon(Document doc) {
        if ("Folder".equals(doc.getType()) || "OrderedFolder".equals(doc.getType()) || "Workspace".equals(doc.getType()) || "WorkspaceRoot".equals(doc.getType()) || "Section".equals(doc.getType()) || "SectionRoot".equals(doc.getType()) || "WorkspaceRoot".equals(doc.getType())) {
            return "/img/icons/folder.gif";
        }
        String portalIcon = "file.gif";
        String iconName = AbstractFormater.extractNuxeoIconName((Document)doc);
        if (iconName != null && nuxeoIcons.get(iconName) != null) {
            portalIcon = (String)nuxeoIcons.get(iconName);
        }
        return "/img/icons/" + portalIcon;
    }

    public static String formatNuxeoBigIcon(Document doc) {
        String iconName;
        String portalIcon = "file_100.png";
        if ("Folder".equals(doc.getType()) || "OrderedFolder".equals(doc.getType()) || "Workspace".equals(doc.getType()) || "WorkspaceRoot".equals(doc.getType())) {
            portalIcon = "folder_100.png";
        }
        if ((iconName = AbstractFormater.extractNuxeoIconName((Document)doc)) != null && nuxeoBigIcons.get(iconName) != null) {
            portalIcon = (String)nuxeoBigIcons.get(iconName);
        }
        return "/img/icons/" + portalIcon;
    }

    public static String formatEmptyIcon() {
        String portalIcon = "empty.gif";
        return "/img/icons/" + portalIcon;
    }

    public static String formatExternalIcon() {
        return "/img/icons/link.png";
    }

    public static String formatSpecificIcon(Document doc) {
        String icon = AbstractFormater.formatEmptyIcon();
        if ("File".equals(doc.getType())) {
            icon = Formater.formatNuxeoIcon((Document)doc);
        }
        if ("ContextualLink".equals(doc.getType())) {
            icon = Formater.formatExternalIcon();
        }
        return icon;
    }

    public static String formatType(Document doc) {
        if (nuxeoTypes.get(doc.getType()) != null) {
            return (String)nuxeoTypes.get(doc.getType());
        }
        return "";
    }

    public static String formatTarget(Link link) {
        if (link.isExternal()) {
            return "target=\"_blank\"";
        }
        return "";
    }

    public static String formatVignette(Document doc) {
        String portalIcon = "file.gif";
        String nuxeoURI = doc.getProperties().getString("common:icon");
        if (nuxeoURI != null && nuxeoIcons.get(nuxeoURI) != null) {
            portalIcon = (String)nuxeoIcons.get(nuxeoURI);
        }
        return "/img/icons/" + portalIcon;
    }

    public static String formatLink(Link link, Document doc, String extraClassName, String title) {
        String linkClassName = extraClassName;
        if (link.isDownloadable()) {
            linkClassName = linkClassName + " osivia-link-download";
        }
        if (link.isExternal()) {
            linkClassName = linkClassName + " osivia-link-external";
        }
        String target = AbstractFormater.formatTarget((Link)link);
        String res = "<a " + target + " href=\"" + link.getUrl() + "\" class=\"" + linkClassName + "\" title=\"" + title + "\"><span>" + doc.getTitle() + "</span></a>";
        return res;
    }

    public static String formatLink(Link link, Document doc, String extraClassName) {
        return AbstractFormater.formatLink((Link)link, (Document)doc, (String)extraClassName, (String)"");
    }

    public static String formatLink(Link link, Document doc) {
        return AbstractFormater.formatLink((Link)link, (Document)doc, (String)"");
    }

    static {
        nuxeoIcons.put("note.gif", "note.gif");
        nuxeoIcons.put("contextuallink.png", "link.png");
        nuxeoIcons.put("word.png", "word.png");
        nuxeoIcons.put("doc.png", "word.png");
        nuxeoIcons.put("docx.png", "word.png");
        nuxeoIcons.put("xls.png", "xls.png");
        nuxeoIcons.put("xlsx.png", "xls.png");
        nuxeoIcons.put("ppt.png", "ppt.png");
        nuxeoIcons.put("pdf.png", "pdf.png");
        nuxeoIcons.put("zip.png", "zip.png");
        nuxeoIcons.put("odt.png", "odt.png");
        nuxeoIcons.put("forum.gif", "forum.gif");
        nuxeoIcons.put("url-folder.gif", "url_folder.gif");
        nuxeoIcons.put("annonceFolder_16.png", "news_folder.png");
        nuxeoIcons.put("annonce_16.png", "annonce_16.png");
        nuxeoIcons.put("blog_folder.png", "blog_folder.png");
        nuxeoIcons.put("website.gif", "website.gif");
        nuxeoIcons.put("picturebook.gif", "picturebook.gif");
        nuxeoIcons.put("faq-folder-16.png", "faq-folder-16.png");
        nuxeoIcons.put("portalsite.png", "portalsite.png");
        nuxeoIcons.put("ordered_folder.png", "ordered_folder.png");
        nuxeoIcons.put("video.png", "video.png");
        nuxeoIcons.put("application.png", "application.png");
        nuxeoBigIcons = new HashMap();
        nuxeoBigIcons.put("note.gif", "note_100.png");
        nuxeoBigIcons.put("contextuallink.png", "link_100.png");
        nuxeoTypes = new HashMap();
        nuxeoTypes.put("File", "Fichier");
        nuxeoTypes.put("Folder", "Dossier");
        nuxeoTypes.put("OrderedFolder", "Dossier");
        nuxeoTypes.put("Note", "Note HTML");
        nuxeoTypes.put("Annonce", "Annonce");
        nuxeoTypes.put("AnnonceFolder", "Dossier d'annonces");
        nuxeoTypes.put("Forum", "Forum");
        nuxeoTypes.put("PictureBook", "Livre d'image");
        nuxeoTypes.put("Picture", "Image");
        nuxeoTypes.put("ContextualLink", "Lien externe");
    }
}

