/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class GetAncestorsCommand
implements INuxeoCommand {
    private final String path;

    public GetAncestorsCommand(String path) {
        this.path = path;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        Object result;
        ArrayList<String> ancestorPaths;
        int count = StringUtils.countMatches((String)this.path, (String)"/");
        if (count > 1) {
            ancestorPaths = new ArrayList<String>(count - 1);
            String truncatedPath = this.path;
            while (StringUtils.countMatches((String)truncatedPath, (String)"/") > 1) {
                ancestorPaths.add(truncatedPath);
                truncatedPath = StringUtils.substringBeforeLast((String)truncatedPath, (String)"/");
            }
        } else {
            ancestorPaths = null;
        }
        if (CollectionUtils.isEmpty(ancestorPaths)) {
            result = null;
        } else {
            StringBuilder nxqlRequest = new StringBuilder();
            nxqlRequest.append("ecm:path IN ('").append(StringUtils.join(ancestorPaths, (String)"', '")).append("') ");
            String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, (String)nxqlRequest.toString());
            OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
            request.set("X-NXDocumentProperties", (Object)"*");
            request.set("query", (Object)filteredRequest);
            result = request.execute();
        }
        return result;
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("|");
        builder.append(this.path);
        return builder.toString();
    }
}

