/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.rename;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.rename.RenameCommand;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class RenamePortlet
extends CMSPortlet {
    private static final String PATH_VIEW = "/WEB-INF/jsp/rename/view.jsp";
    public static final String DOCUMENT_REDIRECT_PATH_WINDOW_PROPERTY = "osivia.rename.document.redirect.path";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        Document currentDocument = this.getCurrentDocument(window, nuxeoController);
        request.setAttribute("currentDocTitle", (Object)currentDocument.getTitle());
        DocumentDTO currentDocumentDto = DocumentDAO.getInstance().toDTO(currentDocument);
        request.setAttribute("docIcon", (Object)currentDocumentDto.getIcon());
        request.setAttribute("error", (Object)request.getParameter("error"));
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(PATH_VIEW);
        dispatcher.include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String action = request.getParameter("javax.portlet.action");
        if (PortletMode.VIEW.equals((Object)request.getPortletMode()) && "renameDoc".equals(action)) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            Document currentDocument = this.getCurrentDocument(window, nuxeoController);
            String newDocTitle = request.getParameter("newDocTitle");
            if (StringUtils.isNotBlank((String)newDocTitle)) {
                Document updatedDcoument = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RenameCommand(currentDocument, newDocTitle));
                this.addNotification(nuxeoController.getPortalCtx(), "RENAME_DOCUMENT_SUCCESS", NotificationsType.SUCCESS);
                NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(updatedDcoument.getPath());
                documentContext.reload();
                String redirectPath = window.getProperty(DOCUMENT_REDIRECT_PATH_WINDOW_PROPERTY);
                if (StringUtils.isEmpty((String)redirectPath)) {
                    redirectPath = updatedDcoument.getPath();
                }
                String redirectionUrl = nuxeoController.getPortalUrlFactory().getCMSUrl(nuxeoController.getPortalCtx(), null, redirectPath, null, null, "refreshPageAndNavigation", null, null, null, null);
                response.sendRedirect(redirectionUrl);
            } else {
                response.setRenderParameter("error", this.getBundleFactory().getBundle(request.getLocale()).getString("RENAME_DOCUMENT_TITLE_REQUIRED"));
            }
        }
    }

    private Document getCurrentDocument(PortalWindow window, NuxeoController nuxeoController) {
        String path = window.getProperty("osivia.cms.uri");
        path = nuxeoController.getComputedPath(path);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        documentContext.reload();
        Document currentDocument = documentContext.getDocument();
        return currentDocument;
    }
}

