/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.Satellite;

public class PublishInfosCommand
implements INuxeoCommand {
    protected static Log logger = LogFactory.getLog(PublishInfosCommand.class);
    private final String path;
    private final Satellite satellite;

    public PublishInfosCommand(Satellite satellite, String path) {
        this.satellite = satellite;
        this.path = path;
    }

    public CMSPublicationInfos execute(Session automationSession) throws Exception {
        CMSPublicationInfos publiInfos = null;
        OperationRequest request = automationSession.newRequest("Document.FetchPublicationInfos");
        if (this.path.startsWith("webId:")) {
            request.set("webid", (Object)this.path.replaceAll("webId:", ""));
        } else {
            request.set("path", (Object)this.path);
        }
        Blob binariesInfos = (Blob)request.execute();
        if (binariesInfos != null) {
            publiInfos = new CMSPublicationInfos();
            publiInfos.setSatellite(this.satellite);
            String pubInfosContent = IOUtils.toString((InputStream)binariesInfos.getStream(), (String)"UTF-8");
            JSONArray infosContent = JSONArray.fromObject((Object)pubInfosContent);
            for (JSONObject infos : infosContent) {
                String publishSpacePath;
                publiInfos.setErrorCodes(this.adaptList((JSONArray)infos.get("errorCodes")));
                publiInfos.setDocumentPath(this.decode((String)this.adaptType(String.class, infos.get("documentPath"))));
                publiInfos.setLiveId((String)this.adaptType(String.class, infos.get("liveId")));
                publiInfos.setEditableByUser(this.adaptBoolean(infos.get("editableByUser")).booleanValue());
                publiInfos.setManageableByUser(this.adaptBoolean(infos.get("manageableByUser")).booleanValue());
                publiInfos.setRemotePublishable(this.adaptBoolean(infos.get("isRemotePublishable")).booleanValue());
                publiInfos.setRemotePublished(this.adaptBoolean(infos.get("isRemotePublished")).booleanValue());
                publiInfos.setDeletableByUser(this.adaptBoolean(infos.get("isDeletableByUser")).booleanValue());
                publiInfos.setUserCanValidate(this.adaptBoolean(infos.get("canUserValidate")).booleanValue());
                publiInfos.setPublished(this.adaptBoolean(infos.get("published")).booleanValue());
                if (infos.containsKey((Object)"canUnpublishRemoteProxy")) {
                    publiInfos.setUserCanUnpublishRemoteProxy(this.adaptBoolean(infos.get("canUnpublishRemoteProxy")).booleanValue());
                }
                if (infos.containsKey((Object)"isLiveDeleted")) {
                    publiInfos.setLiveDeleted(this.adaptBoolean(infos.get("isLiveDeleted")).booleanValue());
                }
                publiInfos.setCommentableByUser(this.adaptBoolean(infos.get("isCommentableByUser")).booleanValue());
                publiInfos.setAnonymouslyReadable(this.adaptBoolean(infos.get("anonymouslyReadable")).booleanValue());
                publiInfos.setBeingModified(this.adaptBoolean(infos.get("isLiveModifiedFromProxy")).booleanValue());
                publiInfos.setCopiable(this.adaptBoolean(infos.get("canCopy")).booleanValue());
                publiInfos.setSubTypes(this.decodeSubTypes((Map)this.adaptType(JSONObject.class, infos.get("subTypes"))));
                publiInfos.setPublishSpaceType((String)this.adaptType(String.class, infos.get("publishSpaceType")));
                publiInfos.setEditableByUser(this.adaptBoolean(infos.get("editableByUser")).booleanValue());
                publiInfos.setManageableByUser(this.adaptBoolean(infos.get("manageableByUser")).booleanValue());
                publiInfos.setRemotePublishable(this.adaptBoolean(infos.get("isRemotePublishable")).booleanValue());
                publiInfos.setRemotePublished(this.adaptBoolean(infos.get("isRemotePublished")).booleanValue());
                publiInfos.setDeletableByUser(this.adaptBoolean(infos.get("isDeletableByUser")).booleanValue());
                publiInfos.setUserCanValidate(this.adaptBoolean(infos.get("canUserValidate")).booleanValue());
                publiInfos.setPublished(this.adaptBoolean(infos.get("published")).booleanValue());
                if (infos.containsKey((Object)"canUnpublishRemoteProxy")) {
                    publiInfos.setUserCanUnpublishRemoteProxy(this.adaptBoolean(infos.get("canUnpublishRemoteProxy")).booleanValue());
                }
                if (infos.containsKey((Object)"isLiveDeleted")) {
                    publiInfos.setLiveDeleted(this.adaptBoolean(infos.get("isLiveDeleted")).booleanValue());
                }
                publiInfos.setCommentableByUser(this.adaptBoolean(infos.get("isCommentableByUser")).booleanValue());
                publiInfos.setAnonymouslyReadable(this.adaptBoolean(infos.get("anonymouslyReadable")).booleanValue());
                publiInfos.setBeingModified(this.adaptBoolean(infos.get("isLiveModifiedFromProxy")).booleanValue());
                publiInfos.setCopiable(this.adaptBoolean(infos.get("canCopy")).booleanValue());
                if (infos.containsKey((Object)"draftPath")) {
                    publiInfos.setHasDraft(true);
                    publiInfos.setDraftPath(this.decode((String)this.adaptType(String.class, infos.get("draftPath"))));
                }
                if (infos.containsKey((Object)"draftContextualizationPath")) {
                    publiInfos.setDraft(true);
                    publiInfos.setNotOrphanDraft(this.adaptBoolean(infos.get("hasCheckinedDoc")).booleanValue());
                    publiInfos.setDraftContextualizationPath(this.decode((String)this.adaptType(String.class, infos.get("draftContextualizationPath"))));
                }
                if (infos.containsKey((Object)"driveEnabled")) {
                    publiInfos.setDriveEnabled(infos.getBoolean("driveEnabled"));
                }
                if (infos.containsKey((Object)"driveEditURL")) {
                    publiInfos.setDriveEditURL(infos.getString("driveEditURL"));
                }
                if (infos.containsKey((Object)"spaceID")) {
                    publiInfos.setSpaceID((String)this.adaptType(String.class, (Object)infos.getString("spaceID")));
                }
                if (infos.containsKey((Object)"parentSpaceID")) {
                    publiInfos.setParentSpaceID((String)this.adaptType(String.class, (Object)infos.getString("parentSpaceID")));
                }
                if (StringUtils.isNotEmpty((String)(publishSpacePath = this.decode((String)this.adaptType(String.class, infos.get("publishSpacePath")))))) {
                    publiInfos.setPublishSpacePath(publishSpacePath);
                    publiInfos.setPublishSpaceDisplayName(this.decode((String)this.adaptType(String.class, infos.get("publishSpaceDisplayName"))));
                    publiInfos.setLiveSpace(false);
                    continue;
                }
                String workspacePath = this.decode((String)this.adaptType(String.class, infos.get("workspacePath")));
                if (!StringUtils.isNotEmpty((String)workspacePath)) continue;
                publiInfos.setPublishSpacePath(workspacePath);
                publiInfos.setPublishSpaceDisplayName(this.decode((String)this.adaptType(String.class, infos.get("workspaceDisplayName"))));
                publiInfos.setLiveSpace(true);
            }
            if (binariesInfos instanceof FileBlob) {
                ((FileBlob)binariesInfos).getFile().delete();
            }
        }
        return publiInfos;
    }

    private Map<String, String> decodeSubTypes(Map<String, String> subTypes) throws UnsupportedEncodingException {
        HashMap<String, String> decodedSubTypes = new HashMap<String, String>();
        for (Map.Entry<String, String> subType : subTypes.entrySet()) {
            String decodedLabel = this.decode(subType.getValue());
            decodedSubTypes.put(subType.getKey(), decodedLabel);
        }
        return decodedSubTypes;
    }

    public String getId() {
        StringBuilder id = new StringBuilder();
        id.append("PublishInfosCommand/").append(StringUtils.removeEnd((String)this.path, (String)".proxy"));
        return id.toString();
    }

    private String decode(String value) throws UnsupportedEncodingException {
        if (value != null) {
            return URLDecoder.decode(value, "UTF-8");
        }
        return value;
    }

    private List<Integer> adaptList(JSONArray list) {
        ArrayList<Integer> returnedList = new ArrayList<Integer>();
        List jsonList = (List)JSONArray.toCollection((JSONArray)list);
        if (jsonList != null) {
            returnedList.addAll(jsonList);
        }
        return returnedList;
    }

    private Boolean adaptBoolean(Object value) {
        if (value != null) {
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            return (Boolean)value;
        }
        return Boolean.FALSE;
    }

    private <T> T adaptType(Class<T> clazz, Object object) throws InstantiationException, IllegalAccessException {
        Object returnedObject = object;
        if (object == null) {
            returnedObject = clazz.newInstance();
        }
        return (T)returnedObject;
    }
}

