/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.publish;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSItem;

public class NavigationDisplayItem {
    private final String id;
    private final String title;
    private final String url;
    private final boolean external;
    private final boolean selected;
    private final boolean current;
    private final boolean fetchedChildren;
    private final CMSItem navItem;
    private final String[] acceptedTypes;
    private final List<NavigationDisplayItem> children;
    private boolean lastSelected;

    public NavigationDisplayItem(Document document, Link link, boolean selected, boolean current, boolean fetchedChildren, CMSItem navItem) {
        this.id = document.getId();
        this.title = document.getTitle();
        this.url = link.getUrl();
        this.external = link.isExternal();
        this.selected = selected;
        this.current = current;
        this.fetchedChildren = fetchedChildren;
        this.navItem = navItem;
        this.acceptedTypes = this.getAcceptedTypes(navItem);
        this.children = new ArrayList<NavigationDisplayItem>();
    }

    private String[] getAcceptedTypes(CMSItem item) {
        List types;
        String[] acceptedTypes = null;
        if (item != null && item.getType() != null && (types = item.getType().getSubtypes()) != null) {
            acceptedTypes = types.toArray(new String[types.size()]);
        }
        return acceptedTypes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NavigationDisplayItem [title=");
        builder.append(this.title);
        builder.append(", url=");
        builder.append(this.url);
        builder.append("]");
        return builder.toString();
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public boolean isFetchedChildren() {
        return this.fetchedChildren;
    }

    public CMSItem getNavItem() {
        return this.navItem;
    }

    public String[] getAcceptedTypes() {
        return this.acceptedTypes;
    }

    public List<NavigationDisplayItem> getChildren() {
        return this.children;
    }

    public boolean isLastSelected() {
        return this.lastSelected;
    }

    public void setLastSelected(boolean lastSelected) {
        this.lastSelected = lastSelected;
    }
}

