/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.selectors;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class KeywordsSelectorPortlet
extends CMSPortlet {
    public static final String DELETE_PREFIX = "delete_";
    private static final Log logger = LogFactory.getLog(KeywordsSelectorPortlet.class);
    private final IBundleFactory bundleFactory;

    public KeywordsSelectorPortlet() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(((Object)((Object)this)).getClass().getClassLoader());
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        logger.debug((Object)"processAction ");
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = request.getParameter("javax.portlet.action");
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                List keywords;
                String selectorId = StringUtils.trimToNull((String)request.getParameter("selectorId"));
                window.setProperty("osivia.selectorId", selectorId);
                String selectorType = StringUtils.trimToNull((String)request.getParameter("selectorType"));
                window.setProperty("osivia.keywordMonoValued", selectorType);
                String selectorLabel = StringUtils.trimToNull((String)request.getParameter("selectorLabel"));
                window.setProperty("osivia.libelle", selectorLabel);
                String selectorPlaceholder = StringUtils.trimToNull((String)request.getParameter("selectorPlaceholder"));
                window.setProperty("osivia.placeholder", selectorPlaceholder);
                String selectorHtmlIdentifier = StringUtils.trimToNull((String)request.getParameter("selectorHtmlIdentifier"));
                window.setProperty("osivia.htmlIdentifier", selectorHtmlIdentifier);
                boolean displayResetButton = BooleanUtils.toBoolean((String)request.getParameter("selectorDisplayResetButton"));
                window.setProperty("osivia.displayResetButton", String.valueOf(displayResetButton));
                boolean preventAjaxRefresh = "2".equals(selectorType);
                window.setProperty("osivia.ajax.preventRefresh", String.valueOf(preventAjaxRefresh));
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                if (selectors != null && (keywords = (List)selectors.get(request.getParameter("selectorId"))) != null && keywords.size() > 0) {
                    keywords.clear();
                    if (request.getParameter("selectors") != null) {
                        response.setRenderParameter("lastSelectors", request.getParameter("selectors"));
                    }
                    response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
                }
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        } else if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            boolean reset = "reset".equals(action);
            if (request.getParameter("add") != null || request.getParameter("monoAdd") != null || reset) {
                String selectorId = window.getProperty("osivia.selectorId");
                if (selectorId != null) {
                    Map selectors;
                    ArrayList<String> keywords;
                    String keyword = null;
                    if (!reset) {
                        keyword = request.getParameter("keyword");
                    }
                    if ((keywords = (ArrayList<String>)(selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"))).get(selectorId)) == null) {
                        keywords = new ArrayList<String>();
                        selectors.put(selectorId, keywords);
                    }
                    if ("1".equals(window.getProperty("osivia.keywordMonoValued")) || "2".equals(window.getProperty("osivia.keywordMonoValued"))) {
                        keywords.clear();
                    }
                    if (StringUtils.isNotBlank((String)keyword)) {
                        keywords.add(keyword);
                    }
                    if (request.getParameter("selectors") != null) {
                        response.setRenderParameter("lastSelectors", request.getParameter("selectors"));
                    }
                    response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
                    request.setAttribute("osivia.unsetMaxMode", (Object)"true");
                }
                response.setPortletMode(PortletMode.VIEW);
                response.setWindowState(WindowState.NORMAL);
            } else if ("delete".equals(action)) {
                String selectorId;
                int occ = new Integer(request.getParameter("occ")) - 1;
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                List keywords = (List)selectors.get(selectorId = window.getProperty("osivia.selectorId"));
                if (keywords != null && keywords.size() > occ) {
                    keywords.remove(occ);
                    if (request.getParameter("selectors") != null) {
                        response.setRenderParameter("lastSelectors", request.getParameter("selectors"));
                    }
                    response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
                    request.setAttribute("osivia.unsetMaxMode", (Object)"true");
                }
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String selectorId = StringUtils.trimToEmpty((String)window.getProperty("osivia.selectorId"));
        request.setAttribute("selectorId", (Object)selectorId);
        String selectorType = StringUtils.defaultIfBlank((String)window.getProperty("osivia.keywordMonoValued"), (String)"0");
        request.setAttribute("selectorType", (Object)selectorType);
        String selectorLabel = StringUtils.trimToEmpty((String)window.getProperty("osivia.libelle"));
        request.setAttribute("selectorLabel", (Object)selectorLabel);
        String selectorPlaceholder = StringUtils.trimToEmpty((String)window.getProperty("osivia.placeholder"));
        request.setAttribute("selectorPlaceholder", (Object)selectorPlaceholder);
        String selectorHtmlIdentifier = StringUtils.trimToEmpty((String)window.getProperty("osivia.htmlIdentifier"));
        request.setAttribute("selectorHtmlIdentifier", (Object)selectorHtmlIdentifier);
        boolean displayResetButton = BooleanUtils.toBoolean((String)window.getProperty("osivia.displayResetButton"));
        request.setAttribute("selectorDisplayResetButton", (Object)displayResetButton);
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/selectors/keywords/admin.jsp");
        response.setContentType("text/html");
        dispatcher.include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        logger.debug((Object)"doView");
        try {
            response.setContentType("text/html");
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String selectorId = window.getProperty("osivia.selectorId");
            String selectorType = StringUtils.defaultIfBlank((String)window.getProperty("osivia.keywordMonoValued"), (String)"0");
            request.setAttribute("selectorType", (Object)selectorType);
            String selectorLabel = window.getProperty("osivia.libelle");
            request.setAttribute("selectorLabel", (Object)selectorLabel);
            String selectorPlaceholder = window.getProperty("osivia.placeholder");
            if (StringUtils.isEmpty((String)selectorLabel) && StringUtils.isEmpty((String)selectorPlaceholder)) {
                Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
                selectorPlaceholder = StringUtils.equals((String)"0", (String)selectorType) ? bundle.getString("SELECTOR_KEYWORD_PLACEHOLDER") : bundle.getString("SELECTOR_KEYWORDS_PLACEHOLDER");
            }
            request.setAttribute("selectorPlaceholder", (Object)selectorPlaceholder);
            String selectorHtmlIdentifier = window.getProperty("osivia.htmlIdentifier");
            request.setAttribute("selectorHtmlIdentifier", (Object)selectorHtmlIdentifier);
            boolean displayResetButton = BooleanUtils.toBoolean((String)window.getProperty("osivia.displayResetButton"));
            request.setAttribute("selectorDisplayResetButton", (Object)displayResetButton);
            if (selectorId != null) {
                Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                List selector = (List)selectors.get(selectorId);
                if (selector != null) {
                    String[] keywords = new String[selector.size()];
                    for (int i = 0; i < selector.size(); ++i) {
                        keywords[i] = StringEscapeUtils.escapeHtml((String)((String)selector.get(i)));
                    }
                    request.setAttribute("keywords", (Object)keywords);
                } else {
                    request.setAttribute("keywords", (Object)ArrayUtils.EMPTY_STRING_ARRAY);
                }
                String keyword = StringEscapeUtils.escapeHtml((String)request.getParameter("keyword"));
                request.setAttribute("keyword", (Object)keyword);
                this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/selectors/keywords/view.jsp").include(request, response);
            } else {
                response.getWriter().print("<h2>Identifiant non d\u00e9fini</h2>");
                response.getWriter().close();
            }
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        logger.debug((Object)"doView end");
    }
}

