/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.statistics;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomizationPluginMgr;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.statistics.GetSpaceStatisticsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.statistics.UpdateSpaceStatisticsCommand;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.core.controller.ControllerContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.statistics.SpaceStatistics;
import org.osivia.portal.api.statistics.SpaceVisits;
import org.osivia.portal.api.statistics.StatisticsModule;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class StatisticsCmsServiceDelegation {
    public static final DateFormat DAY_FORMAT = new SimpleDateFormat("dd-MM-yyyy");
    public static final DateFormat MONTH_FORMAT = new SimpleDateFormat("MM-yyyy");
    private final Log log = LogFactory.getLog(this.getClass());
    private final INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");

    public List<SpaceStatistics> getSpaceStatistics(CMSServiceCtx cmsContext, Set<String> paths) throws CMSException {
        ArrayList<Object> statistics;
        PortletContext portletContext = cmsContext.getPortletCtx();
        NuxeoController nuxeoController = new NuxeoController(portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        if (CollectionUtils.isEmpty(paths)) {
            statistics = new ArrayList<SpaceStatistics>(0);
        } else {
            GetSpaceStatisticsCommand command = new GetSpaceStatisticsCommand(paths);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            statistics = new ArrayList(documents.size());
            for (Document document : documents) {
                statistics.add(this.convertSpaceStatistics(document));
            }
        }
        return statistics;
    }

    private SpaceStatistics convertSpaceStatistics(Document document) {
        SpaceStatistics statistics = new SpaceStatistics(document.getPath());
        PropertyMap properties = document.getProperties();
        Date lastUpdate = properties.getDate("stats:lastUpdate");
        statistics.setLastUpdate(lastUpdate);
        SpaceVisits currentDayVisits = this.getVisits(properties.getMap("stats:dayVisits"), false);
        statistics.setCurrentDayVisits(currentDayVisits);
        SpaceVisits currentMonthVisits = this.getVisits(properties.getMap("stats:monthVisits"), false);
        statistics.setCurrentMonthVisits(currentMonthVisits);
        Map<Date, SpaceVisits> lastDaysVisits = this.getHistorizedVisits(properties.getList("stats:days"), DAY_FORMAT);
        statistics.getHistorizedDaysVisits().putAll(lastDaysVisits);
        Map<Date, SpaceVisits> lastMonthVisits = this.getHistorizedVisits(properties.getList("stats:months"), MONTH_FORMAT);
        statistics.getHistorizedMonthsVisits().putAll(lastMonthVisits);
        return statistics;
    }

    private SpaceVisits getVisits(PropertyMap properties, boolean historized) {
        SpaceVisits visits = new SpaceVisits();
        if (properties != null) {
            visits.setHits(NumberUtils.toInt((String)properties.getString("hits")));
            if (historized) {
                visits.setUniqueVisitors(NumberUtils.toInt((String)properties.getString("uniqueVisitors")));
            } else {
                visits.setAnonymousVisitors(NumberUtils.toInt((String)properties.getString("anonymous")));
                PropertyList identifiers = properties.getList("identifiers");
                if (identifiers != null && !identifiers.isEmpty()) {
                    for (int i = 0; i < identifiers.size(); ++i) {
                        String visitor = identifiers.getString(i);
                        visits.getVisitors().add(visitor);
                    }
                }
            }
        }
        return visits;
    }

    private Map<Date, SpaceVisits> getHistorizedVisits(PropertyList list, DateFormat dateFormat) {
        HashMap<Date, Object> historizedVisits;
        if (list == null || list.isEmpty()) {
            historizedVisits = new HashMap<Date, SpaceVisits>(0);
        } else {
            historizedVisits = new HashMap(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Date date;
                PropertyMap map = list.getMap(i);
                try {
                    date = dateFormat.parse(map.getString("date"));
                }
                catch (ParseException e) {
                    date = null;
                }
                if (date == null) continue;
                SpaceVisits visit = this.getVisits(map, true);
                historizedVisits.put(date, visit);
            }
        }
        return historizedVisits;
    }

    public void increments(CMSServiceCtx cmsContext, String path) throws CMSException {
        DefaultCMSCustomizer customizer = (DefaultCMSCustomizer)this.nuxeoService.getCMSCustomizer();
        CustomizationPluginMgr pluginManager = customizer.getPluginManager();
        List<StatisticsModule> modules = pluginManager.getStatisticsModules();
        if (CollectionUtils.isNotEmpty(modules)) {
            ControllerContext controllerContext = cmsContext.getControllerContext();
            PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
            for (StatisticsModule module : modules) {
                try {
                    module.increments(portalControllerContext, path);
                }
                catch (PortalException e) {
                    this.log.error((Object)e.getMessage(), e.getCause());
                }
            }
        }
    }

    public void updateStatistics(CMSServiceCtx cmsContext, HttpSession httpSession, List<SpaceStatistics> spaceStatistics) throws CMSException {
        ControllerContext controllerContext = cmsContext.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        DefaultCMSCustomizer customizer = (DefaultCMSCustomizer)this.nuxeoService.getCMSCustomizer();
        CustomizationPluginMgr pluginManager = customizer.getPluginManager();
        PortletContext portletContext = cmsContext.getPortletCtx();
        NuxeoController nuxeoController = new NuxeoController(portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        UpdateSpaceStatisticsCommand command = new UpdateSpaceStatisticsCommand(httpSession.getId(), spaceStatistics);
        nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        List<StatisticsModule> modules = pluginManager.getStatisticsModules();
        if (CollectionUtils.isNotEmpty(modules)) {
            for (StatisticsModule module : modules) {
                try {
                    module.update(portalControllerContext, httpSession);
                }
                catch (PortalException e) {
                    throw new CMSException((Throwable)e);
                }
            }
        }
    }
}

