/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.editablewindow;

import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindowHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class PictureEditableWindow
extends EditableWindow {
    public static final String PICTURE_FRAGMENT_SCHEMA = "pictfgt:pictureFragment";
    public static final String IMAGE_SOURCE_SCHEMA = "picturePath";
    public static final String TARGET_SCHEMA = "targetPath";

    public PictureEditableWindow(String instance, String prefix) {
        super(instance, prefix);
    }

    public Map<String, String> fillProps(Document document, PropertyMap fragment, Boolean modeEditionPage) {
        Map properties = super.fillGenericProps(document, fragment, modeEditionPage);
        properties.put("osivia.fragmentTypeId", "document_picture");
        properties.put("osivia.propertyName", "file:content");
        PropertyMap propertyMap = EditableWindowHelper.findSchemaByRefURI((Document)document, (String)PICTURE_FRAGMENT_SCHEMA, (String)fragment.getString("uri"));
        properties.put("osivia.cms.uri", propertyMap.getString(IMAGE_SOURCE_SCHEMA));
        properties.put("osivia.targetPath", propertyMap.getString(TARGET_SCHEMA));
        return properties;
    }

    public List<String> prepareDelete(Document document, String refURI) {
        ArrayList<String> properties = new ArrayList<String>();
        this.prepareDeleteGeneric(properties, document, refURI);
        Integer index = EditableWindowHelper.findIndexByRefURI((Document)document, (String)PICTURE_FRAGMENT_SCHEMA, (String)refURI);
        properties.add(PICTURE_FRAGMENT_SCHEMA.concat("/").concat(index.toString()));
        return properties;
    }
}

