/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.core.model.portal.Portal;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.portalobject.bridge.PortalObjectUtils;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.web.IWebIdService;

public class XSLFunctions {
    private static final Log LOGGER = LogFactory.getLog(XSLFunctions.class);
    private static final Pattern PATTERN_RESOURCE = Pattern.compile("/nuxeo/([a-z]*)/default/([a-zA-Z0-9[-]&&[^/]]*)/files:files/([0-9]*)/(.*)");
    private static final Pattern PATTERN_BLOB = Pattern.compile("(/nuxeo/|/nxfile)([a-z]*)/default/([a-zA-Z0-9[-]&&[^/]]*)/blobholder:([0-9]*)/(.*)");
    private static final Pattern PATTERN_PICTURE = Pattern.compile("/nuxeo/nxpicsfile/default/([a-zA-Z0-9[-]&&[^/]]*)/(.*):content/(.*)");
    private static final Pattern PATTERN_WEB_ID = Pattern.compile("/nuxeo/web/([a-zA-Z0-9[-]_/]+).*");
    private static final Pattern PATTERN_INTERNAL_PICTURE = Pattern.compile("/nuxeo/([a-z]*)/default/([a-zA-Z0-9[-]&&[^/]]*)/ttc:images/([0-9]*)/(.*)");
    private static final Pattern NO_DOC_REF_PATTERN_INTERNAL_PICTURE = Pattern.compile("/nuxeo/nxfile/default/attachedImages/ttc:images/([0-9]*)/(.*)");
    private static final Pattern PATTERN_PERMALINK = Pattern.compile("/nuxeo/nxdoc/default/([^/]*)/view_documents(.*)");
    private static final Pattern PATTERN_DOCUMENT = Pattern.compile("/nuxeo/([a-z]*)/default([^@]*)@view_documents(.*)");
    private static final Pattern PATTERN_PORTAL_REF = Pattern.compile("http://([^/:]*)(:[0-9]*)?/([^/]*)(/auth/|/)pagemarker/([0-9]*)/(.*)");
    private static final String PORTAL_REFERENCE = "/portalRef?";
    private static final int PORTAL_REFERENCE_LENGTH = "/portalRef?".length();
    private static String BASE_PATH;
    private final CMSServiceCtx cmsContext;
    private final PortalControllerContext portalControllerContext;
    private final NuxeoController nuxeoController;
    private final List<URI> nuxeoBaseURIs;
    private final IPortalUrlFactory portalURLFactory;
    private final IWebIdService webIdService;
    private final Matcher portalReferenceMatcher;

    public XSLFunctions(INuxeoCustomizer nuxeoCustomizer, CMSServiceCtx cmsContext) {
        this.cmsContext = cmsContext;
        PortletContext portletContext = cmsContext.getPortletCtx();
        PortletRequest request = cmsContext.getRequest();
        MimeResponse response = cmsContext.getResponse();
        this.portalControllerContext = new PortalControllerContext(portletContext, request, (PortletResponse)response);
        this.nuxeoController = new NuxeoController(request, (PortletResponse)response, portletContext);
        this.nuxeoController.setCurrentDoc((Document)cmsContext.getDoc());
        this.nuxeoBaseURIs = this.getNuxeoBaseURIs();
        this.portalURLFactory = (IPortalUrlFactory)Locator.getService(IPortalUrlFactory.class);
        this.webIdService = (IWebIdService)Locator.getService(IWebIdService.class);
        this.portalReferenceMatcher = this.getPortalReferenceMatcher(this.portalURLFactory, this.portalControllerContext);
    }

    private List<URI> getNuxeoBaseURIs() {
        ArrayList<URI> baseURIs = new ArrayList<URI>();
        URI publicBaseURI = NuxeoConnectionProperties.getPublicBaseUri();
        baseURIs.add(publicBaseURI);
        String alternativeServerNames = System.getProperty("nuxeo.alternativeServerNames");
        if (StringUtils.isNotEmpty((String)alternativeServerNames)) {
            String scheme = "http";
            String path = NuxeoConnectionProperties.getNuxeoContext();
            for (String host : StringUtils.split((String)alternativeServerNames, (String)"\\|")) {
                try {
                    URI alternativeBaseURI = new URI(scheme, host, path, null);
                    baseURIs.add(alternativeBaseURI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return baseURIs;
    }

    private Matcher getPortalReferenceMatcher(IPortalUrlFactory portalURLFactory, PortalControllerContext portalControllerContext) {
        String sampleURL = portalURLFactory.getCMSUrl(portalControllerContext, null, "", null, null, null, null, null, null, null);
        Matcher portalReferenceMatcher = PATTERN_PORTAL_REF.matcher(sampleURL);
        return portalReferenceMatcher;
    }

    private int getMaxChars() {
        int maxChars = 0;
        try {
            if (this.cmsContext.getRequest().getAttribute("maxChars") != null) {
                maxChars = Integer.parseInt((String)this.cmsContext.getRequest().getAttribute("maxChars"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maxChars;
    }

    public String wysiwygDisplayMode() {
        String displayMode = "complet";
        if (this.getMaxChars() > 0 && WindowState.NORMAL.equals((Object)this.cmsContext.getRequest().getWindowState())) {
            displayMode = "partiel";
        }
        return displayMode;
    }

    public String maximizedLink() throws WindowStateException {
        PortletURL portletUrl = this.cmsContext.getResponse().createRenderURL();
        portletUrl.setWindowState(WindowState.MAXIMIZED);
        return portletUrl.toString();
    }

    public String link(String link) {
        if (link.startsWith("#")) {
            return link;
        }
        return this.rewrite(link, true);
    }

    public String getBasePath() {
        if (BASE_PATH == null) {
            String link = null;
            try {
                link = this.portalURLFactory.getPermaLink(this.nuxeoController.getPortalCtx(), null, null, "", "cms");
            }
            catch (PortalException portalException) {
                // empty catch block
            }
            BASE_PATH = StringUtils.removeEnd(link, (String)"cms/_ID_/");
        }
        return BASE_PATH;
    }

    private String rewrite(String link, boolean checkScope) {
        try {
            try {
                int iPortalRef = link.indexOf(PORTAL_REFERENCE);
                if (iPortalRef != -1) {
                    String[] paramsArray = link.substring(iPortalRef + PORTAL_REFERENCE_LENGTH).split("&");
                    HashMap<String, String> params = new HashMap<String, String>();
                    for (String element : paramsArray) {
                        String[] values = element.split("=");
                        if (values.length != 2) continue;
                        params.put(values[0], values[1]);
                    }
                    if ("dynamicPage".equals(params.get("type"))) {
                        Portal portal = PortalObjectUtils.getPortal((PortalControllerContext)this.portalControllerContext);
                        String templatePath = (String)params.get("templatePath");
                        if (templatePath.startsWith("/")) {
                            List<String> hierarchy = Arrays.asList(templatePath.split("/"));
                            String ID = "";
                            for (String curHierarchy : hierarchy) {
                                if (ID.length() > 0) {
                                    ID = ID + "_";
                                }
                                ID = ID + curHierarchy.toUpperCase();
                            }
                            String url = this.portalURLFactory.getViewContentUrl(this.portalControllerContext, new UniversalID(portal.getId().getNamespace(), ID));
                            return url;
                        }
                    }
                } else {
                    String rawPath;
                    int indiceRawPath;
                    Matcher mReference = this.portalReferenceMatcher;
                    if (link.startsWith("http://" + mReference.group(1)) && (indiceRawPath = link.indexOf("/", 7)) != -1 && (rawPath = link.substring(indiceRawPath)).length() > 1 && rawPath.substring(1).startsWith(mReference.group(3))) {
                        return this.transformPortalURL(link, mReference);
                    }
                }
            }
            catch (Exception iPortalRef) {
                // empty catch block
            }
            if (!link.startsWith("http") && !link.startsWith(NuxeoConnectionProperties.getNuxeoContext())) {
                return link;
            }
            String trim = link.trim().replace(" ", "%20");
            for (URI baseURI : this.nuxeoBaseURIs) {
                URI url = baseURI.resolve(trim);
                if (url.getScheme() != null && !url.getScheme().equals("http") && !url.getScheme().equals("https") || url.getHost() != null && !url.getHost().equals(baseURI.getHost())) continue;
                String query = url.getRawPath();
                Matcher mRes = PATTERN_RESOURCE.matcher(query);
                if (mRes.matches() && mRes.groupCount() > 0) {
                    String uid = mRes.group(2);
                    if (this.cmsContext.getDoc() != null) {
                        uid = ((Document)this.cmsContext.getDoc()).getId();
                    }
                    String fileIndex = mRes.group(3);
                    return this.nuxeoController.createAttachedFileLink(uid, fileIndex);
                }
                Matcher mResInternalPicture = PATTERN_INTERNAL_PICTURE.matcher(query);
                if (mResInternalPicture.matches() && mResInternalPicture.groupCount() > 0) {
                    String uid = this.cmsContext.getDoc() == null ? mResInternalPicture.group(2) : ((Document)this.cmsContext.getDoc()).getId();
                    String pictureIndex = mResInternalPicture.group(3);
                    String fileName = StringUtils.substringAfterLast((String)mResInternalPicture.group(4), (String)"/");
                    return this.nuxeoController.createAttachedPictureLink(uid, pictureIndex, fileName);
                }
                Matcher mResSAInternalPicture = NO_DOC_REF_PATTERN_INTERNAL_PICTURE.matcher(query);
                if (mResSAInternalPicture.matches() && mResSAInternalPicture.groupCount() > 0 && this.cmsContext.getDoc() != null) {
                    String uid = ((Document)this.cmsContext.getDoc()).getId();
                    String pictureIndex = mResSAInternalPicture.group(1);
                    String fileName = StringUtils.substringAfterLast((String)mResInternalPicture.group(2), (String)"/");
                    return this.nuxeoController.createAttachedPictureLink(uid, pictureIndex, fileName);
                }
                Matcher mPictures = PATTERN_PICTURE.matcher(query);
                if (mPictures.matches() && mPictures.groupCount() > 0) {
                    String uid = mPictures.group(1);
                    String content = mPictures.group(2);
                    return this.nuxeoController.createPictureLink(uid, content);
                }
                Matcher mDoc = PATTERN_DOCUMENT.matcher(query);
                if (mDoc.matches()) {
                    if (mDoc.groupCount() > 0) {
                        String path = mDoc.group(2);
                        String parameters = url.getQuery();
                        if (StringUtils.isNotBlank((String)parameters)) {
                            path = path.concat("?").concat(parameters);
                        }
                        String portalLink = this.nuxeoController.getCMSLinkByPath(path, null).getUrl();
                        return portalLink;
                    }
                    return url.toString();
                }
                Matcher permaDoc = PATTERN_PERMALINK.matcher(query);
                if (permaDoc.matches()) {
                    if (permaDoc.groupCount() > 0) {
                        String id = permaDoc.group(1);
                        return this.nuxeoController.getCMSLinkByPath(id, null).getUrl();
                    }
                    return url.toString();
                }
                Matcher mBlobExp = PATTERN_BLOB.matcher(query);
                if (mBlobExp.matches() && mBlobExp.groupCount() > 0) {
                    String uid = mBlobExp.group(3);
                    String blobIndex = mBlobExp.group(4);
                    String fileName = mBlobExp.group(5);
                    return this.nuxeoController.createAttachedBlobLink(uid, blobIndex, fileName);
                }
                Matcher mWebId = PATTERN_WEB_ID.matcher(query);
                if (mWebId.matches() && mWebId.groupCount() > 0) {
                    String webPath = mWebId.group(1);
                    String webId = webPath.contains("/") ? StringUtils.substringAfterLast((String)webPath, (String)"/") : webPath;
                    String params = url.getQuery();
                    String displayContext = null;
                    if (params != null) {
                        String[] split;
                        for (String element : split = params.split("&")) {
                            String[] param = element.split("=");
                            if (StringUtils.equals((String)param[0], (String)"content")) {
                                String fetchPath = this.webIdService.webIdToFetchPath(webId);
                                return this.nuxeoController.createPictureLink(fetchPath, param[1]);
                            }
                            if (!StringUtils.equals((String)param[0], (String)"display")) continue;
                            displayContext = param[1];
                        }
                    }
                    return this.nuxeoController.getLinkFromNuxeoURL(query, displayContext).getUrl();
                }
                return url.toString();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Link " + link + "generates " + e.getMessage()));
        }
        return link;
    }

    private String transformPortalURL(String originalUrl, Matcher referenceMatcher) throws Exception {
        Pattern expOrginial = Pattern.compile("http://([^/:]*)(:[0-9]*)?/" + referenceMatcher.group(3) + "(/auth/|/)((pagemarker/[0-9]*/)?)(.*)");
        Matcher mResOriginal = expOrginial.matcher(originalUrl);
        if (!mResOriginal.matches()) {
            throw new Exception("Not a portal URL !!!");
        }
        String transformedUrl = "";
        transformedUrl = "http://" + mResOriginal.group(1);
        if (StringUtils.isNotEmpty((String)mResOriginal.group(2))) {
            transformedUrl = transformedUrl + mResOriginal.group(2);
        }
        transformedUrl = transformedUrl + "/" + referenceMatcher.group(3);
        transformedUrl = transformedUrl + referenceMatcher.group(4);
        transformedUrl = transformedUrl + "pagemarker/";
        transformedUrl = transformedUrl + referenceMatcher.group(5) + '/';
        transformedUrl = transformedUrl + mResOriginal.group(6);
        return transformedUrl;
    }

    public String thumbnailSource(String imageSource) {
        String thumbnailSource;
        Pattern pattern = Pattern.compile("^(.*\\?(.*&)?)content=([A-Za-z]+)(&.*)?$");
        Matcher matcher = pattern.matcher(imageSource);
        if (matcher.matches()) {
            StringBuilder builder = new StringBuilder();
            builder.append(matcher.group(1));
            builder.append("content=Original");
            builder.append(StringUtils.trimToEmpty((String)matcher.group(4)));
            thumbnailSource = builder.toString();
        } else {
            thumbnailSource = imageSource;
        }
        return this.link(thumbnailSource);
    }

    public String thumbnailClasses(String styles) {
        String classes;
        if (StringUtils.isEmpty((String)styles)) {
            classes = "";
        } else {
            StringBuilder builder = new StringBuilder();
            HashMap<String, String> properties = new HashMap<String, String>();
            for (String style : StringUtils.split((String)styles, (String)";")) {
                String[] property = StringUtils.split((String)style, (String)":");
                if (property.length != 2) continue;
                String key = StringUtils.lowerCase((String)StringUtils.trim((String)property[0]));
                String value = StringUtils.lowerCase((String)StringUtils.trim((String)property[1]));
                properties.put(key, value);
            }
            String floatValue = (String)properties.get("float");
            if ("left".equals(floatValue)) {
                builder.append("pull-left ");
            } else if ("right".equals(floatValue)) {
                builder.append("pull-right ");
            }
            classes = builder.toString();
        }
        return classes;
    }
}

