/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.move;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.BrowserAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.files.MoveDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.move.RemoveAllPermissionsCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.RequestPublishStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentState;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;

public class MoveDocumentPortlet
extends CMSPortlet {
    public static final String DOCUMENT_PATH_WINDOW_PROPERTY = "osivia.move.documentPath";
    public static final String DOCUMENTS_IDENTIFIERS_WINDOW_PROPERTY = "osivia.move.documentsIdentifiers";
    public static final String IGNORED_PATHS_WINDOW_PROPERTY = "osivia.move.ignoredPaths";
    public static final String CMS_BASE_PATH_WINDOW_PROPERTY = "osivia.move.cmsBasePath";
    public static final String ACCEPTED_TYPES_WINDOW_PROPERTY = "osivia.move.acceptedTypes";
    private static final String SPACE_PATH_REQUEST_PARAMETER = "osivia.move.spacePath";
    private static final String MODE_REQUEST_PARAMETER = "osivia.move.mode";
    private static final String VIEW_PATH = "/WEB-INF/jsp/move/view.jsp";
    private static final String CHANGE_SPACE_PATH = "/WEB-INF/jsp/move/change-space.jsp";
    private final INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
    private final DocumentDAO documentDAO = DocumentDAO.getInstance();

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String ignoredPaths;
        CMSItem cmsItem;
        CMSItem navigationItem;
        String documentPath;
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setDisplayLiveVersion(RequestPublishStatus.live.getStatus());
        DefaultCMSCustomizer cmsCustomizer = (DefaultCMSCustomizer)this.nuxeoService.getCMSCustomizer();
        BrowserAdapter browserAdapter = cmsCustomizer.getBrowserAdapter();
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String basePath = request.getParameter(SPACE_PATH_REQUEST_PARAMETER);
        if (basePath == null) {
            basePath = window.getProperty(CMS_BASE_PATH_WINDOW_PROPERTY);
        }
        if (basePath != null) {
            basePath = nuxeoController.getComputedPath(basePath);
            Document space = this.getRootDocument(cmsContext, basePath);
            basePath = space.getPath();
            DocumentDTO spaceDto = this.documentDAO.toDTO(space);
            request.setAttribute("spaceDocument", (Object)spaceDto);
            request.setAttribute("cmsBasePath", (Object)basePath);
        }
        if ((documentPath = window.getProperty(DOCUMENT_PATH_WINDOW_PROPERTY)) == null) {
            navigationItem = null;
        } else {
            try {
                navigationItem = cmsService.getPortalNavigationItem(cmsContext, basePath, documentPath);
                if (navigationItem == null) {
                    CMSObjectPath objectPath = CMSObjectPath.parse((String)documentPath);
                    CMSObjectPath parentObjectPath = objectPath.getParent();
                    navigationItem = cmsService.getPortalNavigationItem(cmsContext, basePath, parentObjectPath.toString());
                }
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
        }
        if (navigationItem != null) {
            String navigationPath = navigationItem.getNavigationPath();
            request.setAttribute("cmsNavigationPath", (Object)navigationPath);
        }
        if (navigationItem != null && StringUtils.equals((String)documentPath, (String)navigationItem.getNavigationPath())) {
            cmsItem = navigationItem;
        } else if (StringUtils.isNotEmpty((String)documentPath)) {
            try {
                cmsItem = cmsService.getContent(cmsContext, documentPath);
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
        } else {
            cmsItem = null;
        }
        if (cmsItem != null) {
            DocumentType documentType = cmsItem.getType();
            boolean enableSpaceChange = documentType != null && !documentType.isFolderish();
            request.setAttribute("enableSpaceChange", (Object)enableSpaceChange);
        }
        if ((ignoredPaths = window.getProperty(IGNORED_PATHS_WINDOW_PROPERTY)) == null) {
            ignoredPaths = documentPath;
        }
        request.setAttribute("ignoredPaths", (Object)ignoredPaths);
        String acceptedTypes = window.getProperty(ACCEPTED_TYPES_WINDOW_PROPERTY);
        request.setAttribute("acceptedTypes", (Object)acceptedTypes);
        String excludedTypes = StringUtils.startsWith((String)basePath, (String)browserAdapter.getUserWorkspacesPath()) ? browserAdapter.getUserWorkspacesType() : null;
        request.setAttribute("excludedTypes", (Object)excludedTypes);
        String error = request.getParameter("error");
        request.setAttribute("error", (Object)error);
        String dispatcherPath = "space".equals(request.getParameter(MODE_REQUEST_PARAMETER)) ? CHANGE_SPACE_PATH : VIEW_PATH;
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(dispatcherPath).include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        block13: {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            nuxeoController.setDisplayLiveVersion(DocumentState.LIVE.toString());
            PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            Bundle bundle = this.getBundleFactory().getBundle(request.getLocale());
            String action = request.getParameter("javax.portlet.action");
            if ("move".equals(action)) {
                String targetPath = request.getParameter("targetPath");
                if (StringUtils.isBlank((String)targetPath)) {
                    response.setRenderParameter("error", "emptyTargetPath");
                } else {
                    String redirectionPath;
                    List<String> sourceIds;
                    String path = window.getProperty(DOCUMENT_PATH_WINDOW_PROPERTY);
                    String basePath = window.getProperty(CMS_BASE_PATH_WINDOW_PROPERTY);
                    CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
                    NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
                    Document document = documentContext.getDocument();
                    String[] identifiersProperty = StringUtils.split((String)window.getProperty(DOCUMENTS_IDENTIFIERS_WINDOW_PROPERTY), (String)",");
                    if (identifiersProperty == null) {
                        sourceIds = new ArrayList<String>(1);
                        sourceIds.add(document.getId());
                    } else {
                        sourceIds = Arrays.asList(identifiersProperty);
                    }
                    NuxeoDocumentContext targetDocumentContext = nuxeoController.getDocumentContext(targetPath);
                    NuxeoPublicationInfos targetPublicationInfos = targetDocumentContext.getPublicationInfos();
                    String targetId = targetPublicationInfos.getLiveId();
                    if (identifiersProperty == null) {
                        CMSObjectPath parentPath = CMSObjectPath.parse((String)document.getPath()).getParent();
                        redirectionPath = parentPath.toString();
                    } else {
                        redirectionPath = document.getPath();
                    }
                    Object command = new MoveDocumentCommand(sourceIds, targetId);
                    try {
                        nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                        Document sourceRoot = this.getRootDocument(cmsContext, basePath);
                        Document targetRoot = this.getRootDocument(cmsContext, targetPath);
                        if (!StringUtils.equals((String)sourceRoot.getPath(), (String)targetRoot.getPath())) {
                            command = new RemoveAllPermissionsCommand(sourceIds);
                            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                        }
                        String redirectionURL = this.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, redirectionPath, null, null, "refreshPageAndNavigation", null, null, null, null);
                        request.setAttribute("osivia.redirection.url", (Object)redirectionURL);
                        String message = sourceIds.size() == 1 ? bundle.getString("DOCUMENT_MOVE_SUCCESS_MESSAGE") : bundle.getString("DOCUMENTS_MOVE_SUCCESS_MESSAGE", new Object[]{sourceIds.size()});
                        this.getNotificationsService().addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
                    }
                    catch (NuxeoException e) {
                        if (1 == e.getErrorCode()) {
                            response.setRenderParameter("error", "403");
                            break block13;
                        }
                        String message = bundle.getString("DOCUMENT_MOVE_ERROR_MESSAGE");
                        this.getNotificationsService().addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
                    }
                }
            } else if ("changeSpace".equals(action)) {
                String spacePath = request.getParameter("spacePath");
                response.setRenderParameter(SPACE_PATH_REQUEST_PARAMETER, spacePath);
            }
        }
    }

    private Document getRootDocument(CMSServiceCtx cmsContext, String basePath) throws PortletException {
        ICMSService cmsService = NuxeoController.getCMSService();
        Document currentSpace = null;
        Document root = null;
        String path = basePath;
        while (root == null && StringUtils.isNotEmpty((String)path)) {
            DocumentType spaceType;
            CMSItem spaceConfig;
            try {
                spaceConfig = cmsService.getSpaceConfig(cmsContext, path);
            }
            catch (CMSException e) {
                throw new PortletException((Throwable)e);
            }
            if (currentSpace == null) {
                currentSpace = (Document)spaceConfig.getNativeItem();
            }
            if ((spaceType = spaceConfig.getType()) != null && spaceType.isRoot()) {
                root = (Document)spaceConfig.getNativeItem();
            }
            CMSObjectPath objectPath = CMSObjectPath.parse((String)path);
            CMSObjectPath parentObjectPath = objectPath.getParent();
            path = parentObjectPath.toString();
        }
        if (root == null) {
            root = currentSpace;
        }
        return root;
    }
}

