/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.forms;

import com.sun.mail.smtp.SMTPTransport;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.portlets.forms.FormsServiceImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetTasksCommand;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.Name;
import javax.portlet.PortletContext;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Group;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.tasks.ITasksService;
import org.osivia.portal.api.transaction.IPostcommitResource;

public class ProcedureSendMailModule
implements IPostcommitResource {
    PortalControllerContext portalControllerContext;
    PortletContext portletContext;
    IBundleFactory bundleFactory;
    String procedureInstanceId;
    String initiator;
    private final PersonService personService;
    private final GroupService groupService;
    private final FormsServiceImpl formsService;
    private final ITasksService tasksService;
    private static final Log log = LogFactory.getLog(ProcedureSendMailModule.class);
    private static final Log procLogger = LogFactory.getLog((String)"procedures");

    ProcedureSendMailModule(PortalControllerContext portalControllerContext, PortletContext portletContext, FormsServiceImpl formsService, String procedureInstanceId, String initiator) {
        this.portalControllerContext = portalControllerContext;
        this.portletContext = portletContext;
        this.formsService = formsService;
        this.procedureInstanceId = procedureInstanceId;
        this.initiator = initiator;
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.personService = (PersonService)DirServiceFactory.getService(PersonService.class);
        this.groupService = (GroupService)DirServiceFactory.getService(GroupService.class);
        this.tasksService = (ITasksService)Locator.findMBean(ITasksService.class, (String)"osivia:service=TasksService");
    }

    public void run() {
        try {
            Locale locale = null;
            if (this.portalControllerContext.getHttpServletRequest() != null) {
                locale = this.portalControllerContext.getHttpServletRequest().getLocale();
            }
            NuxeoController nuxeoController = new NuxeoController(this.portletContext);
            nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
            nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            Bundle bundle = this.bundleFactory.getBundle(locale);
            if (StringUtils.isNotEmpty((String)this.procedureInstanceId)) {
                PropertyList actors;
                UUID uuid = UUID.fromString(this.procedureInstanceId);
                GetTasksCommand command = new GetTasksCommand(null, null, uuid);
                Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                if (documents.size() != 1) {
                    throw new Exception("task not found");
                }
                Document task = documents.get(0);
                PropertyMap variables = task.getProperties().getMap("nt:task_variables");
                if (BooleanUtils.isTrue((Boolean)variables.getBoolean("notifEmail")) && !(actors = task.getProperties().getList("nt:actors")).isEmpty()) {
                    HashSet<Name> names = new HashSet<Name>(actors.size());
                    for (int i = 0; i < actors.size(); ++i) {
                        String actor = actors.getString(i);
                        Group group = StringUtils.startsWith((String)actor, (String)"user:") ? null : (StringUtils.startsWith((String)actor, (String)"group:") ? this.groupService.get(StringUtils.removeStart((String)actor, (String)"group:")) : this.groupService.get(actor));
                        if (group == null) {
                            String user = StringUtils.removeStart((String)actor, (String)"user:");
                            names.add(this.personService.getEmptyPerson().buildDn(user));
                            continue;
                        }
                        for (Name member : group.getMembers()) {
                            names.add(member);
                        }
                    }
                    HashSet<String> emailRecipients = new HashSet<String>(names.size());
                    for (Name name : names) {
                        String email;
                        Person person = this.personService.getPerson(name);
                        if (person == null || !StringUtils.isNotBlank((String)(email = person.getMail()))) continue;
                        emailRecipients.add(email);
                    }
                    if (!emailRecipients.isEmpty()) {
                        String acceptActionId;
                        Person sender = this.personService.getPerson(this.initiator);
                        String emailSender = StringUtils.defaultIfBlank((String)sender.getMail(), (String)this.initiator);
                        String expression = variables.getString("stringMsg");
                        Session mailSession = Session.getInstance((Properties)System.getProperties(), null);
                        MimeMessage message = new MimeMessage(mailSession);
                        message.setSentDate(new Date());
                        InternetAddress from = new InternetAddress(emailSender);
                        message.setFrom((Address)from);
                        InternetAddress[] to = InternetAddress.parse((String)StringUtils.join(emailRecipients, (String)","));
                        message.setRecipients(Message.RecipientType.TO, (Address[])to);
                        InternetAddress[] replyTo = new InternetAddress[]{from};
                        message.setReplyTo((Address[])replyTo);
                        String subject = StringUtils.substringBefore((String)this.formsService.transform(this.portalControllerContext, expression, task, true), (String)System.lineSeparator());
                        message.setSubject(subject, "UTF-8");
                        String inlineBody = this.formsService.transform(this.portalControllerContext, expression, task, false);
                        StringBuilder body = new StringBuilder();
                        for (String line : StringUtils.split((String)inlineBody, (String)System.lineSeparator())) {
                            body.append("<p>");
                            body.append(line);
                            body.append("</p>");
                        }
                        if (BooleanUtils.isTrue((Boolean)variables.getBoolean("acquitable")) && StringUtils.isNotBlank((String)(acceptActionId = variables.getString("actionIdYes")))) {
                            String url = this.tasksService.getCommandUrl(this.portalControllerContext, uuid, acceptActionId);
                            String title = bundle.getString("ACCEPT");
                            Element link = DOM4JUtils.generateLinkElement((String)url, null, null, null, (String)title);
                            body.append("<p>");
                            body.append(DOM4JUtils.writeCompact((Element)link));
                            body.append("</p>");
                        }
                        MimeMultipart multipart = new MimeMultipart();
                        MimeBodyPart htmlPart = new MimeBodyPart();
                        htmlPart.setContent((Object)body.toString(), "text/html; charset=UTF-8");
                        multipart.addBodyPart((BodyPart)htmlPart);
                        message.setContent((Multipart)multipart);
                        procLogger.info((Object)("  About to send mail on " + uuid + " from " + emailSender + " to " + StringUtils.join(emailRecipients, (String)",") + " subject " + subject));
                        SMTPTransport transport = (SMTPTransport)mailSession.getTransport();
                        transport.connect();
                        transport.sendMessage((Message)message, message.getAllRecipients());
                        transport.close();
                        procLogger.info((Object)("  Mail sentl on " + uuid));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Email sending error - messaging", e.getCause());
        }
    }
}

