/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.spi.StreamedSession;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.nuxeo.ecm.automation.client.model.StreamBlob;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class FileContentCommand
implements INuxeoCommand {
    public static final String PDF_CONTENT = "pdf:content";
    public static final String PDF_CONVERSION_ERROR = "errorOnPdfConversion";
    Document document;
    String docPath;
    String fieldName;
    String timestamp;
    boolean streamingSupport = false;

    public FileContentCommand(Document document, String fieldName) {
        this.document = document;
        this.docPath = null;
        this.fieldName = fieldName;
    }

    public FileContentCommand(String docPath, String fieldName) {
        this.document = null;
        this.docPath = docPath;
        this.fieldName = fieldName;
    }

    public void setStreamingSupport(boolean streamingSupport) {
        this.streamingSupport = streamingSupport;
    }

    public static PropertyMap getFileMap(Document nuxeoDocument, String fieldName) {
        PropertyMap map = null;
        if (fieldName.contains("/")) {
            PropertyMap descFileMap;
            String[] tokens = fieldName.split("/");
            int index = Integer.parseInt(tokens[1]);
            PropertyList files = nuxeoDocument.getProperties().getList(tokens[0]);
            if (files != null && files.size() > index && (descFileMap = files.getMap(index)) != null) {
                map = descFileMap.getMap(tokens[2]);
                map.set("filename", descFileMap.getString("filename"));
            }
        } else {
            map = nuxeoDocument.getProperties().getMap(fieldName);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Session session) throws Exception {
        FileBlob fileBlob;
        if (this.document == null) {
            this.document = (Document)session.newRequest("Document.Fetch").setHeader("X-NXDocumentProperties", "*").set("value", (Object)this.docPath).execute();
        }
        if (StringUtils.equals((String)this.fieldName, (String)PDF_CONTENT)) {
            fileBlob = (FileBlob)session.newRequest("Blob.AnyToPDF").setInput((OperationInput)this.document).execute();
        } else {
            PropertyMap map = FileContentCommand.getFileMap(this.document, this.fieldName);
            String pathFile = map.getString("data");
            if (this.streamingSupport) {
                String url = null;
                url = NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_60) ? pathFile : session.getClient().getBaseUrl() + pathFile;
                StreamBlob blob = (StreamBlob)((StreamedSession)session).getStreamedFile(url);
                CMSBinaryContent content = new CMSBinaryContent();
                String fileName = blob.getFileName();
                if ("file".equals(fileName)) {
                    fileName = map.getString("filename");
                }
                if (fileName == null || "null".equals(fileName)) {
                    fileName = this.document.getTitle();
                }
                Long length = map.getLong("length");
                content.setName(fileName);
                content.setFileSize(length);
                content.setMimeType(blob.getMimeType());
                content.setStream(blob.getStream());
                content.setLongLiveSession((Object)session);
                return content;
            }
            fileBlob = (FileBlob)session.getFile(pathFile);
        }
        FileInputStream in = new FileInputStream(fileBlob.getFile());
        File tempFile = File.createTempFile("tempFile", ".tmp");
        tempFile.deleteOnExit();
        CountingOutputStream cout = new CountingOutputStream((OutputStream)new FileOutputStream(tempFile));
        try {
            byte[] b = new byte[1000000];
            int i = -1;
            while ((i = ((InputStream)in).read(b)) != -1) {
                cout.write(b, 0, i);
            }
            cout.flush();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)cout);
        }
        fileBlob.getFile().delete();
        CMSBinaryContent content = new CMSBinaryContent();
        String fileName = fileBlob.getFileName();
        if (fileName == null || "null".equals(fileName)) {
            fileName = this.document.getTitle();
        }
        content.setName(fileName);
        content.setFile(tempFile);
        content.setMimeType(fileBlob.getMimeType());
        content.setFileSize(Long.valueOf(cout.getByteCount()));
        return content;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getId() {
        String id = "FileContentCommand";
        id = this.document == null ? id + this.docPath : id + this.document;
        if (this.timestamp != null) {
            id = id + this.timestamp;
        }
        id = id + "/" + this.fieldName;
        return id;
    }
}

