/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.reorder;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.files.SortDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.RequestPublishStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;

public class ReorderDocumentsPortlet
extends CMSPortlet {
    public static final String PATH_WINDOW_PROPERTY = "osivia.reorder.path";
    private static final String VIEW_PATH = "/WEB-INF/jsp/reorder/view.jsp";
    private DocumentDAO documentDAO;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.documentDAO = DocumentDAO.getInstance();
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        List children;
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setDisplayLiveVersion(RequestPublishStatus.live.getStatus());
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(PATH_WINDOW_PROPERTY);
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        NuxeoPublicationInfos publicationInfos = documentContext.getPublicationInfos();
        Document parent = documentContext.getDocument();
        cmsContext.setDisplayLiveVersion(RequestPublishStatus.live.getStatus());
        if (!publicationInfos.isLiveSpace() && StringUtils.isNotBlank((String)publicationInfos.getSpacePath())) {
            cmsContext.setDisplayLiveVersion(RequestPublishStatus.liveNRemotePublished.getStatus());
        }
        String parentTitle = parent.getTitle();
        request.setAttribute("parentTitle", (Object)parentTitle);
        try {
            children = cmsService.getPortalSubitems(cmsContext, path);
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
        ArrayList<DocumentDTO> documentsDTO = new ArrayList<DocumentDTO>(children.size());
        for (CMSItem child : children) {
            Document document = (Document)child.getNativeItem();
            DocumentDTO documentDTO = this.documentDAO.toDTO(portalControllerContext, document);
            documentsDTO.add(documentDTO);
        }
        request.setAttribute("documents", documentsDTO);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(VIEW_PATH).include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(PATH_WINDOW_PROPERTY);
        String action = request.getParameter("javax.portlet.action");
        if ("reorder".equals(action)) {
            String orderParameter = request.getParameter("order");
            String[] order = StringUtils.split((String)orderParameter, (String)"|");
            for (int i = order.length - 1; i >= 0; --i) {
                String sourceId = order[i];
                String targetId = i == order.length - 1 ? null : order[i + 1];
                SortDocumentCommand command = new SortDocumentCommand(sourceId, targetId);
                nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            }
            String redirectionURL = this.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, path, null, null, "refreshPageAndNavigation", null, null, null, null);
            request.setAttribute("osivia.redirection.url", (Object)redirectionURL);
        }
    }
}

