/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.search;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.list.NXQLFormater;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;

public class SearchCommand
implements INuxeoCommand {
    String path;
    String keywords;
    int pageNumber;
    NXQLFormater formatter;
    NuxeoQueryFilterContext queryCtx;

    public SearchCommand(NuxeoQueryFilterContext queryCtx, String path, String keywords, int pageNumber) {
        this.queryCtx = queryCtx;
        this.path = path;
        this.keywords = keywords;
        this.pageNumber = pageNumber;
        this.formatter = new NXQLFormater();
    }

    private String addClause(String request, String clause) {
        String result = request;
        if (StringUtils.isNotEmpty((String)request)) {
            result = result + " AND ";
        }
        result = result + clause;
        return result;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = this.generateESRequest(nuxeoSession);
        String searchQuery = "";
        if (this.path != null && this.path.length() > 0) {
            searchQuery = this.addClause(searchQuery, "ecm:path STARTSWITH '" + this.path + "'");
        }
        if (StringUtils.isNotBlank((String)this.keywords)) {
            searchQuery = this.addClause(searchQuery, this.formatter.formatAdvancedSearch(this.keywords));
        }
        String filteredRequest = NuxeoQueryFilter.addSearchFilter((NuxeoQueryFilterContext)this.queryCtx, (String)searchQuery);
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        PaginableDocuments result = (PaginableDocuments)request.execute();
        return result;
    }

    protected OperationRequest generateESRequest(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.QueryES");
        request.set("pageSize", (Object)10);
        request.set("currentPageIndex", (Object)this.pageNumber);
        request.set("X-NXDocumentProperties", (Object)CMSCustomizer.getSearchSchema());
        return request;
    }

    public String getId() {
        return "SearchCommand" + this.path + "/" + this.keywords;
    }
}

