/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class GetTasksCommand
implements INuxeoCommand {
    private final String actors;
    private final Boolean notifiable;
    private final String directives;
    private final String path;
    private final UUID uuid;

    public GetTasksCommand(Set<String> actors, boolean notifiable, Set<String> directives) {
        this(actors, notifiable, directives, null, null);
    }

    public GetTasksCommand(Set<String> actors, String path, UUID uuid) {
        this(actors, null, null, path, uuid);
    }

    private GetTasksCommand(Set<String> actors, Boolean notifiable, Set<String> directives, String path, UUID uuid) {
        this.actors = this.getStringValues(actors);
        this.notifiable = notifiable;
        this.directives = this.getStringValues(directives);
        this.path = path;
        this.uuid = uuid;
    }

    private String getStringValues(Collection<String> values) {
        String result;
        if (values == null) {
            result = null;
        } else {
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("'");
                builder.append(value);
                builder.append("'");
            }
            result = builder.toString();
        }
        return result;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document ");
        query.append("WHERE ecm:primaryType = 'TaskDoc' ");
        query.append("AND ecm:currentLifeCycleState = 'opened' ");
        if (this.actors != null) {
            query.append("AND nt:actors/* IN (").append(this.actors).append(") ");
        }
        if (this.notifiable != null || this.directives != null) {
            query.append("AND (");
            if (this.notifiable != null) {
                query.append("nt:task_variables.notifiable = '").append(this.notifiable).append("'");
                if (this.directives != null) {
                    query.append(" OR ");
                }
            }
            if (this.directives != null) {
                query.append("nt:directive IN (").append(this.directives).append(")");
            }
            query.append(") ");
        }
        if (this.path != null) {
            query.append("AND ecm:path = '").append(this.path).append("' ");
        }
        if (this.uuid != null) {
            query.append("AND nt:pi.pi:globalVariablesValues.uuid = '").append(this.uuid).append("' ");
        }
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore, task");
        request.set("query", (Object)query.toString());
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("/");
        builder.append(this.actors);
        builder.append("/");
        builder.append(this.notifiable);
        builder.append("/");
        builder.append(this.directives);
        builder.append("/");
        builder.append(this.path);
        builder.append("/");
        builder.append(this.uuid);
        return builder.toString();
    }
}

