/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.sharing;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class ResolveSharingLinkCommand
implements INuxeoCommand {
    private static final String OPERATION_ID = "Document.UpdateSharingPermissions";
    private static final String AUTHOR_PROPERTY = "sharing:author";
    private final String id;
    private final String user;

    public ResolveSharingLinkCommand(String id, String user) {
        this.id = id;
        this.user = user;
    }

    public Document execute(Session nuxeoSession) throws Exception {
        Document document = this.getTargetDocument(nuxeoSession);
        if (document != null && !StringUtils.equals((String)this.user, (String)document.getString(AUTHOR_PROPERTY))) {
            this.updatePermissions(nuxeoSession, document);
        }
        return document;
    }

    private Document getTargetDocument(Session nuxeoSession) throws Exception {
        StringBuilder nxqlRequest = new StringBuilder();
        nxqlRequest.append("sharing:linkId = '").append(this.id).append("' ");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, (String)nxqlRequest.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"*");
        request.set("query", (Object)filteredRequest);
        Documents documents = (Documents)request.execute();
        Document document = documents == null || documents.isEmpty() || documents.size() > 1 ? null : (Document)documents.iterator().next();
        return document;
    }

    private void updatePermissions(Session nuxeoSession, Document document) throws Exception {
        String linkPermission = document.getString("sharing:linkPermission", "Read");
        OperationRequest request = nuxeoSession.newRequest(OPERATION_ID);
        request.setInput((OperationInput)document);
        request.set("permission", (Object)linkPermission);
        if (StringUtils.isNotEmpty((String)this.user)) {
            request.set("user", (Object)this.user);
        }
        request.set("add", (Object)true);
        request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("/");
        builder.append(this.id);
        builder.append("/");
        builder.append(this.user);
        return builder.toString();
    }
}

