/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.automation.client.Session;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class StreamingServlet
extends HttpServlet {
    private static final long serialVersionUID = 9089991326380332372L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamBigFile(InputStream inputStream, OutputStream outputStream, int bufSize) throws IOException {
        try {
            byte[] b = new byte[bufSize];
            int bytesread = 0;
            int bytesBuffered = 0;
            while ((bytesread = inputStream.read(b)) != -1) {
                outputStream.write(b, 0, bytesread);
                if ((bytesBuffered += bytesread) <= 0x100000) continue;
                bytesBuffered = 0;
            }
            outputStream.flush();
        }
        finally {
            inputStream.close();
        }
    }

    public void doGet(HttpServletRequest theRequest, HttpServletResponse theResponse) throws IOException, ServletException {
        ServletOutputStream output = theResponse.getOutputStream();
        CMSBinaryContent content = null;
        try {
            String idLargeFile = theRequest.getParameter("idLargeFile");
            if (idLargeFile != null && (content = (CMSBinaryContent)CMSBinaryContent.largeFile.get(idLargeFile)) != null) {
                theResponse.setContentType(content.getMimeType());
                theResponse.setHeader("Content-Disposition", "attachment; filename=\"" + content.getName() + "\"");
                theResponse.setBufferSize(8192);
                StreamingServlet.streamBigFile(content.getStream(), (OutputStream)output, 8192);
                CMSBinaryContent.largeFile.remove(idLargeFile);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            output.close();
            ((Session)content.getLongLiveSession()).close();
        }
    }
}

