/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class WebConfigurationQueryCommand
implements INuxeoCommand {
    public static final String BASIC_NAVIGATION_SCHEMAS = "dublincore, common, toutatice, webconfiguration";
    private String domainPath;
    private WebConfigurationType type;

    public WebConfigurationQueryCommand(String domainPath, WebConfigurationType type) {
        this.domainPath = domainPath;
        this.type = type;
    }

    public Object execute(Session session) throws Exception {
        OperationRequest request;
        if (NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_60)) {
            request = session.newRequest("Context.GetWebConfigurations");
            request.set("domainPath", (Object)this.domainPath);
            request.set("confType", (Object)this.type.getTypeName());
        } else {
            request = session.newRequest("Document.Query");
            StringBuilder builder = new StringBuilder();
            builder.append("SELECT * FROM Document WHERE ( ecm:path STARTSWITH '");
            builder.append(this.domainPath);
            builder.append("' AND (wconf:type = '");
            builder.append(this.type.getTypeName());
            builder.append("') AND (wconf:enabled=1)) ORDER BY wconf:order");
            request.set("query", (Object)builder.toString());
        }
        request.setHeader("X-NXDocumentProperties", BASIC_NAVIGATION_SCHEMAS);
        return request.execute();
    }

    public String getId() {
        return "WebConfigurationQueryCommand/" + this.domainPath + "/" + this.type.toString();
    }

    public static enum WebConfigurationType {
        CMS_NAVIGATION_ADAPTER("CMSNavigationAdapter"),
        CMS_PLAYER("CMSPlayer"),
        CMS_TO_WEB_PATH_ADAPTER("CMSToWebPathAdapter"),
        EXTRA_REQUEST_FILTER("extraRequestFilter"),
        REGION_LAYOUT("regionlayout");

        private final String typeName;

        private WebConfigurationType(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

