/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.selectors;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class VocabSelectorPortlet
extends CMSPortlet {
    public static final String OTHER_ENTRIES_CHOICE = "othersVocabEntries";
    private static final String SELECTOR_ID_WINDOW_PROPERTY = "osivia.selectorId";
    private static final String SELECTOR_LABEL_WINDOW_PROPERTY = "osivia.libelle";
    private static final String VOCABULARY_NAME_WINDOW_PROPERTY_PREFIX = "osivia.vocabName";
    private static final String VOCABULARY_PRESELECTION_1_WINDOW_PROPERTY = "osivia.preselect1";
    private static final String MONOVALUED_SELECTOR_WINDOW_PROPERTY = "osivia.selectorMonoValued";
    private static final String MULTILEVEL_SELECTOR_WINDOW_PROPERTY = "osivia.selectorMultiLevel";
    private static final String OTHERS_OPTION_WINDOW_PROPERTY = "osivia.othersOption";
    private static final String OTHERS_LABEL_WINDOW_PROPERTY = "osivia.othersLabel";
    private static final int MAX_LEVEL = 3;

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        Map selectors;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = request.getParameter("javax.portlet.action");
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                List vocabs;
                window.setProperty(SELECTOR_ID_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("selectorId")));
                window.setProperty(SELECTOR_LABEL_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("libelle")));
                for (int level = 1; level < 4; ++level) {
                    String parameter = "vocabName" + String.valueOf(level);
                    String property = VOCABULARY_NAME_WINDOW_PROPERTY_PREFIX + String.valueOf(level);
                    window.setProperty(property, StringUtils.trimToNull((String)request.getParameter(parameter)));
                }
                window.setProperty(VOCABULARY_PRESELECTION_1_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("preselect1")));
                window.setProperty(MONOVALUED_SELECTOR_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("selectorMonoValued")));
                window.setProperty(MULTILEVEL_SELECTOR_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("selectorMultiLevel")));
                window.setProperty(OTHERS_OPTION_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("othersOption")));
                window.setProperty(OTHERS_LABEL_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("othersLabel")));
                Map selectors2 = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                if (selectors2 != null && (vocabs = (List)selectors2.get(request.getParameter("selectorId"))) != null && vocabs.size() > 0) {
                    vocabs.clear();
                    if (request.getParameter("selectors") != null) {
                        response.setRenderParameter("lastSelectors", request.getParameter("selectors"));
                    }
                    response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors2));
                }
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        } else if ("view".equals(request.getPortletMode().toString()) && (request.getParameter("add.x") != null || request.getParameter("add") != null || request.getParameter("monovaluedSubmit") != null)) {
            String selectorId = window.getProperty(SELECTOR_ID_WINDOW_PROPERTY);
            if (selectorId != null) {
                String vocab3Id;
                String vocab2Id;
                String lastSelectors;
                selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
                ArrayList<String> vocabIds = (ArrayList<String>)selectors.get(selectorId);
                if (vocabIds == null) {
                    vocabIds = new ArrayList<String>();
                    selectors.put(selectorId, vocabIds);
                }
                String[] selectedVocabsEntries = new String[]{request.getParameter("vocab1Id"), request.getParameter("vocab2Id"), request.getParameter("vocab3Id")};
                String separator = "";
                int index = 0;
                String selectedEntries = "";
                String preselect = window.getProperty(VOCABULARY_PRESELECTION_1_WINDOW_PROPERTY);
                if (preselect != null) {
                    selectedVocabsEntries = StringUtils.isNotEmpty((String)request.getParameter("vocab2Id")) ? new String[]{preselect, request.getParameter("vocab2Id"), request.getParameter("vocab3Id")} : new String[]{};
                }
                for (String selectedVocabEntry : selectedVocabsEntries) {
                    if (index > 0) {
                        separator = "/";
                    }
                    if (StringUtils.isNotEmpty((String)selectedVocabEntry)) {
                        selectedEntries = selectedEntries + separator + selectedVocabEntry;
                    }
                    ++index;
                }
                if (request.getParameter("monovaluedSubmit") != null) {
                    vocabIds.clear();
                }
                if (StringUtils.isNotEmpty((String)selectedEntries)) {
                    vocabIds.add(selectedEntries);
                }
                if ((lastSelectors = request.getParameter("selectors")) != null) {
                    response.setRenderParameter("lastSelectors", lastSelectors);
                }
                response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
                response.removePublicRenderParameter("search-filter");
                String vocab1Id = request.getParameter("vocab1Id");
                if (StringUtils.isNotEmpty((String)vocab1Id)) {
                    response.setRenderParameter("vocab1Id", vocab1Id);
                }
                if ((vocab2Id = request.getParameter("vocab2Id")) != null) {
                    response.setRenderParameter("vocab2Id", vocab2Id);
                }
                if ((vocab3Id = request.getParameter("vocab3Id")) != null) {
                    response.setRenderParameter("vocab3Id", vocab3Id);
                }
                request.setAttribute("osivia.unsetMaxMode", (Object)"true");
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
        if ("view".equals(request.getPortletMode().toString()) && "delete".equals(request.getParameter("action"))) {
            String vocab3Id;
            String vocab2Id;
            String vocab1Id;
            String selectorId;
            int occ = new Integer(request.getParameter("occ"));
            selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
            List vocabIds = (List)selectors.get(selectorId = window.getProperty(SELECTOR_ID_WINDOW_PROPERTY));
            if (vocabIds != null && vocabIds.size() > occ) {
                vocabIds.remove(occ);
                response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
                if (request.getParameter("selectors") != null) {
                    response.setRenderParameter("lastSelectors", request.getParameter("selectors"));
                }
                response.removePublicRenderParameter("search-filter");
                request.setAttribute("osivia.unsetMaxMode", (Object)"true");
            }
            if ((vocab1Id = request.getParameter("vocab1Id")) != null) {
                response.setRenderParameter("vocab1Id", vocab1Id);
            }
            if ((vocab2Id = request.getParameter("vocab2Id")) != null) {
                response.setRenderParameter("vocab2Id", vocab2Id);
            }
            if ((vocab3Id = request.getParameter("vocab3Id")) != null) {
                response.setRenderParameter("vocab3Id", vocab3Id);
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String libelle = window.getProperty(SELECTOR_LABEL_WINDOW_PROPERTY);
        if (libelle == null) {
            libelle = "";
        }
        req.setAttribute("libelle", (Object)libelle);
        String selectorId = window.getProperty(SELECTOR_ID_WINDOW_PROPERTY);
        if (selectorId == null) {
            selectorId = "";
        }
        req.setAttribute("selectorId", (Object)selectorId);
        for (int niveau = 1; niveau < 4; ++niveau) {
            String vocabName = window.getProperty(VOCABULARY_NAME_WINDOW_PROPERTY_PREFIX + String.valueOf(niveau));
            if (vocabName == null) {
                vocabName = "";
            }
            req.setAttribute("vocabName" + String.valueOf(niveau), (Object)vocabName);
        }
        String preselect = window.getProperty(VOCABULARY_PRESELECTION_1_WINDOW_PROPERTY);
        if (preselect == null) {
            preselect = "";
        }
        req.setAttribute("preselect1", (Object)preselect);
        String selectorMonoValued = window.getProperty(MONOVALUED_SELECTOR_WINDOW_PROPERTY);
        if (selectorMonoValued == null) {
            selectorMonoValued = "0";
        }
        req.setAttribute("selectorMonoValued", (Object)selectorMonoValued);
        String selectorMultiLevel = window.getProperty(MULTILEVEL_SELECTOR_WINDOW_PROPERTY);
        if (selectorMultiLevel == null) {
            selectorMultiLevel = "0";
        }
        req.setAttribute("selectorMultiLevel", (Object)selectorMultiLevel);
        String othersOption = window.getProperty(OTHERS_OPTION_WINDOW_PROPERTY);
        if (othersOption == null) {
            othersOption = "0";
        }
        req.setAttribute("othersOption", (Object)othersOption);
        String othersLabel = window.getProperty(OTHERS_LABEL_WINDOW_PROPERTY);
        if (othersLabel == null) {
            othersLabel = "";
        }
        req.setAttribute("othersLabel", (Object)othersLabel);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/selectors/vocab/admin.jsp");
        rd.include(req, res);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        try {
            VocabularyEntry vocab;
            String vocabName3;
            response.setContentType("text/html");
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
            request.setAttribute("libelle", (Object)window.getProperty(SELECTOR_LABEL_WINDOW_PROPERTY));
            String selectorId = window.getProperty(SELECTOR_ID_WINDOW_PROPERTY);
            if (selectorId == null) {
                response.getWriter().print("<h2>Identifiant non d\u00e9fini</h2>");
                response.getWriter().close();
                return;
            }
            ArrayList<String> vocabs = new ArrayList<String>();
            String selectorMonoValued = window.getProperty(MONOVALUED_SELECTOR_WINDOW_PROPERTY);
            request.setAttribute("selectorMonoValued", (Object)selectorMonoValued);
            String selectorMultiLevel = window.getProperty(MULTILEVEL_SELECTOR_WINDOW_PROPERTY);
            request.setAttribute("selectorMultiLevel", (Object)selectorMultiLevel);
            String vocabName1 = window.getProperty("osivia.vocabName1");
            if (vocabName1 == null) {
                response.getWriter().print("<h2>Vocabulaire non d\u00e9fini</h2>");
                response.getWriter().close();
                return;
            }
            vocabs.add(vocabName1);
            String vocabName2 = window.getProperty("osivia.vocabName2");
            if (vocabName2 != null) {
                vocabs.add(vocabName2);
            }
            if ((vocabName3 = window.getProperty("osivia.vocabName3")) != null) {
                vocabs.add(vocabName3);
            }
            String vocab1Id = request.getParameter("vocab1Id");
            String preselect1 = window.getProperty(VOCABULARY_PRESELECTION_1_WINDOW_PROPERTY);
            if (StringUtils.isNotEmpty((String)preselect1)) {
                vocab1Id = preselect1;
            }
            String vocab2Id = request.getParameter("vocab2Id");
            String vocab3Id = request.getParameter("vocab3Id");
            Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
            List curSelect = (List)selectors.get(selectorId);
            if (curSelect != null) {
                request.setAttribute("vocabsId", (Object)curSelect);
                if ("1".equals(selectorMonoValued) && curSelect.size() > 0 && !"1".equals(selectorMultiLevel)) {
                    String[] tokens = ((String)curSelect.get(0)).split("/");
                    if (tokens.length > 0) {
                        vocab1Id = tokens[0];
                    }
                    if (tokens.length > 1) {
                        vocab2Id = tokens[1];
                    }
                    if (tokens.length > 2) {
                        vocab3Id = tokens[2];
                    }
                }
            } else {
                if ("1".equals(selectorMonoValued)) {
                    if (preselect1 == null) {
                        vocab1Id = null;
                    }
                    vocab2Id = null;
                    vocab3Id = null;
                }
                request.setAttribute("vocabsId", new ArrayList());
            }
            request.setAttribute("vocab1Id", (Object)vocab1Id);
            request.setAttribute("vocab2Id", (Object)vocab2Id);
            request.setAttribute("vocab3Id", (Object)vocab3Id);
            request.setAttribute("preselect1", (Object)preselect1);
            request.setAttribute("vocabName2", (Object)vocabName2);
            request.setAttribute("vocabName3", (Object)vocabName3);
            String path = "/WEB-INF/jsp/selectors/vocab/view.jsp";
            if ("1".equals(selectorMultiLevel)) {
                path = "/WEB-INF/jsp/selectors/vocab/view-multilevel.jsp";
                vocab = VocabularyHelper.getVocabularyEntry((NuxeoController)nuxeoController, vocabs, (Boolean)true);
            } else {
                vocab = VocabularyHelper.getVocabularyEntry((NuxeoController)nuxeoController, vocabs, (Boolean)false);
            }
            request.setAttribute("vocab1", (Object)vocab);
            if ("1".equals(window.getProperty(OTHERS_OPTION_WINDOW_PROPERTY))) {
                request.setAttribute("othersLabel", (Object)window.getProperty(OTHERS_LABEL_WINDOW_PROPERTY));
            }
            this.getPortletContext().getRequestDispatcher(path).include(request, response);
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }
}

