/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.statistics;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.statistics.StatisticsCmsServiceDelegation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.time.DateUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.statistics.SpaceStatistics;
import org.osivia.portal.api.statistics.SpaceVisits;

public class UpdateSpaceStatisticsCommand
implements INuxeoCommand {
    private final String sessionId;
    private final List<SpaceStatistics> spaceStatistics;

    public UpdateSpaceStatisticsCommand(String sessionId, List<SpaceStatistics> spaceStatistics) {
        this.sessionId = sessionId;
        this.spaceStatistics = spaceStatistics;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        for (SpaceStatistics statistics : this.spaceStatistics) {
            DocRef docRef = new DocRef(statistics.getPath());
            this.updateProperties(nuxeoSession, docRef, statistics);
            this.updateHistory(nuxeoSession, docRef, statistics);
        }
        return null;
    }

    private void updateProperties(Session nuxeoSession, DocRef docRef, SpaceStatistics statistics) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        PropertyMap properties = new PropertyMap();
        properties.set("stats:lastUpdate", statistics.getLastUpdate());
        properties.set("stats:dayVisits", this.convertCurrentVisitsJsonValue(statistics.getCurrentDayVisits()));
        properties.set("stats:monthVisits", this.convertCurrentVisitsJsonValue(statistics.getCurrentMonthVisits()));
        documentService.update(docRef, properties);
    }

    private String convertCurrentVisitsJsonValue(SpaceVisits visits) {
        JSONObject value = new JSONObject();
        if (visits != null) {
            JSONArray identifiers = new JSONArray();
            identifiers.addAll((Collection)visits.getVisitors());
            value.put((Object)"hits", (Object)visits.getHits());
            value.put((Object)"anonymous", (Object)visits.getAnonymousVisitors());
            value.put((Object)"identifiers", (Object)identifiers);
        }
        return value.toString();
    }

    private void updateHistory(Session nuxeoSession, DocRef docRef, SpaceStatistics statistics) throws Exception {
        Date lastUpdate = statistics.getLastUpdate();
        Date previousUpdate = statistics.getPreviousUpdate();
        if (previousUpdate != null && !DateUtils.isSameDay((Date)previousUpdate, (Date)lastUpdate)) {
            this.updateDaysHistory(nuxeoSession, docRef, statistics);
            if (!DateUtils.truncatedEquals((Date)previousUpdate, (Date)lastUpdate, (int)2)) {
                this.updateMonthsHistory(nuxeoSession, docRef, statistics);
            }
        }
    }

    private void updateDaysHistory(Session nuxeoSession, DocRef docRef, SpaceStatistics statistics) throws Exception {
        SpaceVisits historizedDay;
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        Date previousDay = DateUtils.truncate((Date)statistics.getPreviousUpdate(), (int)5);
        Date firstHistoryDay = DateUtils.addDays((Date)DateUtils.truncate((Date)statistics.getLastUpdate(), (int)5), (int)-30);
        Map historizedDays = statistics.getHistorizedDaysVisits();
        JSONArray array = new JSONArray();
        boolean requireUpdate = false;
        for (Map.Entry entry : historizedDays.entrySet()) {
            if (((Date)entry.getKey()).before(firstHistoryDay)) {
                requireUpdate = true;
                continue;
            }
            String date = StatisticsCmsServiceDelegation.DAY_FORMAT.format((Date)entry.getKey());
            JSON json = this.convertHistorizedVisits(date, (SpaceVisits)entry.getValue());
            array.add((Object)json);
        }
        if (requireUpdate) {
            PropertyMap properties = new PropertyMap();
            properties.set("stats:days", array.toString());
            documentService.update(docRef, properties);
        } else if (!previousDay.before(firstHistoryDay) && (historizedDay = (SpaceVisits)historizedDays.get(previousDay)) != null) {
            String date = StatisticsCmsServiceDelegation.DAY_FORMAT.format(previousDay);
            this.addToHistory(nuxeoSession, docRef, "stats:days", date, historizedDay);
        }
    }

    private JSON convertHistorizedVisits(String date, SpaceVisits visits) {
        JSONObject object = new JSONObject();
        object.put((Object)"date", (Object)date);
        object.put((Object)"hits", (Object)visits.getHits());
        object.put((Object)"uniqueVisitors", (Object)visits.getUniqueVisitors());
        return object;
    }

    private void updateMonthsHistory(Session nuxeoSession, DocRef docRef, SpaceStatistics statistics) throws Exception {
        Date previousMonth = DateUtils.truncate((Date)statistics.getPreviousUpdate(), (int)2);
        Map historizedMonths = statistics.getHistorizedMonthsVisits();
        SpaceVisits historizedMonth = (SpaceVisits)historizedMonths.get(previousMonth);
        if (historizedMonth != null) {
            String date = StatisticsCmsServiceDelegation.MONTH_FORMAT.format(previousMonth);
            this.addToHistory(nuxeoSession, docRef, "stats:months", date, historizedMonth);
        }
    }

    private void addToHistory(Session nuxeoSession, DocRef docRef, String xpath, String date, SpaceVisits visits) throws Exception {
        PropertyMap value = new PropertyMap();
        value.set("date", date);
        value.set("hits", Long.valueOf(visits.getHits()));
        value.set("uniqueVisitors", Long.valueOf(visits.getUniqueVisitors()));
        OperationRequest request = nuxeoSession.newRequest("Document.AddComplexProperty");
        request.setInput((OperationInput)docRef);
        request.set("xpath", (Object)xpath);
        request.set("value", (Object)value);
        request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("|");
        builder.append(this.sessionId);
        return builder.toString();
    }
}

